/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.inventory.InventoryIdUtil;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.cmdgw.api.ResponseStatus;
import org.hawkular.cmdgw.api.ServerRefreshIndicator;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.inventory.paths.CanonicalPath;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public abstract class AbstractDMRResourcePathCommand<REQ extends ResourcePathRequest, RESP extends ResourcePathResponse>
extends AbstractResourcePathCommand<REQ, RESP> {
    private static final MsgLogger log = AgentLoggers.getLogger(AbstractDMRResourcePathCommand.class);

    public AbstractDMRResourcePathCommand(String operationName, String entityType) {
        super(operationName, entityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicMessageWithExtraData<RESP> execute(BasicMessageWithExtraData<REQ> envelope, CommandContext context) throws Exception {
        ResourcePathRequest request = (ResourcePathRequest)envelope.getBasicMessage();
        String rawResourcePath = request.getResourcePath();
        log.infoReceivedResourcePathCommand(this.getOperationName(envelope), this.getEntityType(envelope), rawResourcePath);
        Object response = this.createResponse();
        MessageUtils.prepareResourcePathResponse((ResourcePathRequest)request, response);
        BinaryData binaryData = null;
        Object controllerClient = null;
        long timestampBeforeExecution = System.currentTimeMillis();
        try {
            String resourceId;
            this.validate(envelope);
            CanonicalPath canonicalPath = CanonicalPath.fromString((String)rawResourcePath);
            try {
                resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Bad resource path specified in command: " + rawResourcePath);
            }
            InventoryIdUtil.ResourceIdParts idParts = InventoryIdUtil.parseResourceId(resourceId);
            String modelNodePath = idParts.getIdPart();
            this.validate(modelNodePath, envelope);
            String managedServerName = idParts.getManagedServerName();
            EndpointService<DMRNodeLocation, DMRSession> endpointService = context.getAgentCoreEngine().getProtocolServices().getDmrProtocolService().getEndpointServices().get(managedServerName);
            if (endpointService == null) {
                throw new IllegalArgumentException(String.format("Cannot perform [%s] on a [%s] given by inventory path [%s]: unknown managed server [%s]", this.getOperationName(envelope), this.getEntityType(envelope), resourceId, managedServerName));
            }
            this.validate(envelope, endpointService.getMonitoredEndpoint());
            if (this.modifiesResource() && context.getAgentCoreEngine().isImmutable()) {
                throw new IllegalStateException("Command not allowed because the agent is immutable");
            }
            DMRSession session = endpointService.openSession();
            controllerClient = session.getClient();
            binaryData = this.execute((ModelControllerClient)controllerClient, endpointService, modelNodePath, envelope, response, context, session);
            this.success(envelope, response);
        }
        catch (Throwable t) {
            response.setStatus(ResponseStatus.ERROR);
            String formattedTimestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmX").withZone(ZoneOffset.UTC).format(Instant.ofEpochMilli(timestampBeforeExecution));
            String msg = String.format("Could not perform [%s] on a [%s] given by inventory path [%s] requested on [%s]: %s", this.getOperationName(envelope), this.getEntityType(envelope), rawResourcePath, formattedTimestamp, t.toString());
            response.setMessage(msg);
            log.debug(msg, t);
        }
        finally {
            if (controllerClient != null) {
                try {
                    controllerClient.close();
                }
                catch (Exception e) {
                    log.errorCannotClose(e, controllerClient.getClass().getName());
                }
            }
        }
        return new BasicMessageWithExtraData(response, binaryData);
    }

    protected abstract BinaryData execute(ModelControllerClient var1, EndpointService<DMRNodeLocation, DMRSession> var2, String var3, BasicMessageWithExtraData<REQ> var4, RESP var5, CommandContext var6, DMRSession var7) throws Exception;

    protected abstract void validate(String var1, BasicMessageWithExtraData<REQ> var2);

    protected void setServerRefreshIndicator(OperationBuilder.OperationResult<?> opResults, RESP response) {
        Optional processState = opResults.getOptionalProcessState();
        if (processState.isPresent()) {
            try {
                response.setServerRefreshIndicator(ServerRefreshIndicator.fromValue((String)((String)processState.get()).toUpperCase()));
            }
            catch (Exception e) {
                log.warnf("Cannot set server refresh indicator - process state is invalid", e);
            }
        }
    }

    protected void assertNotRename(ModelNode adr, String newName) {
        List adrProps = adr.asPropertyList();
        String nameFromPath = ((Property)adrProps.get(adrProps.size() - 1)).getValue().asString();
        if (!nameFromPath.equals(newName)) {
            String msg = String.format("Renaming a [%s] is not supported. Old name: [%s], new name: [%s]", this.getEntityType(null), nameFromPath, newName);
            throw new IllegalArgumentException(msg);
        }
    }
}

