/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class Operations {
    public static boolean isSuccessfulOutcome(ModelNode outcome) {
        return outcome.get("outcome").asString().equals("success");
    }

    public static ModelNode getFailureDescription(ModelNode result) {
        if (Operations.isSuccessfulOutcome(result)) {
            throw ControllerClientLogger.ROOT_LOGGER.noFailureDescription();
        }
        if (result.hasDefined("failure-description")) {
            return result.get("failure-description");
        }
        return new ModelNode();
    }

    public static ModelNode createAddress(String ... pairs) {
        return Operations.createAddress(Arrays.asList(pairs));
    }

    public static ModelNode createAddress(Iterable<String> pairs) {
        ModelNode address = new ModelNode();
        Iterator<String> iterator = pairs.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = iterator.hasNext() ? iterator.next() : "*";
            address.add(key, value);
        }
        return address;
    }

    public static ModelNode getOperationAddress(ModelNode op) {
        return op.hasDefined("address") ? op.get("address") : new ModelNode();
    }

    public static String getOperationName(ModelNode op) {
        if (op.hasDefined("operation")) {
            return op.get("operation").asString();
        }
        throw ControllerClientLogger.ROOT_LOGGER.operationNameNotFound();
    }

    public static ModelNode createAddOperation(ModelNode address) {
        return Operations.createOperation("add", address);
    }

    public static ModelNode createRemoveOperation(ModelNode address) {
        return Operations.createOperation("remove", address);
    }

    public static ModelNode createCompositeOperation() {
        ModelNode op = Operations.createOperation("composite");
        op.get("rollback-on-runtime-failure").set(true);
        op.get("steps").setEmptyList();
        return op;
    }

    public static ModelNode createReadAttributeOperation(ModelNode address, String attributeName) {
        ModelNode op = Operations.createOperation("read-attribute", address);
        op.get("name").set(attributeName);
        return op;
    }

    public static ModelNode createReadResourceOperation(ModelNode address) {
        return Operations.createReadResourceOperation(address, false);
    }

    public static ModelNode createReadResourceOperation(ModelNode address, boolean recursive) {
        ModelNode op = Operations.createOperation("read-resource", address);
        op.get("recursive").set(recursive);
        return op;
    }

    public static ModelNode createUndefineAttributeOperation(ModelNode address, String attributeName) {
        ModelNode op = Operations.createOperation("undefine-attribute", address);
        op.get("name").set(attributeName);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, boolean value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get("value").set(value);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, int value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get("value").set(value);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, long value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get("value").set(value);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, String value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get("value").set(value);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, ModelNode value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get("value").set(value);
        return op;
    }

    public static ModelNode createOperation(String operation) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operation);
        op.get("address").setEmptyList();
        return op;
    }

    public static ModelNode createOperation(String operation, ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw ControllerClientLogger.ROOT_LOGGER.invalidAddressType();
        }
        ModelNode op = Operations.createOperation(operation);
        op.get("address").set(address);
        return op;
    }

    public static ModelNode readResult(ModelNode result) {
        return result.hasDefined("result") ? result.get("result") : new ModelNode();
    }

    private static ModelNode createNoValueWriteOperation(ModelNode address, String attributeName) {
        ModelNode op = Operations.createOperation("write-attribute", address);
        op.get("name").set(attributeName);
        return op;
    }

    public static class CompositeOperationBuilder
    extends OperationBuilder {
        private final ModelNode op;

        private CompositeOperationBuilder(ModelNode op) {
            super(op);
            this.op = op;
        }

        private CompositeOperationBuilder(ModelNode op, boolean autoCloseStreams) {
            super(op, autoCloseStreams);
            this.op = op;
        }

        public static CompositeOperationBuilder create() {
            return new CompositeOperationBuilder(Operations.createCompositeOperation());
        }

        public static CompositeOperationBuilder create(boolean autoCloseStreams) {
            return new CompositeOperationBuilder(Operations.createCompositeOperation(), autoCloseStreams);
        }

        public CompositeOperationBuilder addStep(ModelNode op) {
            this.op.get("steps").add(op);
            return this;
        }

        @Override
        public CompositeOperationBuilder addFileAsAttachment(File file) {
            super.addFileAsAttachment(file);
            return this;
        }

        @Override
        public CompositeOperationBuilder addInputStream(InputStream in) {
            super.addInputStream(in);
            return this;
        }
    }
}

