/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.wildfly.plugin.core.Assertions;
import org.wildfly.plugin.core.DeploymentDescription;

public class SimpleDeploymentDescription
implements DeploymentDescription,
Comparable<SimpleDeploymentDescription> {
    private final String name;
    private final Set<String> serverGroups;

    private SimpleDeploymentDescription(String name) {
        this.name = name;
        this.serverGroups = new LinkedHashSet<String>();
    }

    public static SimpleDeploymentDescription of(String name) {
        return new SimpleDeploymentDescription(Assertions.requiresNotNullOrNotEmptyParameter(name, "name"));
    }

    public static SimpleDeploymentDescription of(String name, Set<String> serverGroups) {
        SimpleDeploymentDescription result = SimpleDeploymentDescription.of(name);
        if (serverGroups != null) {
            result.addServerGroups(serverGroups);
        }
        return result;
    }

    public SimpleDeploymentDescription addServerGroup(String serverGroup) {
        this.serverGroups.add(serverGroup);
        return this;
    }

    public SimpleDeploymentDescription addServerGroups(String ... serverGroups) {
        return this.addServerGroups(Arrays.asList(serverGroups));
    }

    public SimpleDeploymentDescription addServerGroups(Collection<String> serverGroups) {
        this.serverGroups.addAll(serverGroups);
        return this;
    }

    @Override
    public Set<String> getServerGroups() {
        return Collections.unmodifiableSet(this.serverGroups);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(SimpleDeploymentDescription o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleDeploymentDescription)) {
            return false;
        }
        SimpleDeploymentDescription other = (SimpleDeploymentDescription)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(SimpleDeploymentDescription.class.getSimpleName());
        result.append('(');
        result.append("name=").append(this.name);
        if (!this.serverGroups.isEmpty()) {
            result.append(", serverGroups=").append(this.serverGroups);
        }
        return result.append(')').toString();
    }
}

