/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsMessageProducer;
import org.jboss.resource.adapter.jms.JmsSession;

public class JmsTopicPublisher
extends JmsMessageProducer
implements TopicPublisher {
    private static final Logger log = Logger.getLogger(JmsTopicPublisher.class);
    private boolean trace = log.isTraceEnabled();

    public JmsTopicPublisher(TopicPublisher producer, JmsSession session) {
        super((MessageProducer)producer, session);
    }

    public Topic getTopic() throws JMSException {
        return ((TopicPublisher)this.producer).getTopic();
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        this.session.unlock();
        if (this.trace) {
            log.trace((Object)("send " + this + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive));
        }
        ((TopicPublisher)this.producer).publish(message, deliveryMode, priority, timeToLive);
        if (this.trace) {
            log.trace((Object)("sent " + this + " result=" + message));
        }
    }

    public void publish(Message message) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " message=" + message));
            }
            ((TopicPublisher)this.producer).publish(message);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Topic destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive));
            }
            ((TopicPublisher)this.producer).publish(destination, message, deliveryMode, priority, timeToLive);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public void publish(Topic destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " destination=" + destination + " message=" + message));
            }
            ((TopicPublisher)this.producer).publish(destination, message);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }
}

