/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.Collection;
import java.util.Map;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.ExecuteOperationRequest;
import org.hawkular.cmdgw.api.ExecuteOperationResponse;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.jboss.as.controller.client.ModelControllerClient;

public class ExecuteOperationCommand
extends AbstractResourcePathCommand<ExecuteOperationRequest, ExecuteOperationResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(ExecuteOperationCommand.class);
    public static final Class<ExecuteOperationRequest> REQUEST_CLASS = ExecuteOperationRequest.class;

    public ExecuteOperationCommand() {
        super("Execute Operation", "DMR Node");
    }

    @Override
    protected ExecuteOperationResponse createResponse() {
        return new ExecuteOperationResponse();
    }

    @Override
    protected String getOperationName(BasicMessageWithExtraData<ExecuteOperationRequest> envelope) {
        return ((ExecuteOperationRequest)envelope.getBasicMessage()).getOperationName();
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<ExecuteOperationRequest> envelope) {
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<ExecuteOperationRequest> envelope, ExecuteOperationResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        ExecuteOperationRequest request = (ExecuteOperationRequest)envelope.getBasicMessage();
        CanonicalPath canonicalPath = CanonicalPath.fromString((String)request.getResourcePath());
        String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
        ResourceManager<DMRNodeLocation> resourceManager = endpointService.getResourceManager();
        Resource<DMRNodeLocation> resource = resourceManager.getResource(new ID(resourceId));
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Cannot execute operation: unknown resource [%s]", request.getResourcePath()));
        }
        DMRNodeLocation opLocation = null;
        String actualOperationName = null;
        String requestedOpName = request.getOperationName();
        Collection<Operation<DMRNodeLocation>> ops = resource.getResourceType().getOperations();
        log.tracef("Searching for operation [%s] among operations [%s] for resource [%s].", requestedOpName, ops, resource.getID());
        for (Operation<DMRNodeLocation> op : ops) {
            if (!requestedOpName.equals(op.getName().getNameString())) continue;
            opLocation = (DMRNodeLocation)dmrContext.getLocationResolver().absolutize(resource.getLocation(), op.getLocation());
            actualOperationName = op.getOperationName();
            break;
        }
        if (opLocation == null) {
            throw new IllegalArgumentException(String.format("Cannot execute operation: unknown operation [%s] for resource [%s]", request.getOperationName(), resource));
        }
        response.setOperationName(request.getOperationName());
        OperationBuilder.ByNameOperationBuilder operation = (OperationBuilder.ByNameOperationBuilder)OperationBuilder.byName(actualOperationName).address(opLocation.getPathAddress());
        Map params = request.getParameters();
        if (params != null) {
            for (Map.Entry param : params.entrySet()) {
                operation.attribute((String)param.getKey(), (String)param.getValue());
            }
        }
        OperationBuilder.OperationResult opResult = operation.execute(controllerClient).assertSuccess();
        this.setServerRefreshIndicator(opResult, response);
        endpointService.discoverAll();
        return null;
    }

    @Override
    protected void validate(BasicMessageWithExtraData<ExecuteOperationRequest> envelope, MonitoredEndpoint endpoint) {
    }
}

