/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.cmdgw.api.ResponseStatus;
import org.hawkular.cmdgw.api.StatisticsControlRequest;
import org.hawkular.cmdgw.api.StatisticsControlResponse;
import org.hawkular.cmdgw.api.StatisticsSetting;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.dmrclient.JBossASClient;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class StatisticsControlCommand
extends AbstractResourcePathCommand<StatisticsControlRequest, StatisticsControlResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(StatisticsControlCommand.class);
    public static final Class<StatisticsControlRequest> REQUEST_CLASS = StatisticsControlRequest.class;

    public StatisticsControlCommand() {
        super("Statistics Control", "Server");
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<StatisticsControlRequest> envelope, StatisticsControlResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        StatisticsSetting currentState;
        String addr;
        List<String> list;
        StatisticsControlRequest request = (StatisticsControlRequest)envelope.getBasicMessage();
        String resourcePath = request.getResourcePath();
        CanonicalPath canonicalPath = CanonicalPath.fromString((String)resourcePath);
        String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
        ResourceManager<DMRNodeLocation> resourceManager = endpointService.getResourceManager();
        Resource<DMRNodeLocation> resource = resourceManager.getResource(new ID(resourceId));
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Cannot change statistics flags: unknown resource [%s]", resourcePath));
        }
        if (!((DMRNodeLocation)resource.getLocation()).getPathAddress().toCLIStyleString().equals("/")) {
            throw new IllegalArgumentException(String.format("Cannot change statistics flags: not a server resource [%s]", resourcePath));
        }
        MessageUtils.prepareResourcePathResponse((ResourcePathRequest)request, (ResourcePathResponse)response);
        Optional<Boolean> datasources = this.getStatisticsEnabledFlag(request.getDatasources());
        Optional<Boolean> ejb3 = this.getStatisticsEnabledFlag(request.getEjb3());
        Optional<Boolean> infinispan = this.getStatisticsEnabledFlag(request.getInfinispan());
        Optional<Boolean> messaging = this.getStatisticsEnabledFlag(request.getMessaging());
        Optional<Boolean> transactions = this.getStatisticsEnabledFlag(request.getTransactions());
        Optional<Boolean> web = this.getStatisticsEnabledFlag(request.getWeb());
        boolean somethingToDo = false;
        OperationBuilder.CompositeOperationBuilder batch = OperationBuilder.composite();
        if (datasources.isPresent()) {
            somethingToDo = true;
            List<String> dsList = this.getChildrenNames(PathAddress.parseCLIStyleAddress((String)"/subsystem=datasources"), "data-source", controllerClient);
            List<String> xaList = this.getChildrenNames(PathAddress.parseCLIStyleAddress((String)"/subsystem=datasources"), "xa-data-source", controllerClient);
            for (String ds : dsList) {
                String dsAddr = String.format("/subsystem=datasources/data-source=%s", ds);
                ((OperationBuilder.WriteAttributeOperationBuilder)batch.writeAttribute().address(PathAddress.parseCLIStyleAddress((String)dsAddr))).attribute("statistics-enabled", datasources.get().toString()).parentBuilder();
            }
            for (String xa : xaList) {
                String xaAddr = String.format("/subsystem=datasources/xa-data-source=%s", xa);
                ((OperationBuilder.WriteAttributeOperationBuilder)batch.writeAttribute().address(PathAddress.parseCLIStyleAddress((String)xaAddr))).attribute("statistics-enabled", datasources.get().toString()).parentBuilder();
            }
        }
        if (ejb3.isPresent()) {
            somethingToDo = true;
            ((OperationBuilder.WriteAttributeOperationBuilder)batch.writeAttribute().address(PathAddress.parseCLIStyleAddress((String)"/subsystem=ejb3"))).attribute("enable-statistics", ejb3.get().toString()).parentBuilder();
        }
        if (infinispan.isPresent()) {
            somethingToDo = true;
            list = this.getChildrenNames(PathAddress.parseCLIStyleAddress((String)"/subsystem=infinispan"), "cache-container", controllerClient);
            for (String name : list) {
                addr = String.format("/subsystem=infinispan/cache-container=%s", name);
                ((OperationBuilder.WriteAttributeOperationBuilder)batch.writeAttribute().address(PathAddress.parseCLIStyleAddress((String)addr))).attribute("statistics-enabled", infinispan.get().toString()).parentBuilder();
            }
        }
        if (messaging.isPresent()) {
            somethingToDo = true;
            list = this.getChildrenNames(PathAddress.parseCLIStyleAddress((String)"/subsystem=messaging-activemq"), "server", controllerClient);
            for (String name : list) {
                addr = String.format("/subsystem=messaging-activemq/server=%s", name);
                ((OperationBuilder.WriteAttributeOperationBuilder)batch.writeAttribute().address(PathAddress.parseCLIStyleAddress((String)addr))).attribute("statistics-enabled", messaging.get().toString()).parentBuilder();
            }
        }
        if (transactions.isPresent()) {
            somethingToDo = true;
            ((OperationBuilder.WriteAttributeOperationBuilder)batch.writeAttribute().address(PathAddress.parseCLIStyleAddress((String)"/subsystem=transactions"))).attribute("enable-statistics", transactions.get().toString()).parentBuilder();
        }
        if (web.isPresent()) {
            somethingToDo = true;
            ((OperationBuilder.WriteAttributeOperationBuilder)batch.writeAttribute().address(PathAddress.parseCLIStyleAddress((String)"/subsystem=undertow"))).attribute("statistics-enabled", web.get().toString()).parentBuilder();
        }
        if (somethingToDo) {
            OperationBuilder.OperationResult opResult = batch.execute(controllerClient).assertSuccess();
            this.setServerRefreshIndicator(opResult, response);
        }
        if (request.getDatasources() != null) {
            response.setDatasources(request.getDatasources());
        } else {
            currentState = this.getCurrentStateFromServer(controllerClient, "/subsystem=datasources/data-source=*", "statistics-enabled");
            if (currentState == null) {
                currentState = this.getCurrentStateFromServer(controllerClient, "/subsystem=datasources/xa-data-source=*", "statistics-enabled");
            }
            response.setDatasources(currentState);
        }
        if (request.getEjb3() != null) {
            response.setEjb3(request.getEjb3());
        } else {
            currentState = this.getCurrentStateFromServer(controllerClient, "/subsystem=ejb3", "enable-statistics");
            response.setEjb3(currentState);
        }
        if (request.getInfinispan() != null) {
            response.setInfinispan(request.getInfinispan());
        } else {
            currentState = this.getCurrentStateFromServer(controllerClient, "/subsystem=infinispan/cache-container=*", "statistics-enabled");
            response.setInfinispan(currentState);
        }
        if (request.getMessaging() != null) {
            response.setMessaging(request.getMessaging());
        } else {
            currentState = this.getCurrentStateFromServer(controllerClient, "/subsystem=messaging-activemq/server=*", "statistics-enabled");
            response.setMessaging(currentState);
        }
        if (request.getTransactions() != null) {
            response.setTransactions(request.getTransactions());
        } else {
            currentState = this.getCurrentStateFromServer(controllerClient, "/subsystem=transactions", "enable-statistics");
            response.setTransactions(currentState);
        }
        if (request.getWeb() != null) {
            response.setWeb(request.getWeb());
        } else {
            currentState = this.getCurrentStateFromServer(controllerClient, "/subsystem=undertow", "statistics-enabled");
            response.setWeb(currentState);
        }
        return null;
    }

    private StatisticsSetting getCurrentStateFromServer(ModelControllerClient controllerClient, String addr, String attribName) {
        try {
            new OperationBuilder();
            ModelNode result = ((OperationBuilder.ReadAttributeOperationBuilder)OperationBuilder.readAttribute().address(PathAddress.parseCLIStyleAddress((String)addr))).name(attribName).execute(controllerClient).assertSuccess().getResultNode();
            log.debugf("Getting current statistics flag for address [%s][%s]. Type=[%s]:%s", new Object[]{addr, attribName, result.getType(), result.toJSONString(true)});
            if (result.getType() == ModelType.LIST) {
                Boolean aggregate = null;
                for (ModelNode resourceNode : result.asList()) {
                    ModelNode resourceResult = JBossASClient.getResults((ModelNode)resourceNode);
                    boolean booleanFlag = resourceResult.asBoolean();
                    if (aggregate == null) {
                        aggregate = booleanFlag;
                        continue;
                    }
                    if (aggregate == booleanFlag) continue;
                    return null;
                }
                if (aggregate == null) {
                    return null;
                }
                return aggregate != false ? StatisticsSetting.ENABLED : StatisticsSetting.DISABLED;
            }
            return result.asBoolean() ? StatisticsSetting.ENABLED : StatisticsSetting.DISABLED;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Optional<Boolean> getStatisticsEnabledFlag(StatisticsSetting setting) {
        if (setting == null) {
            return Optional.empty();
        }
        return Optional.of(setting == StatisticsSetting.ENABLED);
    }

    private List<String> getChildrenNames(PathAddress parentPath, String childType, ModelControllerClient mcc) {
        return ((OperationBuilder.StringListOperationResult)((OperationBuilder.StringListOperationResult)((OperationBuilder.ReadChildrenNamesOperationBuilder)OperationBuilder.readChildrenNames().address(parentPath)).childType(childType).execute(mcc)).assertSuccess()).getList();
    }

    @Override
    protected void success(BasicMessageWithExtraData<StatisticsControlRequest> envelope, StatisticsControlResponse response) {
        HashMap settings = new HashMap();
        settings.put(null, new ArrayList());
        settings.put(StatisticsSetting.ENABLED, new ArrayList());
        settings.put(StatisticsSetting.DISABLED, new ArrayList());
        StatisticsControlRequest request = (StatisticsControlRequest)envelope.getBasicMessage();
        ((ArrayList)settings.get(request.getDatasources())).add("datasources");
        ((ArrayList)settings.get(request.getEjb3())).add("EJB3");
        ((ArrayList)settings.get(request.getInfinispan())).add("infinispan");
        ((ArrayList)settings.get(request.getMessaging())).add("messaging");
        ((ArrayList)settings.get(request.getTransactions())).add("transactions");
        ((ArrayList)settings.get(request.getWeb())).add("web");
        String msg = String.format("Statistics for server [%s] have been enabled for subsystems %s, disabled for subsystems %s, and left as-is for subsystems %s", ((StatisticsControlRequest)envelope.getBasicMessage()).getResourcePath(), settings.get(StatisticsSetting.ENABLED), settings.get(StatisticsSetting.DISABLED), settings.get(null));
        response.setMessage(msg);
        response.setStatus(ResponseStatus.OK);
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<StatisticsControlRequest> envelope) {
    }

    @Override
    protected void validate(BasicMessageWithExtraData<StatisticsControlRequest> envelope, MonitoredEndpoint endpoint) {
    }

    @Override
    protected StatisticsControlResponse createResponse() {
        return new StatisticsControlResponse();
    }
}

