/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.diagnostics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;

public class DiagnosticsImpl
implements Diagnostics {
    private final MetricRegistry metricsRegistry;
    private final ProtocolDiagnostics dmrDiagnostics;
    private final ProtocolDiagnostics jmxDiagnostics;
    private final ProtocolDiagnostics platformDiagnostics;
    private final Meter storageError;
    private final Counter metricsStorageBuffer;
    private final Meter metricRate;
    private final Counter availStorageBuffer;
    private final Meter availRate;
    private final Counter inventoryStorageBuffer;
    private final Meter inventoryRate;
    private final Timer inventoryStorageRequestTimer;

    public static String name(String feedId, String name) {
        return MetricRegistry.name((String)(feedId + ".diagnostics." + name), (String[])new String[0]);
    }

    public DiagnosticsImpl(MonitorServiceConfiguration.DiagnosticsConfiguration config, MetricRegistry registry, String feedId) {
        this.dmrDiagnostics = DiagnosticsImpl.newDiagnostics("dmr", feedId, registry);
        this.jmxDiagnostics = DiagnosticsImpl.newDiagnostics("jmx", feedId, registry);
        this.platformDiagnostics = DiagnosticsImpl.newDiagnostics("platform", feedId, registry);
        this.storageError = registry.meter(DiagnosticsImpl.name(feedId, "storage.error-rate"));
        this.metricsStorageBuffer = registry.counter(DiagnosticsImpl.name(feedId, "metrics.storage-buffer-size"));
        this.metricRate = registry.meter(DiagnosticsImpl.name(feedId, "metric.rate"));
        this.availStorageBuffer = registry.counter(DiagnosticsImpl.name(feedId, "avail.storage-buffer-size"));
        this.availRate = registry.meter(DiagnosticsImpl.name(feedId, "avail.rate"));
        this.inventoryStorageBuffer = registry.counter(DiagnosticsImpl.name(feedId, "inventory.storage-buffer-size"));
        this.inventoryRate = registry.meter(DiagnosticsImpl.name(feedId, "inventory.rate"));
        this.inventoryStorageRequestTimer = registry.timer(DiagnosticsImpl.name(feedId, "inventory.storage-request-timer"));
        this.metricsRegistry = registry;
    }

    private static ProtocolDiagnostics newDiagnostics(String prefix, String feedId, MetricRegistry registry) {
        return new ProtocolDiagnostics(registry.timer(DiagnosticsImpl.name(feedId, prefix + ".request-timer")), registry.meter(DiagnosticsImpl.name(feedId, prefix + ".error-rate")), registry.timer(DiagnosticsImpl.name(feedId, prefix + ".full-discovery-scan-timer")));
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.metricsRegistry;
    }

    @Override
    public ProtocolDiagnostics getDMRDiagnostics() {
        return this.dmrDiagnostics;
    }

    @Override
    public ProtocolDiagnostics getJMXDiagnostics() {
        return this.jmxDiagnostics;
    }

    @Override
    public ProtocolDiagnostics getPlatformDiagnostics() {
        return this.platformDiagnostics;
    }

    @Override
    public Meter getStorageErrorRate() {
        return this.storageError;
    }

    @Override
    public Counter getMetricsStorageBufferSize() {
        return this.metricsStorageBuffer;
    }

    @Override
    public Meter getMetricRate() {
        return this.metricRate;
    }

    @Override
    public Counter getAvailStorageBufferSize() {
        return this.availStorageBuffer;
    }

    @Override
    public Meter getAvailRate() {
        return this.availRate;
    }

    @Override
    public Counter getInventoryStorageBufferSize() {
        return this.inventoryStorageBuffer;
    }

    @Override
    public Meter getInventoryRate() {
        return this.inventoryRate;
    }

    @Override
    public Timer getInventoryStorageRequestTimer() {
        return this.inventoryStorageRequestTimer;
    }
}

