/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.api.HawkularWildFlyAgentContext;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.MonitorServiceConfigurationBuilder;
import org.hawkular.agent.monitor.extension.SubsystemAttributes;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.service.MonitorService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class SubsystemAdd
extends AbstractAddStepHandler {
    private static final MsgLogger log = AgentLoggers.getLogger(SubsystemAdd.class);
    static final SubsystemAdd INSTANCE = new SubsystemAdd();

    private SubsystemAdd() {
        super(SubsystemAttributes.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode subsystemConfig = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        MonitorServiceConfiguration configuration = new MonitorServiceConfigurationBuilder(subsystemConfig, context).build();
        if (!configuration.isSubsystemEnabled()) {
            log.infoSubsystemDisabled();
            return;
        }
        this.createService(context.getServiceTarget(), configuration);
    }

    private void createService(ServiceTarget target, MonitorServiceConfiguration configuration) {
        boolean bindJndi;
        MonitorService service = new MonitorService(configuration);
        ServiceBuilder svcBuilder = target.addService(SubsystemExtension.SERVICE_NAME, (Service)service);
        svcBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        service.addDependencies((ServiceBuilder<MonitorService>)svcBuilder);
        String jndiName = configuration.getApiJndi();
        boolean bl = bindJndi = jndiName != null && !jndiName.isEmpty();
        if (bindJndi) {
            HawkularWildFlyAgentContext jndiObject = service.getHawkularMonitorContext();
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            BinderService binderService = new BinderService(bindInfo.getBindName());
            ImmediateManagedReferenceFactory valueMRF = new ImmediateManagedReferenceFactory((Object)jndiObject);
            String jndiObjectClassName = HawkularWildFlyAgentContext.class.getName();
            ServiceName binderServiceName = bindInfo.getBinderServiceName();
            ServiceBuilder binderBuilder = target.addService(binderServiceName, (Service)binderService).addInjection((Injector)binderService.getManagedObjectInjector(), (Object)valueMRF).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener((ServiceListener)new JndiBindListener(jndiName, jndiObjectClassName));
            svcBuilder.addDependency(binderServiceName);
            binderBuilder.install();
        }
        svcBuilder.install();
    }

    private final class JndiBindListener
    extends AbstractServiceListener<Object> {
        private final String jndiName;
        private final String jndiObjectClassName;

        public JndiBindListener(String jndiName, String jndiObjectClassName) {
            this.jndiName = jndiName;
            this.jndiObjectClassName = jndiObjectClassName;
        }

        public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
            switch (transition) {
                case STARTING_to_UP: {
                    log.infoBindJndiResource(this.jndiName, this.jndiObjectClassName);
                    break;
                }
                case START_REQUESTED_to_DOWN: {
                    log.infoUnbindJndiResource(this.jndiName);
                    break;
                }
                case REMOVING_to_REMOVED: {
                    log.infoUnbindJndiResource(this.jndiName);
                    break;
                }
            }
        }
    }
}

