/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.ConnectionData;

public final class MonitoredEndpoint {
    private final MonitorServiceConfiguration.EndpointConfiguration endpointConfiguration;
    private final SSLContext sslContext;

    public static MonitoredEndpoint of(MonitorServiceConfiguration.EndpointConfiguration endpointConfiguration, SSLContext sslContext) {
        return new MonitoredEndpoint(endpointConfiguration, sslContext);
    }

    private MonitoredEndpoint(MonitorServiceConfiguration.EndpointConfiguration endpointConfiguration, SSLContext sslContext) {
        if (endpointConfiguration == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] without a config");
        }
        if (endpointConfiguration.getName() == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] with a null name");
        }
        this.endpointConfiguration = endpointConfiguration;
        this.sslContext = sslContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MonitoredEndpoint)) {
            return false;
        }
        return this.endpointConfiguration.getName().equals(((MonitoredEndpoint)obj).endpointConfiguration.getName());
    }

    public MonitorServiceConfiguration.EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public ConnectionData getConnectionData() {
        return this.endpointConfiguration.getConnectionData();
    }

    public String getName() {
        return this.endpointConfiguration.getName();
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public int hashCode() {
        return this.endpointConfiguration.getName().hashCode();
    }

    public boolean isLocal() {
        return this.endpointConfiguration.getConnectionData() == null;
    }

    public String toString() {
        return String.format("Endpoint[%s]:[%s]", this.getName(), this.getConnectionData());
    }
}

