/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.AvailDataPayloadBuilder;
import org.hawkular.agent.monitor.util.Util;

public class AvailDataPayloadBuilderImpl
implements AvailDataPayloadBuilder {
    private Map<String, List<Map<String, Object>>> allAvail = new HashMap<String, List<Map<String, Object>>>();
    private int count = 0;

    @Override
    public void addDataPoint(String key, long timestamp, Avail value) {
        List<Map<String, Object>> data = this.allAvail.get(key);
        if (data == null) {
            data = new ArrayList<Map<String, Object>>();
            this.allAvail.put(key, data);
        }
        HashMap<String, Object> timestampAndValue = new HashMap<String, Object>(2);
        timestampAndValue.put("timestamp", new Long(timestamp));
        timestampAndValue.put("value", value.name().toLowerCase());
        data.add(timestampAndValue);
        ++this.count;
    }

    public List<Map<String, Object>> toObjectPayload() {
        ArrayList<Map<String, Object>> fullMessageObject = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, List<Map<String, Object>>> availEntry : this.allAvail.entrySet()) {
            HashMap<String, Object> availKeyAndData = new HashMap<String, Object>(2);
            availKeyAndData.put("id", availEntry.getKey());
            availKeyAndData.put("data", availEntry.getValue());
            fullMessageObject.add(availKeyAndData);
        }
        return fullMessageObject;
    }

    @Override
    public String toPayload() {
        String jsonPayload = Util.toJson(this.toObjectPayload());
        return jsonPayload;
    }

    @Override
    public int getNumberDataPoints() {
        return this.count;
    }
}

