/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.metrics.client.common.MetricType;

public class MetricDataPayloadBuilderImpl
implements MetricDataPayloadBuilder {
    private Map<String, List<Map<String, Number>>> allGauges = new HashMap<String, List<Map<String, Number>>>();
    private Map<String, List<Map<String, Number>>> allCounters = new HashMap<String, List<Map<String, Number>>>();
    private int count = 0;

    @Override
    public void addDataPoint(String key, long timestamp, double value, MetricType metricType) {
        Number valueObject;
        Map<String, List<Map<String, Number>>> map;
        switch (metricType) {
            case GAUGE: {
                map = this.allGauges;
                valueObject = value;
                break;
            }
            case COUNTER: {
                map = this.allCounters;
                valueObject = Double.valueOf(value).longValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metric type: " + metricType);
            }
        }
        List<Map<String, Number>> data = map.get(key);
        if (data == null) {
            data = new ArrayList<Map<String, Number>>();
            map.put(key, data);
        }
        HashMap<String, Number> timestampAndValue = new HashMap<String, Number>(2);
        timestampAndValue.put("timestamp", timestamp);
        timestampAndValue.put("value", valueObject);
        data.add(timestampAndValue);
        ++this.count;
    }

    public Map<String, List<Map<String, Object>>> toObjectPayload() {
        HashMap<String, Object> metricKeyAndData;
        HashMap<String, List<Map<String, Object>>> fullMessageObject = new HashMap<String, List<Map<String, Object>>>();
        ArrayList allOfSpecificType = new ArrayList();
        fullMessageObject.put("gauges", allOfSpecificType);
        for (Map.Entry<String, List<Map<String, Number>>> metricEntry : this.allGauges.entrySet()) {
            metricKeyAndData = new HashMap<String, Object>(2);
            metricKeyAndData.put("id", metricEntry.getKey());
            metricKeyAndData.put("data", metricEntry.getValue());
            allOfSpecificType.add(metricKeyAndData);
        }
        allOfSpecificType = new ArrayList();
        fullMessageObject.put("counters", allOfSpecificType);
        for (Map.Entry<String, List<Map<String, Number>>> metricEntry : this.allCounters.entrySet()) {
            metricKeyAndData = new HashMap(2);
            metricKeyAndData.put("id", metricEntry.getKey());
            metricKeyAndData.put("data", metricEntry.getValue());
            allOfSpecificType.add(metricKeyAndData);
        }
        allOfSpecificType = new ArrayList();
        fullMessageObject.put("availabilities", allOfSpecificType);
        return fullMessageObject;
    }

    @Override
    public String toPayload() {
        String jsonPayload = Util.toJson(this.toObjectPayload());
        return jsonPayload;
    }

    @Override
    public int getNumberDataPoints() {
        return this.count;
    }
}

