/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.dynamicprotocol.DynamicEndpointService;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicProtocolService;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicProtocolServices;
import org.hawkular.agent.monitor.extension.MonitorServiceAddStepHandler;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.RemotePrometheusAttributes;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.util.Util;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class RemotePrometheusAdd
extends MonitorServiceAddStepHandler {
    private static final MsgLogger log = AgentLoggers.getLogger(RemotePrometheusAdd.class);
    public static final RemotePrometheusAdd INSTANCE = new RemotePrometheusAdd();

    private RemotePrometheusAdd() {
        super(RemotePrometheusAttributes.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            return;
        }
        MonitorService monitorService = this.getMonitorService(context);
        if (monitorService == null) {
            return;
        }
        MonitorServiceConfiguration config = Util.getMonitorServiceConfiguration(context);
        DynamicProtocolServices newServices = monitorService.createDynamicProtocolServicesBuilder().prometheusDynamicProtocolService(config.getPrometheusConfiguration(), monitorService.getHawkularMonitorContext()).build();
        DynamicEndpointService endpointService = newServices.getPrometheusProtocolService().getDynamicEndpointServices().get(context.getCurrentAddressValue());
        DynamicProtocolService promService = monitorService.getDynamicProtocolServices().getPrometheusProtocolService();
        promService.add(endpointService);
    }
}

