/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ws.WebSocketCall;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.util.BaseHttpClientGenerator;

public class HttpClientBuilder
extends BaseHttpClientGenerator {
    public HttpClientBuilder(MonitorServiceConfiguration.StorageAdapterConfiguration storageAdapter, SSLContext sslContext) {
        super(new BaseHttpClientGenerator.Configuration.Builder().username(storageAdapter.getUsername()).password(storageAdapter.getPassword()).useSsl(storageAdapter.isUseSSL()).keystorePath(storageAdapter.getKeystorePath()).keystorePassword(storageAdapter.getKeystorePassword()).connectTimeout(storageAdapter.getConnectTimeoutSeconds()).readTimeout(storageAdapter.getReadTimeoutSeconds()).build());
    }

    public Request buildJsonGetRequest(String url, Map<String, String> headers) {
        String base64Credentials = this.buildBase64Credentials();
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return requestBuilder.get().build();
    }

    public Request buildJsonDeleteRequest(String url, Map<String, String> headers) {
        String base64Credentials = this.buildBase64Credentials();
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return requestBuilder.delete().build();
    }

    public Request buildJsonPostRequest(String url, Map<String, String> headers, String jsonPayload) {
        String base64Credentials = this.buildBase64Credentials();
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonPayload);
        return requestBuilder.post(body).build();
    }

    public Request buildJsonPutRequest(String url, Map<String, String> headers, String jsonPayload) {
        String base64Credentials = this.buildBase64Credentials();
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonPayload);
        return requestBuilder.put(body).build();
    }

    public WebSocketCall createWebSocketCall(String url, Map<String, String> headers) {
        String base64Credentials = this.buildBase64Credentials();
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        Request request = requestBuilder.build();
        WebSocketCall wsc = WebSocketCall.create((OkHttpClient)this.getHttpClient(), (Request)request);
        return wsc;
    }
}

