/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.service.MonitorService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;

public class OperationFullDiscoveryScan
implements OperationStepHandler {
    public void execute(OperationContext opContext, ModelNode model) throws OperationFailedException {
        try {
            ServiceName name = SubsystemExtension.SERVICE_NAME;
            ServiceRegistry serviceRegistry = opContext.getServiceRegistry(true);
            MonitorService service = (MonitorService)serviceRegistry.getRequiredService(name).getValue();
            if (!service.isMonitorServiceStarted()) {
                throw new OperationFailedException("Agent is not started");
            }
            long start = System.currentTimeMillis();
            service.getProtocolServices().discoverAll();
            long duration = System.currentTimeMillis() - start;
            opContext.getResult().set(String.format("Full inventory discovery scan completed in [%d] milliseconds", duration));
        }
        catch (OperationFailedException ofe) {
            throw ofe;
        }
        catch (ServiceNotFoundException snfe) {
            throw new OperationFailedException("Agent is not deployed: " + snfe.toString());
        }
        catch (Exception e) {
            throw new OperationFailedException(e.toString());
        }
        opContext.stepCompleted();
    }
}

