/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.jmx.JMXDriver;
import org.hawkular.agent.monitor.protocol.jmx.JMXLocationResolver;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pSearchRequest;
import org.jolokia.client.request.J4pSearchResponse;

public class JolokiaJMXDriver
extends JMXDriver {
    private final J4pClient client;

    public JolokiaJMXDriver(ProtocolDiagnostics diagnostics, J4pClient client) {
        super(diagnostics);
        this.client = client;
    }

    @Override
    public Map<JMXNodeLocation, ObjectName> fetchNodes(JMXNodeLocation query) throws ProtocolException {
        try {
            J4pSearchResponse searchResponse;
            J4pSearchRequest searchReq = new J4pSearchRequest(query.getObjectName().getCanonicalName());
            Timer.Context timerContext = this.getDiagnostics().getRequestTimer().time();
            Object object = null;
            try {
                searchResponse = (J4pSearchResponse)this.client.execute((J4pRequest)searchReq);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (timerContext != null) {
                    if (object != null) {
                        try {
                            timerContext.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        timerContext.close();
                    }
                }
            }
            HashMap<JMXNodeLocation, ObjectName> result = new HashMap<JMXNodeLocation, ObjectName>();
            for (ObjectName objectName : searchResponse.getObjectNames()) {
                JMXNodeLocation location = new JMXNodeLocation(objectName);
                result.put(location, objectName);
            }
            return Collections.unmodifiableMap(result);
        }
        catch (J4pException e) {
            this.getDiagnostics().getErrorRate().mark(1L);
            throw new ProtocolException(e);
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
    }

    @Override
    public boolean attributeExists(AttributeLocation<JMXNodeLocation> location) throws ProtocolException {
        return true;
    }

    @Override
    public Object fetchAttribute(AttributeLocation<JMXNodeLocation> location) throws ProtocolException {
        try {
            J4pReadResponse response;
            String[] attribute = location.getAttribute().split("#", 2);
            J4pReadRequest request = new J4pReadRequest(location.getLocation().getObjectName(), new String[]{attribute[0]});
            if (attribute.length > 1) {
                request.setPath(attribute[1]);
            }
            try (Timer.Context timerContext = this.getDiagnostics().getRequestTimer().time();){
                response = (J4pReadResponse)this.client.execute((J4pRequest)request);
            }
            Collection responseObjectNames = response.getObjectNames();
            switch (responseObjectNames.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return response.getValue();
                }
            }
            ArrayList<Object> results = new ArrayList<Object>(responseObjectNames.size());
            for (ObjectName responseObjectName : responseObjectNames) {
                Object value = response.getValue(responseObjectName, location.getAttribute());
                results.add(value);
            }
            return Collections.unmodifiableList(results);
        }
        catch (Exception e) {
            this.getDiagnostics().getErrorRate().mark(1L);
            throw new ProtocolException(e);
        }
    }

    @Override
    public Map<JMXNodeLocation, Object> fetchAttributeAsMap(AttributeLocation<JMXNodeLocation> location) throws ProtocolException {
        if (!new JMXLocationResolver().isMultiTarget(location.getLocation())) {
            Object o = this.fetchAttribute(location);
            return Collections.singletonMap(location.getLocation(), o);
        }
        Map<JMXNodeLocation, ObjectName> nodes = this.fetchNodes(location.getLocation());
        HashMap<JMXNodeLocation, Object> attribsMap = new HashMap<JMXNodeLocation, Object>(nodes.size());
        for (Map.Entry<JMXNodeLocation, ObjectName> entry : nodes.entrySet()) {
            Object o = this.fetchAttribute(new AttributeLocation<JMXNodeLocation>(entry.getKey(), location.getAttribute()));
            attribsMap.put(entry.getKey(), o);
        }
        return Collections.unmodifiableMap(attribsMap);
    }

    public J4pClient getClient() {
        return this.client;
    }
}

