/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.module.installer;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.hawkular.wildfly.module.installer.DeploymentConfiguration;
import org.hawkular.wildfly.module.installer.ExtensionDeploymentException;
import org.hawkular.wildfly.module.installer.JBossModule;
import org.hawkular.wildfly.module.installer.RegisterExtension;
import org.hawkular.wildfly.module.installer.RegisterModuleConfiguration;
import org.jboss.logging.Logger;

public class ExtensionDeployer {
    private final Logger log = Logger.getLogger(this.getClass());
    private File targetServerConfigAbsolute;
    private File sourceServerConfigBackupAbsolute;
    private File modulesHomeAbsolute;

    public void install(DeploymentConfiguration configuration) throws ExtensionDeploymentException {
        this.debug("Validating configuration");
        this.validConfiguration(configuration);
        JBossModule module = null;
        RegisterModuleConfiguration resolvedOptions = new RegisterModuleConfiguration();
        if (configuration.getModule() != null) {
            try {
                this.debug("Reading module from " + configuration.getModule());
                module = JBossModule.readFromURL(configuration.getModule());
            }
            catch (Exception e) {
                throw new ExtensionDeploymentException("Failed to read module", e);
            }
            try {
                List<File> installedFiles = module.installTo(this.modulesHomeAbsolute);
                resolvedOptions = this.resolveBundledXmlSnippets(installedFiles);
            }
            catch (Exception e) {
                throw new ExtensionDeploymentException("Failed to install module", e);
            }
        }
        try {
            RegisterModuleConfiguration options = new RegisterModuleConfiguration();
            if (module != null) {
                options.withExtension(module.getModuleId());
            }
            options.targetServerConfig(this.targetServerConfigAbsolute).sourceServerConfig(this.sourceServerConfigBackupAbsolute).subsystem(configuration.getSubsystem()).socketBinding(configuration.getSocketBinding()).socketBindingGroups(configuration.getSocketBindingGroups()).xmlEdits(configuration.getEdit()).domain(configuration.isDomain()).profiles(configuration.getProfiles()).failNoMatch(configuration.isFailNoMatch());
            resolvedOptions.extend(options);
            this.debug("Proceeding with \n" + resolvedOptions);
            this.register(resolvedOptions);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new ExtensionDeploymentException("Failed to update server configuration file", e);
        }
    }

    private RegisterModuleConfiguration resolveBundledXmlSnippets(List<File> installedFiles) throws Exception {
        RegisterModuleConfiguration options = new RegisterModuleConfiguration();
        for (File file : installedFiles) {
            if ("subsystem-snippet.xml".equals(file.getName())) {
                this.log.debug((Object)("Found packaged subsystem snippet " + file.getAbsolutePath()));
                options.subsystem(file.toURI().toURL());
            }
            if (!"socket-binding-snippet.xml".equals(file.getName())) continue;
            this.log.debug((Object)("Found packaged socket-binding snippet " + file.getAbsolutePath()));
            options.socketBinding(file.toURI().toURL());
        }
        return options;
    }

    public void register(RegisterModuleConfiguration options) throws Exception {
        new RegisterExtension().register(options);
    }

    private void debug(String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)message);
        }
    }

    private void validConfiguration(DeploymentConfiguration configuration) throws ExtensionDeploymentException {
        File jbossHome = configuration.getJbossHome();
        if (!(jbossHome.exists() && jbossHome.isDirectory() && jbossHome.canRead())) {
            throw new ExtensionDeploymentException("wildflyHome = " + jbossHome.getAbsolutePath() + " is not readable and existing directory");
        }
        if (!new File(jbossHome, "modules").isDirectory()) {
            throw new ExtensionDeploymentException("wildflyHome = " + jbossHome.getAbsolutePath() + " does not seem to point to AS7/WildFly installation dir");
        }
        this.targetServerConfigAbsolute = new File(configuration.getTargetServerConfig()).isAbsolute() ? new File(configuration.getTargetServerConfig()) : new File(jbossHome, configuration.getTargetServerConfig());
        if (!(this.targetServerConfigAbsolute.exists() && this.targetServerConfigAbsolute.isFile() && this.targetServerConfigAbsolute.canWrite())) {
            throw new ExtensionDeploymentException("targetServerConfig = " + configuration.getTargetServerConfig() + " is not writable and existing file. [targetserverConfig]" + "must be either absolute path or relative to [jbossHome]");
        }
        this.sourceServerConfigBackupAbsolute = new File(configuration.getSourceServerConfig()).isAbsolute() ? new File(configuration.getSourceServerConfig()) : new File(jbossHome, configuration.getSourceServerConfig());
        if (!(this.sourceServerConfigBackupAbsolute.getParentFile().exists() && this.targetServerConfigAbsolute.getParentFile().isDirectory() && this.targetServerConfigAbsolute.getParentFile().canWrite())) {
            throw new ExtensionDeploymentException("sourceServerConfig = " + configuration.getSourceServerConfig() + " 's parent directory does not exist or is writable." + "[sourceServerConfig] must be either absolute path or relative to [jbossHome]");
        }
        String modulesHome = configuration.getModulesHome();
        if (configuration.getModulesHome() == null) {
            File wfHome = Paths.get(jbossHome.getAbsolutePath(), "modules", "system", "layers", "base").toFile();
            if (!wfHome.exists()) {
                wfHome = Paths.get(jbossHome.getAbsolutePath(), "modules").toFile();
            }
            this.modulesHomeAbsolute = wfHome;
        }
        if (!(this.modulesHomeAbsolute.exists() && this.modulesHomeAbsolute.isDirectory() && this.modulesHomeAbsolute.canWrite())) {
            throw new ExtensionDeploymentException("modulesHome = " + modulesHome + " is not writable and existing directory. [modulesHome]" + "must be either absolute path or relative to [jbossHome]");
        }
    }
}

