/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.actions.email.listener;

import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.hawkular.actions.api.log.MsgLogger;
import org.hawkular.actions.api.model.ActionMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsActionsTopic"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="actionPlugin like 'email'")})
public class EmailListener
extends BasicMessageListener<ActionMessage> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    @Resource(mappedName="java:jboss/mail/Default")
    Session mailSession;

    protected void onBasicMessage(ActionMessage msg) {
        try {
            this.msgLog.infoActionReceived("email", msg.toString());
            Message message = this.createMimeMessage(msg);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            this.msgLog.errorCannotSendMessage("email", e.getLocalizedMessage());
        }
    }

    Message createMimeMessage(ActionMessage msg) throws MessagingException {
        InternetAddress toAddress;
        MimeMessage message = new MimeMessage(this.mailSession);
        message.setFrom((Address)new InternetAddress("noreply@hawkular.org"));
        if (msg.getProperties() != null && msg.getProperties().get("to") != null) {
            toAddress = new InternetAddress((String)msg.getProperties().get("to"));
            message.addRecipient(Message.RecipientType.TO, (Address)toAddress);
        }
        if (msg.getProperties() != null && msg.getProperties().get("cc") != null) {
            toAddress = new InternetAddress((String)msg.getProperties().get("cc"));
            message.addRecipient(Message.RecipientType.CC, (Address)toAddress);
        }
        String description = "Hawkular alert";
        if (msg.getProperties() != null && msg.getProperties().get("description") != null) {
            description = description + " - " + (String)msg.getProperties().get("description");
        }
        message.setSubject(description);
        message.setContent((Object)msg.getMessage(), "text/plain");
        return message;
    }
}

