/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rest.security;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.rest.RestApiLogger;
import org.hawkular.rest.security.InventorySecurity;
import org.hawkular.rest.security.Security;
import org.hawkular.rest.security.SecurityIntegration;

@Singleton
@Default
public class InventorySecurity
implements Security {
    private final Map<Class<?>, Map<OperationType, Operation>> operationsByType = new HashMap();
    @Inject
    private PermissionChecker permissions;
    @Inject
    private OperationService operations;
    private boolean inventoryInitialized = false;
    @Resource
    private UserTransaction transaction;

    public boolean canCreate(String entityType) {
        return true;
    }

    public boolean canUpdate(String path) {
        return true;
    }

    public boolean canDelete(String path) {
        return true;
    }

    public boolean canAssociateFrom(String path) {
        return true;
    }

    public boolean canCopyEnvironment(String path) {
        return true;
    }

    private Operation create(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.CREATE);
    }

    private Operation update(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.UPDATE);
    }

    private Operation delete(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.DELETE);
    }

    private Operation getOperation(Class<?> cls, OperationType operationType) {
        Map ops = (Map)this.operationsByType.get(cls);
        if (ops == null) {
            throw new IllegalArgumentException("There is no " + operationType + " operation for elements of type " + cls);
        }
        return (Operation)ops.get(operationType);
    }

    private boolean safePermissionCheck(String path, Operation operation) {
        return true;
    }

    private boolean safePermissionCheck(Class<?> entityType, String entityId, Operation operation, String stableId) {
        try {
            RestApiLogger.LOGGER.debugf("Permission check for operation '%s' for entity with stable ID '%s'", (Object)operation.getName(), (Object)stableId);
            return this.permissions.isAllowedTo(operation, stableId);
        }
        catch (Exception e) {
            RestApiLogger.LOGGER.securityCheckFailed(stableId, (Throwable)e);
            return false;
        }
    }

    public void initOperationsMap() {
        if (!SecurityIntegration.isDummy()) {
            try {
                this.transaction.begin();
                this.operations.setup("update-tenant").add("SuperUser").persist();
                this.operations.setup("delete-tenant").add("SuperUser").persist();
                this.operations.setup("create-environment").add("Administrator").persist();
                this.operations.setup("update-environment").add("Administrator").persist();
                this.operations.setup("delete-environment").add("Administrator").persist();
                this.operations.setup("copy-environment").add("Administrator").persist();
                this.operations.setup("create-resourceType").add("Administrator").persist();
                this.operations.setup("update-resourceType").add("Administrator").persist();
                this.operations.setup("delete-resourceType").add("Administrator").persist();
                this.operations.setup("create-metricType").add("Administrator").persist();
                this.operations.setup("update-metricType").add("Administrator").persist();
                this.operations.setup("delete-metricType").add("Administrator").persist();
                this.operations.setup("create-operationType").add("Administrator").persist();
                this.operations.setup("update-operationType").add("Administrator").persist();
                this.operations.setup("delete-operationType").add("Administrator").persist();
                this.operations.setup("create-feed").add("Administrator").persist();
                this.operations.setup("update-feed").add("Administrator").persist();
                this.operations.setup("delete-feed").add("Administrator").persist();
                this.operations.setup("create-resource").add("Maintainer").persist();
                this.operations.setup("update-resource").add("Maintainer").persist();
                this.operations.setup("delete-resource").add("Maintainer").persist();
                this.operations.setup("create-metric").add("Maintainer").persist();
                this.operations.setup("update-metric").add("Maintainer").persist();
                this.operations.setup("delete-metric").add("Maintainer").persist();
                this.operations.setup("associate").add("Operator").persist();
                this.transaction.commit();
            }
            catch (Throwable t) {
                try {
                    this.transaction.rollback();
                }
                catch (SystemException e) {
                    throw new IllegalStateException("Unable to do the rollback: " + e.getMessage(), t);
                }
                throw new IllegalStateException(t);
            }
            Operation updateTenantOperation = this.operations.getByName("update-tenant");
            Operation deleteTenantOperation = this.operations.getByName("delete-tenant");
            Operation createEnvironmentOperation = this.operations.getByName("create-environment");
            Operation updateEnvironmentOperation = this.operations.getByName("update-environment");
            Operation deleteEnvironmentOperation = this.operations.getByName("delete-environment");
            Operation copyEnvironmentOperation = this.operations.getByName("copy-environment");
            Operation createResourceTypeOperation = this.operations.getByName("create-resourceType");
            Operation updateResourceTypeOperation = this.operations.getByName("update-resourceType");
            Operation deleteResourceTypeOperation = this.operations.getByName("delete-resourceType");
            Operation createMetricTypeOperation = this.operations.getByName("create-metricType");
            Operation updateMetricTypeOperation = this.operations.getByName("update-metricType");
            Operation deleteMetricTypeOperation = this.operations.getByName("delete-metricType");
            Operation createOperationTypeOperation = this.operations.getByName("create-operationType");
            Operation updateOperationTypeOperation = this.operations.getByName("update-operationType");
            Operation deleteOperationTypeOperation = this.operations.getByName("delete-operationType");
            Operation createFeedOperation = this.operations.getByName("create-feed");
            Operation updateFeedOperation = this.operations.getByName("update-feed");
            Operation deleteFeedOperation = this.operations.getByName("delete-feed");
            Operation createResourceOperation = this.operations.getByName("create-resource");
            Operation updateResourceOperation = this.operations.getByName("update-resource");
            Operation deleteResourceOperation = this.operations.getByName("delete-resource");
            Operation createMetricOperation = this.operations.getByName("create-metric");
            Operation updateMetricOperation = this.operations.getByName("update-metric");
            Operation deleteMetricOperation = this.operations.getByName("delete-metric");
            Operation associate = this.operations.getByName("associate");
            this.operationsByType.put(String.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(String.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(String.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(String.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(String.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(String.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(String.class, new /* Unavailable Anonymous Inner Class!! */);
            this.operationsByType.put(String.class, new /* Unavailable Anonymous Inner Class!! */);
        }
    }
}

