/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rest.security;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.rest.RestApiLogger;
import rx.Subscription;

@ApplicationScoped
public class SecurityIntegration {
    @Inject
    ResourceService storage;
    @Inject
    PersonaService personas;
    private static final boolean DUMMY = false;
    private final Set<Subscription> subscriptions = new HashSet();

    private Resource createSecurityResource(String stableId) {
        RestApiLogger.LOGGER.tracef("Creating security entity for %s", (Object)stableId);
        Resource res = this.storage.get(stableId);
        if (res == null) {
            Resource parent = null;
            Persona owner = this.personas.getCurrent();
            if (parent != null) {
                owner = this.establishOwner(parent, owner);
            }
            res = this.storage.create(stableId, parent, owner);
        }
        return res;
    }

    private Persona establishOwner(Resource resource, Persona current) {
        while (resource != null && resource.getPersona() == null) {
            resource = resource.getParent();
        }
        if (resource != null && resource.getPersona().equals((Object)current)) {
            current = null;
        }
        return current;
    }

    public static boolean isDummy() {
        return false;
    }
}

