/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rest.api.v1.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.net.URI;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.hawkular.rest.RestBase;
import org.hawkular.rest.api.v1.entities.URL;
import org.hawkular.rest.api.v1.interfaces.RestURL;
import org.hawkular.rx.cdi.CreateCommand;
import org.hawkular.rx.cdi.Initialized;
import org.hawkular.rx.cdi.UpdateCommand;
import org.hawkular.rx.commands.hawkular.CreateUrlCommand;
import org.hawkular.rx.commands.hawkular.DeleteUrlCommand;
import org.hawkular.rx.commands.hawkular.GetUrlCommand;
import org.hawkular.rx.commands.hawkular.UpdateUrlCommand;
import org.hawkular.rx.httpclient.HttpClient;
import rx.Observable;

public class RestURLImpl
extends RestBase
implements RestURL {
    @Inject
    @Default
    private HttpClient client;
    @Inject
    private ObjectMapper mapper;
    @Inject
    @Any
    private Instance<GetUrlCommand> getUrlCommandInjector;
    @Inject
    @CreateCommand
    private Instance<CreateUrlCommand> createUrlCommandInjector;
    @Inject
    @UpdateCommand
    private Instance<UpdateUrlCommand> updateUrlCommandInjector;
    @Inject
    @Any
    private Instance<DeleteUrlCommand> deleteUrlCommandInjector;

    public void getUrl(AsyncResponse asyncResponse, String id, String authToken) {
        String tenantId = this.getTenantId();
        GetUrlCommand getUrlCommand = (GetUrlCommand)this.getUrlCommandInjector.select(new Annotation[]{Initialized.withValues((String[])new String[]{id, authToken, tenantId})}).get();
        Observable observer = getUrlCommand.toObservable();
        observer.subscribe(commandResponse -> asyncResponse.resume(commandResponse));
    }

    public void getAll(AsyncResponse asyncResponse, String authToken) {
        this.getUrl(asyncResponse, null, authToken);
    }

    public void createUrl(AsyncResponse asyncResponse, URL url, String authToken) {
        String tenantId = this.getTenantId();
        if (url == null || url.getUrl() == null) {
            asyncResponse.resume((Object)"URL object is empty, pass the {url: www.example.com}");
        }
        CreateUrlCommand createUrlCommand = (CreateUrlCommand)this.createUrlCommandInjector.select(new Annotation[]{Initialized.withValues((String[])new String[]{url.getUrl(), authToken, tenantId})}).get();
        Observable observer = createUrlCommand.toObservable();
        observer.subscribe(commandResponse -> {
            if (commandResponse != null) {
                URI uri = URI.create(commandResponse);
                asyncResponse.resume((Object)Response.created((URI)uri).build());
            } else {
                asyncResponse.resume((Object)Response.ok((Object)("Url " + url + " already exists.")).build());
            }
        });
    }

    public void updateUrl(AsyncResponse asyncResponse, String id, URL update, String authToken) {
        String tenantId = this.getTenantId();
        UpdateUrlCommand updateUrlCommand = (UpdateUrlCommand)this.updateUrlCommandInjector.select(new Annotation[]{Initialized.withValues((String[])new String[]{id, update.getUrl(), authToken, tenantId})}).get();
        Observable observer = updateUrlCommand.toObservable();
        observer.subscribe(commandResponse -> asyncResponse.resume(commandResponse));
    }

    public void deleteUrl(AsyncResponse asyncResponse, String id, String authToken) {
        String tenantId = this.getTenantId();
        DeleteUrlCommand deleteUrlCommand = (DeleteUrlCommand)this.deleteUrlCommandInjector.select(new Annotation[]{Initialized.withValues((String[])new String[]{id, authToken, tenantId})}).get();
        Observable observer = deleteUrlCommand.toObservable();
        observer.subscribe(commandResponse -> asyncResponse.resume(commandResponse));
    }
}

