/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rest;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.client.api.Notification;
import org.hawkular.client.api.NotificationType;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.listener.bus.ListenerUtils;
import org.hawkular.rest.ResponseUtil;
import org.hawkular.rest.json.ApiError;
import org.jboss.logging.Logger;

@Path(value="/")
public class ApiHandler {
    private static final Logger log = Logger.getLogger(ApiHandler.class);
    public static final String TENANT_HEADER_NAME = "Hawkular-Tenant";
    private final ListenerUtils utils = new ListenerUtils();
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    private static final Set<String> SERVER_TYPES = new HashSet<String>(Arrays.asList("Domain Host", "Domain WildFly Server", "Domain WildFly Server Controller", "Host Controller", "WildFly Server"));

    public ApiHandler() {
        log.debug((Object)"Creating Instance.");
    }

    @GET
    @Path(value="/ping")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="A dummy operation returning the current date on the server.")
    public Response ping() {
        return Response.ok((Object)new Date().toString()).build();
    }

    @PUT
    @Path(value="/notification")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Process a notification.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Notification Processed."), @ApiResponse(code=500, message="Internal server error.", response=ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ApiError.class)})
    public Response handleNotification(@ApiParam(value="Notification to be handled.", name="notification", required=true) Notification notification) {
        try {
            if (null == notification) {
                return ResponseUtil.badRequest("Notification is null");
            }
            if (null == notification.getType()) {
                return ResponseUtil.badRequest("Notification Type is null");
            }
            if (null == notification.getProperties()) {
                return ResponseUtil.badRequest("Notification Properties is null");
            }
            switch (notification.getType()) {
                case RESOURCE_ADDED: {
                    this.handleResourceAdded(notification);
                    break;
                }
                default: {
                    return ResponseUtil.badRequest("Unhandled Notification Type: " + notification.getType());
                }
            }
            return ResponseUtil.ok(null);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest("Bad arguments: " + e.getMessage());
            }
            return ResponseUtil.internalError(e.getMessage());
        }
    }

    private void handleResourceAdded(Notification notification) {
        CanonicalPath cp;
        String resourceType = (String)notification.getProperties().get("resourceType");
        if (ApiHandler.isEmpty(resourceType)) {
            throw new IllegalArgumentException("Required Property [resourceType] is missing or is an invalid type.");
        }
        String resourcePath = (String)notification.getProperties().get("resourcePath");
        try {
            cp = CanonicalPath.fromString((String)resourcePath);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Required Property [resourcePath] is missing or is an invalid CanonicalPath: " + e.getMessage());
        }
        if (SERVER_TYPES.contains(resourceType)) {
            String eventId = NotificationType.RESOURCE_ADDED.name() + "_" + cp.toString();
            String message = "Added: " + resourceType;
            this.utils.addEvent(eventId, true, cp, "Inventory Change", message, "hawkular_event", "MiddlewareServer", message);
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

