/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rest;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.client.api.Notification;
import org.hawkular.listener.MIQEventUtils;
import org.hawkular.rest.ApiHandler;
import org.hawkular.rest.ResponseUtil;
import org.hawkular.rest.json.ApiError;
import org.jboss.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
public class ApiHandler {
    private static final Logger log = Logger.getLogger(ApiHandler.class);
    public static final String TENANT_HEADER_NAME = "Hawkular-Tenant";
    private final MIQEventUtils miqEventUtils = new MIQEventUtils();
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;

    public ApiHandler() {
        log.debug((Object)"Creating Instance.");
    }

    @GET
    @Path(value="/ping")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="A dummy operation returning the current date on the server.")
    public Response ping() {
        return Response.ok((Object)new Date().toString()).build();
    }

    @PUT
    @Path(value="/notification")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Process a notification.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Notification Processed."), @ApiResponse(code=500, message="Internal server error.", response=ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ApiError.class)})
    public Response handleNotification(@ApiParam(value="Notification to be handled.", name="notification", required=true) Notification notification) {
        try {
            if (null == notification) {
                return ResponseUtil.badRequest((String)"Notification is null");
            }
            if (null == notification.getType()) {
                return ResponseUtil.badRequest((String)"Notification Type is null");
            }
            if (null == notification.getProperties()) {
                return ResponseUtil.badRequest((String)"Notification Properties is null");
            }
            switch (1.$SwitchMap$org$hawkular$client$api$NotificationType[notification.getType().ordinal()]) {
                case 1: {
                    this.handleResourceAdded(notification);
                    break;
                }
                case 2: 
                case 3: {
                    this.handleAvailChanged(notification);
                    break;
                }
                default: {
                    return ResponseUtil.badRequest((String)("Unhandled Notification Type: " + notification.getType()));
                }
            }
            return ResponseUtil.ok(null);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private void handleResourceAdded(Notification notification) {
        String resourceType = this.getRequiredValue(notification, "resourceType");
        String resourcePath = this.getRequiredValue(notification, "resourcePath");
        this.miqEventUtils.handleResourceAdded(resourceType, resourcePath);
    }

    private void handleAvailChanged(Notification notification) {
        String resourceType = this.getRequiredValue(notification, "resourceType");
        String resourcePath = this.getRequiredValue(notification, "resourcePath");
        String availType = this.getRequiredValue(notification, "availType");
        String newAvail = this.getRequiredValue(notification, "newAvail");
        this.miqEventUtils.handleResourceAvailChange(resourcePath, availType, newAvail);
    }

    private String getRequiredValue(Notification notification, String key) {
        String value = (String)notification.getProperties().get(key);
        if (ApiHandler.isEmpty((String)value)) {
            throw new IllegalArgumentException("Required Property [" + key + "] is missing or is an invalid type.");
        }
        return value;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

