/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator;

import java.util.Map;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator.AbstractSimpleGenerator;

public class SimpleServerGenerator
extends AbstractSimpleGenerator {
    private static final String SERVER_TEMPLATE = "org/apache/cxf/tools/java2wsdl/processor/internal/simple/generator/template/server.vm";

    public SimpleServerGenerator() {
        this.name = "svr.generator";
    }

    @Override
    public boolean passthrough() {
        return !this.env.optionSet("server");
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = (JavaModel)this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map interfaces = javaModel.getInterfaces();
        for (JavaInterface intf : interfaces.values()) {
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setAttributes("implClass", this.env.get("implClass"));
            this.setAttributes("address", this.env.get("address"));
            this.setCommonAttributes();
            this.doWrite(SERVER_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName() + "Server"));
            this.env.put("serverClass", (Object)(intf.getFullClassName() + "Server"));
        }
    }
}

