/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import javax.management.MBeanServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.subsystem.CMResourceResourceDefinition;
import org.jboss.as.txn.subsystem.LogStoreDefinition;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.LogStoreTransactionDefinition;
import org.jboss.as.txn.subsystem.LogStoreTransactionParticipantDefinition;
import org.jboss.as.txn.subsystem.Namespace;
import org.jboss.as.txn.subsystem.TransactionSubsystem10Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem11Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem12Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem13Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem14Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem15Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem20Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem30Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystemRootResourceDefinition;
import org.jboss.as.txn.subsystem.TransactionSubsystemXMLPersister;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class TransactionExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "transactions";
    public static final String RESOLVE_OBJECT_STORE_PATH = "resolve-object-store-path";
    private static final String RESOURCE_NAME = TransactionExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final ModelVersion MODEL_VERSION_EAP62 = ModelVersion.create((int)1, (int)3);
    static final ModelVersion MODEL_VERSION_EAP63 = ModelVersion.create((int)1, (int)4);
    static final ModelVersion MODEL_VERSION_EAP64 = ModelVersion.create((int)1, (int)5);
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)3, (int)0, (int)0);
    private static final ServiceName MBEAN_SERVER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    static final PathElement LOG_STORE_PATH = PathElement.pathElement((String)"log-store", (String)"log-store");
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"transactions");
    static final PathElement PARTICIPANT_PATH = PathElement.pathElement((String)"participants");
    static final PathElement TRANSACTION_PATH = PathElement.pathElement((String)"transactions");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, TransactionExtension.class.getClassLoader(), true, false);
    }

    static MBeanServer getMBeanServer(OperationContext context) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController serviceController = serviceRegistry.getService(MBEAN_SERVER_SERVICE_NAME);
        if (serviceController == null) {
            throw TransactionLogger.ROOT_LOGGER.jmxSubsystemNotInstalled();
        }
        return (MBeanServer)serviceController.getValue();
    }

    public void initialize(ExtensionContext context) {
        TransactionLogger.ROOT_LOGGER.debug("Initializing Transactions Extension");
        LogStoreResource resource = new LogStoreResource();
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        TransactionSubsystemRootResourceDefinition rootResourceDefinition = new TransactionSubsystemRootResourceDefinition(registerRuntimeOnly);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)rootResourceDefinition);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        if (context.getProcessType().isServer()) {
            ResolvePathHandler objectStorePathHandler = ResolvePathHandler.Builder.of((String)RESOLVE_OBJECT_STORE_PATH, (PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)TransactionSubsystemRootResourceDefinition.OBJECT_STORE_PATH).setRelativeToAttribute((AttributeDefinition)TransactionSubsystemRootResourceDefinition.OBJECT_STORE_RELATIVE_TO).build();
            registration.registerOperationHandler(objectStorePathHandler.getOperationDefinition(), (OperationStepHandler)objectStorePathHandler);
        }
        ManagementResourceRegistration logStoreChild = registration.registerSubModel((ResourceDefinition)new LogStoreDefinition(resource, registerRuntimeOnly));
        if (registerRuntimeOnly) {
            ManagementResourceRegistration transactionChild = logStoreChild.registerSubModel((ResourceDefinition)new LogStoreTransactionDefinition(resource));
            transactionChild.registerSubModel((ResourceDefinition)LogStoreTransactionParticipantDefinition.INSTANCE);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)TransactionSubsystemXMLPersister.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_0.getUriString(), (XMLElementReader)TransactionSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_1.getUriString(), (XMLElementReader)TransactionSubsystem11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_2.getUriString(), (XMLElementReader)TransactionSubsystem12Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_3.getUriString(), (XMLElementReader)TransactionSubsystem13Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_4.getUriString(), (XMLElementReader)TransactionSubsystem14Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_5.getUriString(), (XMLElementReader)TransactionSubsystem15Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_2_0.getUriString(), (XMLElementReader)TransactionSubsystem20Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_3_0.getUriString(), (XMLElementReader)TransactionSubsystem30Parser.INSTANCE);
    }

    private void registerTransformers(SubsystemRegistration subsystem) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystem.getSubsystemVersion());
        ResourceTransformationDescriptionBuilder builderEap64 = chainedBuilder.createBuilder(subsystem.getSubsystemVersion(), MODEL_VERSION_EAP64);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builderEap64.getAttributeBuilder().addRename((AttributeDefinition)TransactionSubsystemRootResourceDefinition.USE_JOURNAL_STORE, "use-hornetq-store")).addRename((AttributeDefinition)TransactionSubsystemRootResourceDefinition.JOURNAL_STORE_ENABLE_ASYNC_IO, "hornetq-store-enable-async-io")).addRename((AttributeDefinition)TransactionSubsystemRootResourceDefinition.STATISTICS_ENABLED, "enable-statistics");
        ResourceTransformationDescriptionBuilder builderEap63 = chainedBuilder.createBuilder(MODEL_VERSION_EAP64, MODEL_VERSION_EAP63);
        builderEap63.rejectChildResource(CMResourceResourceDefinition.PATH_CM_RESOURCE);
        ResourceTransformationDescriptionBuilder builderEap62 = chainedBuilder.createBuilder(MODEL_VERSION_EAP63, MODEL_VERSION_EAP62);
        chainedBuilder.buildAndRegister(subsystem, (ModelVersion[][])new ModelVersion[][]{{MODEL_VERSION_EAP62, MODEL_VERSION_EAP63, MODEL_VERSION_EAP64}});
    }
}

