/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public class GetWithMetadataOperation<V>
extends AbstractKeyOperation<MetadataValue<V>> {
    private static final Log log = LogFactory.getLog(GetWithMetadataOperation.class);
    private static final boolean trace = log.isTraceEnabled();

    public GetWithMetadataOperation(Codec codec, TransportFactory transportFactory, byte[] key, byte[] cacheName, AtomicInteger topologyId, int flags) {
        super(codec, transportFactory, key, cacheName, topologyId, flags);
    }

    @Override
    protected MetadataValue<V> executeOperation(Transport transport) {
        short status = this.sendKeyOperation(this.key, transport, (byte)27, (byte)28);
        MetadataValueImpl result = null;
        if (HotRodConstants.isNotExist(status)) {
            result = null;
        } else if (HotRodConstants.isSuccess(status)) {
            short flags = transport.readByte();
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            if ((flags & 1) != 1) {
                creation = transport.readLong();
                lifespan = transport.readVInt();
            }
            if ((flags & 2) != 2) {
                lastUsed = transport.readLong();
                maxIdle = transport.readVInt();
            }
            long version = transport.readLong();
            if (trace) {
                log.tracef("Received version: %d", version);
            }
            Object value = this.codec.readUnmarshallByteArray(transport, status);
            result = new MetadataValueImpl(creation, lifespan, lastUsed, maxIdle, version, value);
        }
        return result;
    }
}

