/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import org.jboss.aesh.console.AeshConsoleBuffer;
import org.jboss.aesh.console.ConsoleBuffer;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.edit.EditMode;
import org.jboss.aesh.edit.EmacsEditMode;
import org.jboss.aesh.edit.KeyOperationFactory;
import org.jboss.aesh.edit.KeyOperationManager;
import org.jboss.aesh.terminal.Shell;

public class AeshConsoleBufferBuilder {
    private Prompt prompt;
    private Shell shell;
    private EditMode editMode;
    private boolean ansiMode = true;

    public AeshConsoleBufferBuilder prompt(Prompt prompt) {
        this.prompt = prompt;
        return this;
    }

    public AeshConsoleBufferBuilder shell(Shell shell) {
        this.shell = shell;
        return this;
    }

    public AeshConsoleBufferBuilder editMode(EditMode editMode) {
        this.editMode = editMode;
        return this;
    }

    public AeshConsoleBufferBuilder ansi(boolean ansi) {
        this.ansiMode = ansi;
        return this;
    }

    public ConsoleBuffer create() {
        if (this.shell == null) {
            throw new IllegalArgumentException("Shell must be provided to create ConsoleBuffer");
        }
        if (this.editMode == null) {
            this.editMode = new EmacsEditMode(new KeyOperationManager(KeyOperationFactory.generateEmacsMode()));
        }
        if (this.prompt == null) {
            this.prompt = new Prompt("");
        }
        return new AeshConsoleBuffer(this.prompt, this.shell, this.editMode, this.ansiMode);
    }
}

