/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.appclient.component.ApplicationClientComponentDescription;
import org.jboss.as.appclient.deployment.AppClientAttachments;
import org.jboss.as.appclient.deployment.ForwardingEjbClientConfiguration;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.appclient.service.ApplicationClientDeploymentService;
import org.jboss.as.appclient.service.ApplicationClientStartService;
import org.jboss.as.appclient.service.DefaultApplicationClientCallbackHandler;
import org.jboss.as.appclient.service.RealmCallbackWrapper;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.metadata.appclient.spec.ApplicationClientMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ApplicationClientStartProcessor
implements DeploymentUnitProcessor {
    private final String[] parameters;
    private final String hostUrl;
    private final String connectionPropertiesUrl;

    public ApplicationClientStartProcessor(String hostUrl, String connectionPropertiesUrl, String[] parameters) {
        this.hostUrl = hostUrl;
        this.parameters = parameters;
        this.connectionPropertiesUrl = connectionPropertiesUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ApplicationClientStartService startService;
        ApplicationClientComponentDescription component;
        DeploymentUnit deploymentUnit;
        block25: {
            ClassReflectionIndex index;
            CallbackHandler callbackHandler;
            deploymentUnit = phaseContext.getDeploymentUnit();
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            ApplicationClientMetaData appClientData = (ApplicationClientMetaData)deploymentUnit.getAttachment(AppClientAttachments.APPLICATION_CLIENT_META_DATA);
            DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
            Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            if (appClientData != null && appClientData.getCallbackHandler() != null && !appClientData.getCallbackHandler().isEmpty()) {
                try {
                    Class callbackClass = ClassLoadingUtils.loadClass((String)appClientData.getCallbackHandler(), (Module)module);
                    callbackHandler = new RealmCallbackWrapper((CallbackHandler)callbackClass.newInstance());
                }
                catch (ClassNotFoundException e) {
                    throw AppClientLogger.ROOT_LOGGER.couldNotLoadCallbackClass(appClientData.getCallbackHandler());
                }
                catch (Exception e) {
                    throw AppClientLogger.ROOT_LOGGER.couldNotCreateCallbackHandler(appClientData.getCallbackHandler());
                }
            } else {
                callbackHandler = new DefaultApplicationClientCallbackHandler();
            }
            Boolean activate = (Boolean)deploymentUnit.getAttachment(AppClientAttachments.START_APP_CLIENT);
            if (activate == null || !activate.booleanValue()) {
                return;
            }
            Class mainClass = (Class)deploymentUnit.getAttachment(AppClientAttachments.MAIN_CLASS);
            if (mainClass == null) {
                throw AppClientLogger.ROOT_LOGGER.cannotStartAppClient(deploymentUnit.getName());
            }
            component = (ApplicationClientComponentDescription)((Object)deploymentUnit.getAttachment(AppClientAttachments.APPLICATION_CLIENT_COMPONENT));
            Method mainMethod = null;
            for (Class klass = mainClass; klass != Object.class && (mainMethod = (index = deploymentReflectionIndex.getClassIndex(klass)).getMethod(Void.TYPE, "main", new Class[]{String[].class})) == null; klass = klass.getSuperclass()) {
            }
            if (mainMethod == null) {
                throw AppClientLogger.ROOT_LOGGER.cannotStartAppClient(deploymentUnit.getName(), mainClass);
            }
            List setupActions = deploymentUnit.getAttachmentList(Attachments.OTHER_EE_SETUP_ACTIONS);
            if (this.connectionPropertiesUrl != null) {
                try {
                    File file = new File(this.connectionPropertiesUrl);
                    URL url = file.exists() ? file.toURI().toURL() : new URL(this.connectionPropertiesUrl);
                    Properties properties = new Properties();
                    InputStream stream = null;
                    try {
                        stream = url.openStream();
                        properties.load(stream);
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                    try {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
                        Object configuration = new PropertiesBasedEJBClientConfiguration(properties);
                        if (!properties.contains("username") && !properties.contains("callback.handler.class")) {
                            configuration = new ForwardingEjbClientConfiguration((EJBClientConfiguration)configuration){

                                @Override
                                public CallbackHandler getCallbackHandler() {
                                    return callbackHandler;
                                }
                            };
                        }
                        startService = new ApplicationClientStartService(mainMethod, this.parameters, moduleDescription.getNamespaceContextSelector(), (ClassLoader)module.getClassLoader(), setupActions, (EJBClientConfiguration)configuration);
                        break block25;
                    }
                    finally {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                    }
                }
                catch (Exception e) {
                    throw AppClientLogger.ROOT_LOGGER.exceptionLoadingEjbClientPropertiesURL(this.connectionPropertiesUrl, e);
                }
            }
            startService = new ApplicationClientStartService(mainMethod, this.parameters, moduleDescription.getNamespaceContextSelector(), (ClassLoader)module.getClassLoader(), setupActions, this.hostUrl, callbackHandler);
        }
        phaseContext.getServiceTarget().addService(deploymentUnit.getServiceName().append(ApplicationClientStartService.SERVICE_NAME), (Service)startService).addDependency(ApplicationClientDeploymentService.SERVICE_NAME, ApplicationClientDeploymentService.class, startService.getApplicationClientDeploymentServiceInjectedValue()).addDependency(component.getCreateServiceName(), Component.class, startService.getApplicationClientComponent()).install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

