/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi.interceptor;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.naming.NamingException;
import org.hibernate.LockMode;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.Helper;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class LazyAttributeLoader
implements PersistentAttributeInterceptor,
Helper.Consumer {
    private static final Logger log = Logger.getLogger(LazyAttributeLoader.class);
    private transient SessionImplementor session;
    private final Set<String> lazyFields;
    private final String entityName;
    private String sessionFactoryUuid;
    private boolean allowLoadOutsideTransaction;
    private final SimpleFieldTracker initializedFields = new SimpleFieldTracker();

    public LazyAttributeLoader(SessionImplementor session, Set<String> lazyFields, String entityName) {
        this.session = session;
        this.lazyFields = lazyFields;
        this.entityName = entityName;
        this.allowLoadOutsideTransaction = session.getFactory().getSessionFactoryOptions().isInitializeLazyStateOutsideTransactionsEnabled();
        if (this.allowLoadOutsideTransaction) {
            try {
                this.sessionFactoryUuid = (String)session.getFactory().getReference().get("uuid").getContent();
            }
            catch (NamingException e) {
                log.debug((Object)"Unable to determine SF UUID in preparation for `allowLoadOutsideTransaction`");
            }
        }
    }

    protected final Object intercept(Object target, String attributeName, Object value) {
        if (!this.isAttributeLoaded(attributeName)) {
            Object loadedValue = this.fetchAttribute(target, attributeName);
            this.setLoaded(attributeName);
            return loadedValue;
        }
        return value;
    }

    public Object fetchAttribute(Object target, String attributeName) {
        return this.loadAttribute(target, attributeName);
    }

    protected Object loadAttribute(final Object target, final String attributeName) {
        return new Helper(this).performWork(new Helper.LazyInitializationWork(){

            public Object doWork(SessionImplementor session, boolean isTemporarySession) {
                EntityPersister persister = session.getFactory().getEntityPersister(this.getEntityName());
                if (isTemporarySession) {
                    Serializable id = persister.getIdentifier(target, null);
                    Object[] loadedState = null;
                    boolean existsInDb = true;
                    session.getPersistenceContext().addEntity(target, Status.READ_ONLY, loadedState, session.generateEntityKey(id, persister), persister.getVersion(target), LockMode.NONE, true, persister, true, true);
                }
                LazyPropertyInitializer initializer = (LazyPropertyInitializer)((Object)persister);
                Object loadedValue = initializer.initializeLazyProperty(attributeName, target, session);
                LazyAttributeLoader.this.initializedFields.add(attributeName);
                LazyAttributeLoader.this.takeCollectionSizeSnapshot(target, attributeName, loadedValue);
                return loadedValue;
            }

            @Override
            public String getEntityName() {
                return LazyAttributeLoader.this.entityName;
            }

            @Override
            public String getAttributeName() {
                return attributeName;
            }
        });
    }

    public final void setSession(SessionImplementor session) {
        this.session = session;
    }

    public final void unsetSession() {
        this.session = null;
    }

    public boolean isAttributeLoaded(String fieldName) {
        return this.lazyFields == null || !this.lazyFields.contains(fieldName) || this.initializedFields.contains(fieldName);
    }

    public boolean isUninitialized() {
        if (this.lazyFields != null) {
            for (String fieldName : this.lazyFields) {
                if (this.initializedFields.contains(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public void setLoaded(String attributeName) {
        this.initializedFields.add(attributeName);
    }

    public String[] getiInitializedFields() {
        return this.initializedFields.get();
    }

    public String toString() {
        return "LazyAttributeLoader(entityName=" + this.entityName + " ,lazyFields=" + this.lazyFields + ')';
    }

    private void takeCollectionSizeSnapshot(Object target, String fieldName, Object value) {
        if (value != null && value instanceof Collection && target instanceof SelfDirtinessTracker) {
            CollectionTracker tracker = ((SelfDirtinessTracker)target).$$_hibernate_getCollectionTracker();
            if (tracker == null) {
                ((SelfDirtinessTracker)target).$$_hibernate_clearDirtyAttributes();
                tracker = ((SelfDirtinessTracker)target).$$_hibernate_getCollectionTracker();
            }
            tracker.add(fieldName, ((Collection)value).size());
        }
    }

    @Override
    public boolean readBoolean(Object obj, String name, boolean oldValue) {
        return (Boolean)this.intercept(obj, name, oldValue);
    }

    @Override
    public boolean writeBoolean(Object obj, String name, boolean oldValue, boolean newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public byte readByte(Object obj, String name, byte oldValue) {
        return (Byte)this.intercept(obj, name, oldValue);
    }

    @Override
    public byte writeByte(Object obj, String name, byte oldValue, byte newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public char readChar(Object obj, String name, char oldValue) {
        return ((Character)this.intercept(obj, name, Character.valueOf(oldValue))).charValue();
    }

    @Override
    public char writeChar(Object obj, String name, char oldValue, char newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public short readShort(Object obj, String name, short oldValue) {
        return (Short)this.intercept(obj, name, oldValue);
    }

    @Override
    public short writeShort(Object obj, String name, short oldValue, short newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public int readInt(Object obj, String name, int oldValue) {
        return (Integer)this.intercept(obj, name, oldValue);
    }

    @Override
    public int writeInt(Object obj, String name, int oldValue, int newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public float readFloat(Object obj, String name, float oldValue) {
        return ((Float)this.intercept(obj, name, Float.valueOf(oldValue))).floatValue();
    }

    @Override
    public float writeFloat(Object obj, String name, float oldValue, float newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public double readDouble(Object obj, String name, double oldValue) {
        return (Double)this.intercept(obj, name, oldValue);
    }

    @Override
    public double writeDouble(Object obj, String name, double oldValue, double newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public long readLong(Object obj, String name, long oldValue) {
        return (Long)this.intercept(obj, name, oldValue);
    }

    @Override
    public long writeLong(Object obj, String name, long oldValue, long newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public Object readObject(Object obj, String name, Object oldValue) {
        return this.intercept(obj, name, oldValue);
    }

    @Override
    public Object writeObject(Object obj, String name, Object oldValue, Object newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public SessionImplementor getLinkedSession() {
        return this.session;
    }

    @Override
    public boolean allowLoadOutsideTransaction() {
        return this.allowLoadOutsideTransaction;
    }

    @Override
    public String getSessionFactoryUuid() {
        return this.sessionFactoryUuid;
    }
}

