/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import org.infinispan.atomic.DeltaCompositeKey;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;

public class LockUtil {
    private LockUtil() {
    }

    public static LockOwnership getLockOwnership(Object key, ClusteringDependentLogic clusteringDependentLogic) {
        Object keyToCheck;
        Object object = keyToCheck = key instanceof DeltaCompositeKey ? ((DeltaCompositeKey)key).getDeltaAwareValueKey() : key;
        if (clusteringDependentLogic.localNodeIsPrimaryOwner(keyToCheck)) {
            return LockOwnership.PRIMARY;
        }
        if (clusteringDependentLogic.localNodeIsOwner(keyToCheck)) {
            return LockOwnership.BACKUP;
        }
        return LockOwnership.NO_OWNER;
    }

    public static enum LockOwnership {
        NO_OWNER,
        PRIMARY,
        BACKUP;

    }
}

