/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessBuildingException;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;
import org.hibernate.property.access.spi.SetterMethodImpl;

public class PropertyAccessMixedImpl
implements PropertyAccess {
    private final PropertyAccessStrategyMixedImpl strategy;
    private final Getter getter;
    private final Setter setter;

    public PropertyAccessMixedImpl(PropertyAccessStrategyMixedImpl strategy, Class containerJavaType, String propertyName) {
        Class<?> propertyJavaType;
        this.strategy = strategy;
        Field field = PropertyAccessMixedImpl.fieldOrNull(containerJavaType, propertyName);
        Method getterMethod = PropertyAccessMixedImpl.getterMethodOrNull(containerJavaType, propertyName);
        if (field == null && getterMethod == null) {
            throw new PropertyAccessBuildingException("Could not locate field nor getter method for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
        }
        if (field != null) {
            propertyJavaType = field.getType();
            this.getter = new GetterFieldImpl(containerJavaType, propertyName, field);
        } else {
            propertyJavaType = getterMethod.getReturnType();
            this.getter = new GetterMethodImpl(containerJavaType, propertyName, getterMethod);
        }
        Method setterMethod = PropertyAccessMixedImpl.setterMethodOrNull(containerJavaType, propertyName, propertyJavaType);
        if (field == null && setterMethod == null) {
            throw new PropertyAccessBuildingException("Could not locate field nor setter method for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
        }
        this.setter = field != null ? new SetterFieldImpl(containerJavaType, propertyName, field) : new SetterMethodImpl(containerJavaType, propertyName, setterMethod);
    }

    private static Field fieldOrNull(Class containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findField(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    private static Method getterMethodOrNull(Class containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findGetterMethod(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    private static Method setterMethodOrNull(Class containerJavaType, String propertyName, Class propertyJavaType) {
        try {
            return ReflectHelper.findSetterMethod(containerJavaType, propertyName, propertyJavaType);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    @Override
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public Getter getGetter() {
        return this.getter;
    }

    @Override
    public Setter getSetter() {
        return this.setter;
    }
}

