/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.net.URI;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.WSTrustException;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.identity.federation.core.saml.v2.util.SignatureUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.core.wstrust.ClaimsProcessor;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.SecurityToken;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestContext;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.ClaimsType;
import org.picketlink.identity.federation.ws.trust.ComputedKeyType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.RequestedProofTokenType;
import org.picketlink.identity.federation.ws.trust.RequestedSecurityTokenType;
import org.picketlink.identity.federation.ws.trust.RequestedTokenCancelledType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandardRequestHandler
implements WSTrustRequestHandler {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static long KEY_SIZE = 128L;
    private STSConfiguration configuration;
    private boolean base64EncodeSecretKey = Boolean.parseBoolean(SystemPropertiesUtil.getSystemProperty((String)"picketlink.wstrust.base64_encode_wstrust_secret_key", (String)"false"));

    @Override
    public void initialize(STSConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public RequestSecurityTokenResponse issue(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        long keySize;
        URI keyType;
        String serviceName;
        logger.trace("Issuing token for principal " + callerPrincipal);
        AppliesTo appliesTo = request.getAppliesTo();
        X509Certificate providerCertificate = null;
        PublicKey providerPublicKey = null;
        if (appliesTo != null && (serviceName = WSTrustUtil.parseAppliesTo(appliesTo)) != null) {
            String tokenTypeFromServiceName = this.configuration.getTokenTypeForService(serviceName);
            if (request.getTokenType() == null && tokenTypeFromServiceName != null) {
                request.setTokenType(URI.create(tokenTypeFromServiceName));
            }
            if ((providerCertificate = this.configuration.getServiceProviderCertificate(serviceName)) != null) {
                providerPublicKey = providerCertificate.getPublicKey();
            }
        }
        WSTrustRequestContext requestContext = new WSTrustRequestContext(request, callerPrincipal);
        requestContext.setTokenIssuer(this.configuration.getSTSName());
        if (request.getLifetime() == null && this.configuration.getIssuedTokenTimeout() != 0L) {
            logger.stsTokenTimeoutNotSpecified();
            request.setLifetime(WSTrustUtil.createDefaultLifetime(this.configuration.getIssuedTokenTimeout()));
        }
        requestContext.setServiceProviderPublicKey(providerPublicKey);
        if (request.getClaims() != null) {
            ClaimsType claims = request.getClaims();
            ClaimsProcessor processor = this.configuration.getClaimsProcessor(claims.getDialect());
            if (processor != null) {
                requestContext.setClaimedAttributes(processor.processClaims(claims, callerPrincipal));
            } else if (logger.isDebugEnabled()) {
                logger.debug("Claims have been specified in the request but no processor was found for dialect " + claims.getDialect());
            }
        }
        if (request.getOnBehalfOf() != null) {
            Principal onBehalfOfPrincipal = WSTrustUtil.getOnBehalfOfPrincipal(request.getOnBehalfOf());
            requestContext.setOnBehalfOfPrincipal(onBehalfOfPrincipal);
        }
        if ((keyType = request.getKeyType()) == null) {
            logger.debug("No key type could be found in the request. Using the default BEARER type.");
            keyType = URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
            request.setKeyType(keyType);
        }
        if ((keySize = request.getKeySize()) == 0L) {
            logger.debug("No key size could be found in the request. Using the default size. (" + KEY_SIZE + ")");
            keySize = KEY_SIZE;
            request.setKeySize(keySize);
        }
        URI keyWrapAlgo = request.getKeyWrapAlgorithm();
        RequestedProofTokenType requestedProofToken = null;
        EntropyType serverEntropy = null;
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equalsIgnoreCase(keyType.toString())) {
            requestedProofToken = new RequestedProofTokenType();
            byte[] serverSecret = WSTrustUtil.createRandomSecret((int)keySize / 8);
            BinarySecretType serverBinarySecret = new BinarySecretType();
            serverBinarySecret.setType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Nonce");
            serverBinarySecret.setValue(Base64.encodeBytes((byte[])serverSecret).getBytes());
            byte[] clientSecret = null;
            EntropyType clientEntropy = request.getEntropy();
            if (clientEntropy != null) {
                clientSecret = Base64.decode((String)new String(WSTrustUtil.getBinarySecret(clientEntropy)));
                serverEntropy = new EntropyType();
                serverEntropy.addAny(serverBinarySecret);
            }
            if (clientSecret != null && clientSecret.length != 0) {
                requestedProofToken.add(new ComputedKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/CK/PSHA1"));
                byte[] combinedSecret = null;
                try {
                    combinedSecret = this.base64EncodeSecretKey ? Base64.encodeBytes((byte[])WSTrustUtil.P_SHA1(clientSecret, serverSecret, (int)keySize / 8)).getBytes() : WSTrustUtil.P_SHA1(clientSecret, serverSecret, (int)keySize / 8);
                }
                catch (Exception e) {
                    throw logger.wsTrustCombinedSecretKeyError((Throwable)e);
                }
                requestContext.setProofTokenInfo(WSTrustUtil.createKeyInfo(combinedSecret, providerPublicKey, keyWrapAlgo, providerCertificate));
            } else {
                requestedProofToken.add(serverBinarySecret);
                requestContext.setProofTokenInfo(WSTrustUtil.createKeyInfo(serverSecret, providerPublicKey, keyWrapAlgo, providerCertificate));
            }
        } else if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equalsIgnoreCase(keyType.toString())) {
            Certificate certificate = this.configuration.getCertificate(callerPrincipal.getName());
            if (certificate != null) {
                requestContext.setProofTokenInfo(WSTrustUtil.createKeyInfo(certificate));
            } else if (request.getUseKey() != null) {
                UseKeyType useKeyType = request.getUseKey();
                List<Object> theList = useKeyType.getAny();
                for (Object value : theList) {
                    if (value instanceof Element) {
                        Element keyElement = (Element)value;
                        String elementName = keyElement.getLocalName();
                        if (elementName.equals("X509Certificate")) {
                            X509DataType data = new X509DataType();
                            data.add(value);
                            value = data;
                        } else if (elementName.equals("KeyValue")) {
                            KeyValueType keyValue = null;
                            Element child = DocumentUtil.getChildElement((Element)keyElement, (QName)new QName("RSAKeyValue"));
                            if (child != null) {
                                try {
                                    keyValue = SignatureUtil.getRSAKeyValue(child);
                                }
                                catch (ParsingException e) {
                                    throw logger.stsError((Throwable)e);
                                }
                            }
                            if (keyValue == null && child == null) {
                                child = DocumentUtil.getChildElement((Element)keyElement, (QName)new QName("DSAKeyValue"));
                                if (child != null) {
                                    try {
                                        keyValue = SignatureUtil.getDSAKeyValue(child);
                                    }
                                    catch (ParsingException e) {
                                        throw logger.stsError((Throwable)e);
                                    }
                                }
                                value = keyValue;
                            }
                        }
                        KeyInfoType keyInfo = new KeyInfoType();
                        keyInfo.addContent(value);
                        requestContext.setProofTokenInfo(keyInfo);
                        continue;
                    }
                    if (value instanceof KeyInfoType) {
                        requestContext.setProofTokenInfo((KeyInfoType)value);
                        continue;
                    }
                    throw new WSTrustException((Throwable)logger.unsupportedType(value.toString()));
                }
            } else {
                throw logger.wsTrustClientPublicKeyError();
            }
        }
        try {
            if (request.getTokenType() != null) {
                requestContext.setTokenType(request.getTokenType().toString());
            }
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            sts.initialize(this.configuration);
            sts.issueToken(requestContext);
        }
        catch (ProcessingException e) {
            throw logger.stsError((Throwable)e);
        }
        if (requestContext.getSecurityToken() == null) {
            throw new WSTrustException((Throwable)logger.nullValueError("Token issued by STS"));
        }
        RequestedSecurityTokenType requestedSecurityToken = new RequestedSecurityTokenType();
        SecurityToken contextSecurityToken = requestContext.getSecurityToken();
        if (contextSecurityToken == null) {
            throw new WSTrustException((Throwable)logger.nullValueError("Security Token from context"));
        }
        requestedSecurityToken.add(contextSecurityToken.getTokenValue());
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setTokenType(request.getTokenType());
        response.setLifetime(request.getLifetime());
        response.setAppliesTo(appliesTo);
        response.setKeySize(keySize);
        response.setKeyType(keyType);
        response.setRequestedSecurityToken(requestedSecurityToken);
        if (requestedProofToken != null) {
            response.setRequestedProofToken(requestedProofToken);
        }
        if (serverEntropy != null) {
            response.setEntropy(serverEntropy);
        }
        if (requestContext.getAttachedReference() != null) {
            response.setRequestedAttachedReference(requestContext.getAttachedReference());
        }
        if (requestContext.getUnattachedReference() != null) {
            response.setRequestedUnattachedReference(requestContext.getUnattachedReference());
        }
        return response;
    }

    @Override
    public RequestSecurityTokenResponse renew(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        Node securityToken;
        block15: {
            logger.trace("Validating token for renew request " + request.getContext());
            if (request.getRenewTargetElement() == null) {
                throw new WSTrustException((Throwable)logger.nullValueError("renew target"));
            }
            securityToken = request.getRenewTargetElement().getFirstChild();
            if (securityToken == null) {
                throw new WSTrustException((Throwable)logger.nullValueError("security token"));
            }
            StandardRequestHandler.setupIDAttribute(securityToken);
            if (this.configuration.signIssuedToken() && this.configuration.getSTSKeyPair() != null) {
                KeyPair keyPair = this.configuration.getSTSKeyPair();
                try {
                    Document tokenDocument = DocumentUtil.createDocument();
                    Node importedNode = tokenDocument.importNode(securityToken, true);
                    tokenDocument.appendChild(importedNode);
                    XMLSignatureUtil.propagateIDAttributeSetup(securityToken, tokenDocument.getDocumentElement());
                    if (!XMLSignatureUtil.validate(tokenDocument, keyPair.getPublic())) {
                        throw new WSTrustException((Throwable)logger.signatureInvalidError("Validation failure during renewal", null));
                    }
                    break block15;
                }
                catch (Exception e) {
                    throw new WSTrustException((Throwable)logger.signatureInvalidError("Validation failure during renewal:", (Throwable)e));
                }
            }
            logger.stsSecurityTokenSignatureNotVerified();
        }
        if (request.getLifetime() == null && this.configuration.getIssuedTokenTimeout() != 0L) {
            logger.stsTokenTimeoutNotSpecified();
            request.setLifetime(WSTrustUtil.createDefaultLifetime(this.configuration.getIssuedTokenTimeout()));
        }
        WSTrustRequestContext context = new WSTrustRequestContext(request, callerPrincipal);
        context.setTokenIssuer(this.configuration.getSTSName());
        if (request.getOnBehalfOf() != null) {
            Principal onBehalfOfPrincipal = WSTrustUtil.getOnBehalfOfPrincipal(request.getOnBehalfOf());
            context.setOnBehalfOfPrincipal(onBehalfOfPrincipal);
        }
        try {
            if (securityToken != null) {
                String ns = securityToken.getNamespaceURI();
                context.setQName(new QName(ns, securityToken.getLocalName()));
            }
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            sts.initialize(this.configuration);
            sts.renewToken(context);
        }
        catch (ProcessingException e) {
            throw new WSTrustException(e.getMessage(), (Throwable)e);
        }
        RequestedSecurityTokenType requestedSecurityToken = new RequestedSecurityTokenType();
        SecurityToken contextSecurityToken = context.getSecurityToken();
        if (contextSecurityToken == null) {
            throw new WSTrustException((Throwable)logger.nullValueError("Security Token from context"));
        }
        requestedSecurityToken.add(contextSecurityToken.getTokenValue());
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setTokenType(request.getTokenType());
        response.setLifetime(request.getLifetime());
        response.setRequestedSecurityToken(requestedSecurityToken);
        if (context.getAttachedReference() != null) {
            response.setRequestedAttachedReference(context.getAttachedReference());
        }
        if (context.getUnattachedReference() != null) {
            response.setRequestedUnattachedReference(context.getUnattachedReference());
        }
        return response;
    }

    @Override
    public RequestSecurityTokenResponse validate(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        Node securityToken;
        logger.trace("Started validation for request " + request.getContext());
        if (request.getValidateTargetElement() == null) {
            throw new WSTrustException((Throwable)logger.nullValueError("request does not have a validate target. Unable to validate token"));
        }
        if (request.getTokenType() == null) {
            request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        }
        if ((securityToken = request.getValidateTargetElement().getFirstChild()) == null) {
            throw new WSTrustException((Throwable)logger.nullValueError("security token:Unable to validate token"));
        }
        StandardRequestHandler.setupIDAttribute(securityToken);
        WSTrustRequestContext context = new WSTrustRequestContext(request, callerPrincipal);
        if (request.getOnBehalfOf() != null) {
            Principal onBehalfOfPrincipal = WSTrustUtil.getOnBehalfOfPrincipal(request.getOnBehalfOf());
            context.setOnBehalfOfPrincipal(onBehalfOfPrincipal);
        }
        StatusType status = null;
        if (this.configuration.signIssuedToken() && this.configuration.getSTSKeyPair() != null) {
            KeyPair keyPair = this.configuration.getSTSKeyPair();
            try {
                if (logger.isTraceEnabled()) {
                    try {
                        logger.trace("Going to validate signature for: " + DocumentUtil.getNodeAsString((Node)securityToken));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Document tokenDocument = DocumentUtil.createDocument();
                Node importedNode = tokenDocument.importNode(securityToken, true);
                tokenDocument.appendChild(importedNode);
                XMLSignatureUtil.propagateIDAttributeSetup(securityToken, tokenDocument.getDocumentElement());
                if (!XMLSignatureUtil.validate(tokenDocument, keyPair.getPublic())) {
                    status = new StatusType();
                    status.setCode("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid");
                    status.setReason("Validation failure: digital signature is invalid");
                }
            }
            catch (Exception e) {
                status = new StatusType();
                status.setCode("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid");
                status.setReason("Validation failure: unable to verify digital signature: " + e.getMessage());
            }
        } else {
            logger.stsSecurityTokenSignatureNotVerified();
        }
        if (status == null) {
            logger.trace("Delegating token validation to token provider. Token NS: " + securityToken.getNamespaceURI() + " ::LocalName: " + securityToken.getLocalName());
            try {
                if (securityToken != null) {
                    context.setQName(new QName(securityToken.getNamespaceURI(), securityToken.getLocalName()));
                }
                PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
                sts.initialize(this.configuration);
                sts.validateToken(context);
            }
            catch (ProcessingException e) {
                throw logger.stsError((Throwable)e);
            }
            status = context.getStatus();
        }
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setTokenType(request.getTokenType());
        response.setStatus(status);
        return response;
    }

    @Override
    public RequestSecurityTokenResponse cancel(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        if (request.getCancelTargetElement() == null) {
            throw new WSTrustException((Throwable)logger.nullValueError("request does not have a cancel target. Unable to cancel token"));
        }
        Node securityToken = request.getCancelTargetElement().getFirstChild();
        if (securityToken == null) {
            throw new WSTrustException((Throwable)logger.nullValueError("security token. Unable to cancel token"));
        }
        WSTrustRequestContext context = new WSTrustRequestContext(request, callerPrincipal);
        if (request.getOnBehalfOf() != null) {
            Principal onBehalfOfPrincipal = WSTrustUtil.getOnBehalfOfPrincipal(request.getOnBehalfOf());
            context.setOnBehalfOfPrincipal(onBehalfOfPrincipal);
        }
        try {
            if (securityToken != null) {
                context.setQName(new QName(securityToken.getNamespaceURI(), securityToken.getLocalName()));
            }
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            sts.initialize(this.configuration);
            sts.cancelToken(context);
        }
        catch (ProcessingException e) {
            throw logger.stsError((Throwable)e);
        }
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setRequestedTokenCancelled(new RequestedTokenCancelledType());
        return response;
    }

    @Override
    public Document postProcess(Document rstrDocument, RequestSecurityToken request) throws WSTrustException {
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue".equals(request.getRequestType().toString()) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew".equals(request.getRequestType().toString())) {
            rstrDocument = DocumentUtil.normalizeNamespaces((Document)rstrDocument);
            if (this.configuration.signIssuedToken() && this.configuration.getSTSKeyPair() != null) {
                KeyPair keyPair = this.configuration.getSTSKeyPair();
                URI signatureURI = request.getSignatureAlgorithm();
                String signatureMethod = signatureURI != null ? signatureURI.toString() : "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                try {
                    Node rst = rstrDocument.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken").item(0);
                    Element tokenElement = (Element)rst.getFirstChild();
                    logger.trace("NamespaceURI of element to be signed: " + tokenElement.getNamespaceURI());
                    X509Certificate x509Certificate = null;
                    String signingCertificateAlias = this.configuration.getSigningCertificateAlias();
                    if (signingCertificateAlias != null) {
                        x509Certificate = (X509Certificate)this.configuration.getCertificate(signingCertificateAlias);
                    }
                    XMLSignatureUtil.setCanonicalizationMethodType(this.configuration.getXMLDSigCanonicalizationMethod());
                    rstrDocument = XMLSignatureUtil.sign(rstrDocument, (Node)tokenElement, keyPair, "http://www.w3.org/2000/09/xmldsig#sha1", signatureMethod, StandardRequestHandler.setupIDAttribute(tokenElement), x509Certificate);
                    if (logger.isTraceEnabled()) {
                        try {
                            Document tokenDocument = DocumentUtil.createDocument();
                            tokenDocument.appendChild(tokenDocument.importNode(tokenElement, true));
                            logger.trace("valid=" + XMLSignatureUtil.validate(tokenDocument, keyPair.getPublic()));
                        }
                        catch (Exception tokenDocument) {}
                    }
                }
                catch (Exception e) {
                    throw new WSTrustException((Throwable)logger.signatureError((Throwable)e));
                }
            }
            if (this.configuration.encryptIssuedToken()) {
                PublicKey providerPublicKey = null;
                if (request.getAppliesTo() != null) {
                    String serviceName = WSTrustUtil.parseAppliesTo(request.getAppliesTo());
                    logger.trace("Locating public key for " + serviceName);
                    if (serviceName != null) {
                        providerPublicKey = this.configuration.getServiceProviderPublicKey(serviceName);
                    }
                }
                if (providerPublicKey == null) {
                    logger.stsSecurityTokenShouldBeEncrypted();
                } else {
                    long keySize = request.getKeySize();
                    byte[] secret = WSTrustUtil.createRandomSecret((int)keySize / 8);
                    SecretKeySpec secretKey = new SecretKeySpec(secret, "AES");
                    Node rst = rstrDocument.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken").item(0);
                    Element tokenElement = (Element)rst.getFirstChild();
                    try {
                        XMLEncryptionUtil.encryptElement(rstrDocument, tokenElement, providerPublicKey, secretKey, (int)keySize);
                    }
                    catch (ProcessingException e) {
                        throw new WSTrustException((Throwable)logger.encryptProcessError((Throwable)e));
                    }
                }
            }
        }
        return rstrDocument;
    }

    private static String setupIDAttribute(Node node) {
        Element assertion;
        if (node instanceof Element && (assertion = (Element)node).getLocalName().equals("Assertion")) {
            if (assertion.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion") && assertion.hasAttribute("ID")) {
                assertion.setIdAttribute("ID", true);
                return "#" + assertion.getAttribute("ID");
            }
            if (assertion.getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion") && assertion.hasAttribute("AssertionID")) {
                assertion.setIdAttribute("AssertionID", true);
                return "#" + assertion.getAttribute("AssertionID");
            }
        }
        return "";
    }
}

