/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.FailoverEventListener;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.ClientConsumerImpl;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.client.impl.ClientProducerCreditManager;
import org.hornetq.core.client.impl.ClientProducerCreditManagerImpl;
import org.hornetq.core.client.impl.ClientProducerCredits;
import org.hornetq.core.client.impl.ClientProducerImpl;
import org.hornetq.core.client.impl.ClientProducerInternal;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.CommandConfirmationHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.RollbackMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionAddMetaDataMessageV2;
import org.hornetq.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionCloseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.hornetq.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionUniqueAddMetaDataMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAAfterFailedMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.utils.ConfirmationWindowWarning;
import org.hornetq.utils.IDGenerator;
import org.hornetq.utils.SimpleIDGenerator;
import org.hornetq.utils.TokenBucketLimiterImpl;
import org.hornetq.utils.XidCodecSupport;

public final class ClientSessionImpl
implements ClientSessionInternal,
FailureListener,
CommandConfirmationHandler {
    private final Map<String, String> metadata = new HashMap<String, String>();
    private final ClientSessionFactoryInternal sessionFactory;
    private final String name;
    private final String username;
    private final String password;
    private final boolean xa;
    private final Executor executor;
    private final Executor flowControlExecutor;
    private volatile CoreRemotingConnection remotingConnection;
    private final Set<ClientProducerInternal> producers = new HashSet<ClientProducerInternal>();
    private final Map<Long, ClientConsumerInternal> consumers = new LinkedHashMap<Long, ClientConsumerInternal>();
    private volatile boolean closed;
    private final boolean autoCommitAcks;
    private final boolean preAcknowledge;
    private final boolean autoCommitSends;
    private final boolean blockOnAcknowledge;
    private final boolean autoGroup;
    private final int ackBatchSize;
    private final int consumerWindowSize;
    private final int consumerMaxRate;
    private final int confirmationWindowSize;
    private final int producerMaxRate;
    private final boolean blockOnNonDurableSend;
    private final boolean blockOnDurableSend;
    private final int minLargeMessageSize;
    private final boolean compressLargeMessages;
    private volatile int initialMessagePacketSize;
    private final boolean cacheLargeMessageClient;
    private final Channel channel;
    private final int version;
    private boolean forceNotSameRM;
    private final IDGenerator idGenerator = new SimpleIDGenerator(0L);
    private final ClientProducerCreditManager producerCreditManager;
    private volatile boolean started;
    private SendAcknowledgementHandler sendAckHandler;
    private volatile boolean rollbackOnly;
    private volatile boolean workDone;
    private final String groupID;
    private volatile boolean inClose;
    private volatile boolean mayAttemptToFailover = true;
    private volatile SimpleString defaultAddress;
    private boolean xaRetry = false;
    private Xid currentXID;
    private final AtomicInteger concurrentCall = new AtomicInteger(0);
    private final ConfirmationWindowWarning confirmationWindowWarning;

    ClientSessionImpl(ClientSessionFactoryInternal sessionFactory, String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean blockOnAcknowledge, boolean autoGroup, int ackBatchSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnNonDurableSend, boolean blockOnDurableSend, boolean cacheLargeMessageClient, int minLargeMessageSize, boolean compressLargeMessages, int initialMessagePacketSize, String groupID, CoreRemotingConnection remotingConnection, int version, Channel channel, Executor executor, Executor flowControlExecutor) throws HornetQException {
        this.sessionFactory = sessionFactory;
        this.name = name;
        this.username = username;
        this.password = password;
        this.remotingConnection = remotingConnection;
        this.executor = executor;
        this.flowControlExecutor = flowControlExecutor;
        this.xa = xa;
        this.autoCommitAcks = autoCommitAcks;
        this.preAcknowledge = preAcknowledge;
        this.autoCommitSends = autoCommitSends;
        this.blockOnAcknowledge = blockOnAcknowledge;
        this.autoGroup = autoGroup;
        this.channel = channel;
        this.version = version;
        this.ackBatchSize = ackBatchSize;
        this.consumerWindowSize = consumerWindowSize;
        this.consumerMaxRate = consumerMaxRate;
        this.confirmationWindowSize = confirmationWindowSize;
        this.producerMaxRate = producerMaxRate;
        this.blockOnNonDurableSend = blockOnNonDurableSend;
        this.blockOnDurableSend = blockOnDurableSend;
        this.cacheLargeMessageClient = cacheLargeMessageClient;
        this.minLargeMessageSize = minLargeMessageSize;
        this.compressLargeMessages = compressLargeMessages;
        this.initialMessagePacketSize = initialMessagePacketSize;
        this.groupID = groupID;
        this.producerCreditManager = new ClientProducerCreditManagerImpl(this, producerWindowSize);
        if (confirmationWindowSize >= 0) {
            this.channel.setCommandConfirmationHandler(this);
        }
        this.confirmationWindowWarning = sessionFactory.getConfirmationWindowWarning();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName) throws HornetQException {
        this.internalCreateQueue(address, queueName, null, false, false);
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, boolean durable) throws HornetQException {
        this.internalCreateQueue(address, queueName, null, durable, false);
    }

    @Override
    public void createQueue(String address, String queueName, boolean durable) throws HornetQException {
        this.createQueue(SimpleString.toSimpleString(address), SimpleString.toSimpleString(queueName), durable);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, boolean durable) throws HornetQException {
        this.createSharedQueue(address, queueName, null, durable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws HornetQException {
        this.checkClosed();
        CreateSharedQueueMessage request = new CreateSharedQueueMessage(address, queueName, filterString, durable, true);
        this.startCall();
        try {
            this.channel.sendBlocking(request, (byte)21);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws HornetQException {
        this.internalCreateQueue(address, queueName, filterString, durable, false);
    }

    @Override
    public void createQueue(String address, String queueName, String filterString, boolean durable) throws HornetQException {
        this.createQueue(SimpleString.toSimpleString(address), SimpleString.toSimpleString(queueName), SimpleString.toSimpleString(filterString), durable);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName) throws HornetQException {
        this.internalCreateQueue(address, queueName, null, false, true);
    }

    @Override
    public void createTemporaryQueue(String address, String queueName) throws HornetQException {
        this.internalCreateQueue(SimpleString.toSimpleString(address), SimpleString.toSimpleString(queueName), null, false, true);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName, SimpleString filter) throws HornetQException {
        this.internalCreateQueue(address, queueName, filter, false, true);
    }

    @Override
    public void createTemporaryQueue(String address, String queueName, String filter) throws HornetQException {
        this.internalCreateQueue(SimpleString.toSimpleString(address), SimpleString.toSimpleString(queueName), SimpleString.toSimpleString(filter), false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(SimpleString queueName) throws HornetQException {
        this.checkClosed();
        this.startCall();
        try {
            this.channel.sendBlocking(new SessionDeleteQueueMessage(queueName), (byte)21);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void deleteQueue(String queueName) throws HornetQException {
        this.deleteQueue(SimpleString.toSimpleString(queueName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSession.QueueQuery queueQuery(SimpleString queueName) throws HornetQException {
        this.checkClosed();
        SessionQueueQueryMessage request = new SessionQueueQueryMessage(queueName);
        this.startCall();
        try {
            SessionQueueQueryResponseMessage response = (SessionQueueQueryResponseMessage)this.channel.sendBlocking(request, (byte)46);
            QueueQueryImpl queueQueryImpl = new QueueQueryImpl(response.isDurable(), response.getConsumerCount(), response.getMessageCount(), response.getFilterString(), response.getAddress(), response.isExists());
            return queueQueryImpl;
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public ClientSession.BindingQuery bindingQuery(SimpleString address) throws HornetQException {
        this.checkClosed();
        SessionBindingQueryMessage request = new SessionBindingQueryMessage(address);
        SessionBindingQueryResponseMessage response = (SessionBindingQueryResponseMessage)this.channel.sendBlocking(request, (byte)50);
        return new BindingQueryImpl(response.isExists(), response.getQueueNames());
    }

    @Override
    public void forceDelivery(long consumerID, long sequence) throws HornetQException {
        this.checkClosed();
        SessionForceConsumerDelivery request = new SessionForceConsumerDelivery(consumerID, sequence);
        this.channel.send(request);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName) throws HornetQException {
        return this.createConsumer(queueName, null, false);
    }

    @Override
    public ClientConsumer createConsumer(String queueName) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString(queueName));
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString) throws HornetQException {
        return this.createConsumer(queueName, filterString, this.consumerWindowSize, this.consumerMaxRate, false);
    }

    @Override
    public void createQueue(String address, String queueName) throws HornetQException {
        this.createQueue(SimpleString.toSimpleString(address), SimpleString.toSimpleString(queueName));
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString(queueName), SimpleString.toSimpleString(filterString));
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, boolean browseOnly) throws HornetQException {
        return this.createConsumer(queueName, filterString, this.consumerWindowSize, this.consumerMaxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, boolean browseOnly) throws HornetQException {
        return this.createConsumer(queueName, null, this.consumerWindowSize, this.consumerMaxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString, boolean browseOnly) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString(queueName), SimpleString.toSimpleString(filterString), browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, boolean browseOnly) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString(queueName), null, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, boolean browseOnly) throws HornetQException {
        return this.internalCreateConsumer(queueName, filterString, windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString, int windowSize, int maxRate, boolean browseOnly) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString(queueName), SimpleString.toSimpleString(filterString), windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientProducer createProducer() throws HornetQException {
        return this.createProducer((SimpleString)null);
    }

    @Override
    public ClientProducer createProducer(SimpleString address) throws HornetQException {
        return this.createProducer(address, this.producerMaxRate);
    }

    @Override
    public ClientProducer createProducer(String address) throws HornetQException {
        return this.createProducer(SimpleString.toSimpleString(address));
    }

    @Override
    public ClientProducer createProducer(SimpleString address, int maxRate) throws HornetQException {
        return this.internalCreateProducer(address, maxRate);
    }

    public ClientProducer createProducer(String address, int rate) throws HornetQException {
        return this.createProducer(SimpleString.toSimpleString(address), rate);
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    private void rollbackOnFailover(boolean outcomeKnown) throws HornetQException {
        this.rollback(false);
        if (outcomeKnown) {
            throw HornetQClientMessageBundle.BUNDLE.txRolledBack();
        }
        throw HornetQClientMessageBundle.BUNDLE.txOutcomeUnknown();
    }

    @Override
    public void commit() throws HornetQException {
        this.checkClosed();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Sending commit");
        }
        if (this.rollbackOnly) {
            this.rollbackOnFailover(true);
        }
        this.flushAcks();
        if (this.rollbackOnly) {
            this.rollbackOnFailover(true);
        }
        try {
            this.channel.sendBlocking(new PacketImpl(43), (byte)21);
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.UNBLOCKED || this.rollbackOnly) {
                this.rollbackOnFailover(false);
            }
            throw e;
        }
        if (this.rollbackOnly) {
            this.rollbackOnFailover(false);
        }
        this.workDone = false;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public void rollback() throws HornetQException {
        this.rollback(false);
    }

    @Override
    public void rollback(boolean isLastMessageAsDelivered) throws HornetQException {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("calling rollback(isLastMessageAsDelivered=" + isLastMessageAsDelivered + ")");
        }
        this.checkClosed();
        boolean wasStarted = this.started;
        if (wasStarted) {
            this.stop();
        }
        for (ClientConsumerInternal consumer : this.cloneConsumers()) {
            consumer.clear(true);
        }
        this.flushAcks();
        this.channel.sendBlocking(new RollbackMessage(isLastMessageAsDelivered), (byte)21);
        if (wasStarted) {
            this.start();
        }
        this.rollbackOnly = false;
    }

    @Override
    public ClientMessage createMessage(byte type, boolean durable, long expiration, long timestamp, byte priority) {
        return new ClientMessageImpl(type, durable, expiration, timestamp, priority, this.initialMessagePacketSize);
    }

    @Override
    public ClientMessage createMessage(byte type, boolean durable) {
        return this.createMessage(type, durable, 0L, System.currentTimeMillis(), (byte)4);
    }

    @Override
    public ClientMessage createMessage(boolean durable) {
        return this.createMessage((byte)0, durable);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isAutoCommitSends() {
        return this.autoCommitSends;
    }

    @Override
    public boolean isAutoCommitAcks() {
        return this.autoCommitAcks;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public boolean isXA() {
        return this.xa;
    }

    @Override
    public void resetIfNeeded() throws HornetQException {
        if (this.rollbackOnly) {
            HornetQClientLogger.LOGGER.resettingSessionAfterFailure();
            this.rollback(false);
        }
    }

    @Override
    public void start() throws HornetQException {
        this.checkClosed();
        if (!this.started) {
            for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                clientConsumerInternal.start();
            }
            this.channel.send(new PacketImpl(67));
            this.started = true;
        }
    }

    @Override
    public void stop() throws HornetQException {
        this.stop(true);
    }

    public void stop(boolean waitForOnMessage) throws HornetQException {
        this.checkClosed();
        if (this.started) {
            for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                clientConsumerInternal.stop(waitForOnMessage);
            }
            this.channel.sendBlocking(new PacketImpl(68), (byte)21);
            this.started = false;
        }
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.sessionFactory.addFailureListener(listener);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.sessionFactory.removeFailureListener(listener);
    }

    @Override
    public void addFailoverListener(FailoverEventListener listener) {
        this.sessionFactory.addFailoverListener(listener);
    }

    @Override
    public boolean removeFailoverListener(FailoverEventListener listener) {
        return this.sessionFactory.removeFailoverListener(listener);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public boolean isCompressLargeMessages() {
        return this.compressLargeMessages;
    }

    @Override
    public boolean isCacheLargeMessageClient() {
        return this.cacheLargeMessageClient;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(long consumerID, long messageID) throws HornetQException {
        if (this.preAcknowledge) {
            return;
        }
        this.checkClosed();
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug("client ack messageID = " + messageID);
        }
        SessionAcknowledgeMessage message = new SessionAcknowledgeMessage(consumerID, messageID, this.blockOnAcknowledge);
        this.startCall();
        try {
            if (this.blockOnAcknowledge) {
                this.channel.sendBlocking(message, (byte)21);
            } else {
                this.channel.sendBatched(message);
            }
        }
        finally {
            this.endCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void individualAcknowledge(long consumerID, long messageID) throws HornetQException {
        if (this.preAcknowledge) {
            return;
        }
        this.checkClosed();
        SessionIndividualAcknowledgeMessage message = new SessionIndividualAcknowledgeMessage(consumerID, messageID, this.blockOnAcknowledge);
        this.startCall();
        try {
            if (this.blockOnAcknowledge) {
                this.channel.sendBlocking(message, (byte)21);
            } else {
                this.channel.sendBatched(message);
            }
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void expire(long consumerID, long messageID) throws HornetQException {
        this.checkClosed();
        if (!this.preAcknowledge) {
            SessionExpireMessage message = new SessionExpireMessage(consumerID, messageID);
            this.channel.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(ClientConsumerInternal consumer) {
        Map<Long, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            this.consumers.put(consumer.getID(), consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ClientProducerInternal producer) {
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ClientConsumerInternal consumer) throws HornetQException {
        Map<Long, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            this.consumers.remove(consumer.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ClientProducerInternal producer) {
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            this.producers.remove(producer);
        }
    }

    @Override
    public void handleReceiveMessage(long consumerID, SessionReceiveMessage message) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            ClientMessageInternal clMessage = (ClientMessageInternal)message.getMessage();
            clMessage.setDeliveryCount(message.getDeliveryCount());
            clMessage.setFlowControlSize(message.getPacketSize());
            consumer.handleMessage(message);
        }
    }

    @Override
    public void handleReceiveLargeMessage(long consumerID, SessionReceiveLargeMessage message) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            consumer.handleLargeMessage(message);
        }
    }

    @Override
    public void handleReceiveContinuation(long consumerID, SessionReceiveContinuationMessage continuation) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            consumer.handleLargeMessageContinuation(continuation);
        }
    }

    @Override
    public void handleConsumerDisconnect(long consumerID) throws HornetQException {
        final ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        consumer.close();
                    }
                    catch (HornetQException e) {
                        HornetQClientLogger.LOGGER.unableToCloseConsumer(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HornetQException {
        if (this.closed) {
            HornetQClientLogger.LOGGER.debug("Session was already closed, giving up now, this=" + this);
            return;
        }
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug("Calling close on session " + this);
        }
        try {
            this.closeChildren();
            ClientSessionImpl clientSessionImpl = this;
            synchronized (clientSessionImpl) {
                this.producerCreditManager.close();
            }
            this.inClose = true;
            this.channel.sendBlocking(new SessionCloseMessage(), (byte)21);
        }
        catch (Throwable e) {
            HornetQClientLogger.LOGGER.trace("Failed to close session", e);
        }
        this.doCleanup(false);
    }

    @Override
    public synchronized void cleanUp(boolean failingOver) throws HornetQException {
        if (this.closed) {
            return;
        }
        this.producerCreditManager.close();
        this.cleanUpChildren();
        this.doCleanup(failingOver);
    }

    @Override
    public void setSendAcknowledgementHandler(SendAcknowledgementHandler handler) {
        this.channel.setCommandConfirmationHandler(this);
        this.sendAckHandler = handler;
    }

    @Override
    public void preHandleFailover(CoreRemotingConnection connection) {
        this.channel.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFailover(CoreRemotingConnection backupConnection) {
        HashMap<String, String> metaDataToSend;
        ClientSessionImpl clientSessionImpl = this;
        synchronized (clientSessionImpl) {
            if (this.closed) {
                return;
            }
            boolean resetCreditManager = false;
            try {
                this.channel.transferConnection(backupConnection);
                backupConnection.syncIDGeneratorSequence(this.remotingConnection.getIDGeneratorSequence());
                this.remotingConnection = backupConnection;
                int lcid = this.channel.getLastConfirmedCommandID();
                ReattachSessionMessage request = new ReattachSessionMessage(this.name, lcid);
                Channel channel1 = backupConnection.getChannel(1L, -1);
                ReattachSessionResponseMessage response = (ReattachSessionResponseMessage)channel1.sendBlocking(request, (byte)33);
                if (response.isReattached()) {
                    if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                        HornetQClientLogger.LOGGER.debug("ClientSession reattached fine, replaying commands");
                    }
                    this.channel.replayCommands(response.getLastConfirmedCommandID());
                } else {
                    if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                        HornetQClientLogger.LOGGER.debug("ClientSession couldn't be reattached, creating a new session");
                    }
                    for (ClientConsumerInternal consumer : this.cloneConsumers()) {
                        consumer.clearAtFailover();
                    }
                    if (!this.inClose && this.mayAttemptToFailover) {
                        CreateSessionMessage createRequest = new CreateSessionMessage(this.name, this.channel.getID(), this.version, this.username, this.password, this.minLargeMessageSize, this.xa, this.autoCommitSends, this.autoCommitAcks, this.preAcknowledge, this.confirmationWindowSize, this.defaultAddress == null ? null : this.defaultAddress.toString());
                        boolean retry = false;
                        do {
                            try {
                                channel1.sendBlocking(createRequest, (byte)31);
                                retry = false;
                            }
                            catch (HornetQException e) {
                                if (e.getType() == HornetQExceptionType.SESSION_CREATION_REJECTED) {
                                    HornetQClientLogger.LOGGER.retryCreateSessionSeverStarting(this.name);
                                    retry = true;
                                    Thread.sleep(10L);
                                    continue;
                                }
                                throw e;
                            }
                        } while (retry && !this.inClose);
                        this.channel.clearCommands();
                        for (Map.Entry<Long, ClientConsumerInternal> entry : this.consumers.entrySet()) {
                            SessionConsumerFlowCreditMessage packet;
                            SessionQueueQueryResponseMessage queueInfo = entry.getValue().getQueueInfo();
                            if (!queueInfo.isDurable()) {
                                CreateQueueMessage createQueueRequest = new CreateQueueMessage(queueInfo.getAddress(), queueInfo.getName(), queueInfo.getFilterString(), false, queueInfo.isTemporary(), false);
                                this.sendPacketWithoutLock(createQueueRequest);
                            }
                            SessionCreateConsumerMessage createConsumerRequest = new SessionCreateConsumerMessage(entry.getKey(), entry.getValue().getQueueName(), entry.getValue().getFilterString(), entry.getValue().isBrowseOnly(), false);
                            this.sendPacketWithoutLock(createConsumerRequest);
                            int clientWindowSize = entry.getValue().getClientWindowSize();
                            if (clientWindowSize != 0) {
                                packet = new SessionConsumerFlowCreditMessage(entry.getKey(), clientWindowSize);
                                this.sendPacketWithoutLock(packet);
                                continue;
                            }
                            packet = new SessionConsumerFlowCreditMessage(entry.getKey(), 1);
                            this.sendPacketWithoutLock(packet);
                        }
                        if (!(this.autoCommitAcks && this.autoCommitSends || !this.workDone)) {
                            this.rollbackOnly = true;
                        }
                        if (this.currentXID != null) {
                            this.sendPacketWithoutLock(new SessionXAAfterFailedMessage(this.currentXID));
                            this.rollbackOnly = true;
                        }
                        if (this.started) {
                            for (ClientConsumerInternal consumer : this.cloneConsumers()) {
                                consumer.clearAtFailover();
                                consumer.start();
                            }
                            PacketImpl packet = new PacketImpl(67);
                            packet.setChannelID(this.channel.getID());
                            Connection conn = this.channel.getConnection().getTransportConnection();
                            HornetQBuffer buffer = packet.encode(this.channel.getConnection());
                            conn.write(buffer, false, false);
                        }
                        resetCreditManager = true;
                    }
                    this.channel.returnBlocking();
                }
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.failedToHandleFailover(t);
            }
            finally {
                this.channel.setTransferring(false);
                this.channel.unlock();
            }
            if (resetCreditManager) {
                this.producerCreditManager.reset();
            }
        }
        Map<String, String> resetCreditManager = this.metadata;
        synchronized (resetCreditManager) {
            metaDataToSend = new HashMap<String, String>(this.metadata);
        }
        for (Map.Entry<String, String> entries : metaDataToSend.entrySet()) {
            this.sendPacketWithoutLock(new SessionAddMetaDataMessageV2(entries.getKey(), entries.getValue(), false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetaData(String key, String data) throws HornetQException {
        Map<String, String> map = this.metadata;
        synchronized (map) {
            this.metadata.put(key, data);
        }
        this.channel.sendBlocking(new SessionAddMetaDataMessageV2(key, data), (byte)21);
    }

    @Override
    public void addUniqueMetaData(String key, String data) throws HornetQException {
        this.channel.sendBlocking(new SessionUniqueAddMetaDataMessage(key, data), (byte)21);
    }

    @Override
    public ClientSessionFactoryInternal getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void setAddress(Message message, SimpleString address) {
        if (this.defaultAddress == null) {
            this.defaultAddress = address;
            message.setAddress(address);
        } else if (!address.equals(this.defaultAddress)) {
            message.setAddress(address);
        } else {
            message.setAddress(null);
        }
    }

    @Override
    public void setPacketSize(int packetSize) {
        if (packetSize > this.initialMessagePacketSize) {
            this.initialMessagePacketSize = (int)((double)packetSize * 1.2);
        }
    }

    private void sendPacketWithoutLock(Packet packet) {
        packet.setChannelID(this.channel.getID());
        Connection conn = this.channel.getConnection().getTransportConnection();
        HornetQBuffer buffer = packet.encode(this.channel.getConnection());
        conn.write(buffer, false, false);
    }

    @Override
    public void workDone() {
        this.workDone = true;
    }

    @Override
    public void returnBlocking() {
        this.channel.returnBlocking();
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        this.channel.send(new SessionRequestProducerCreditsMessage(credits, address));
    }

    @Override
    public synchronized ClientProducerCredits getCredits(SimpleString address, boolean anon) {
        return this.producerCreditManager.getCredits(address, anon);
    }

    @Override
    public void returnCredits(SimpleString address) {
        this.producerCreditManager.returnCredits(address);
    }

    @Override
    public void handleReceiveProducerCredits(SimpleString address, int credits) {
        this.producerCreditManager.receiveCredits(address, credits);
    }

    @Override
    public void handleReceiveProducerFailCredits(SimpleString address, int credits) {
        this.producerCreditManager.receiveFailCredits(address, credits);
    }

    @Override
    public ClientProducerCreditManager getProducerCreditManager() {
        return this.producerCreditManager;
    }

    @Override
    public void startCall() {
        if (this.concurrentCall.incrementAndGet() > 1) {
            HornetQClientLogger.LOGGER.invalidConcurrentSessionUsage(new Exception("trace"));
        }
    }

    @Override
    public void endCall() {
        this.concurrentCall.decrementAndGet();
    }

    @Override
    public void commandConfirmed(Packet packet) {
        SessionSendContinuationMessage scm;
        if (packet.getType() == 71) {
            SessionSendMessage ssm = (SessionSendMessage)packet;
            this.callSendAck(ssm.getHandler(), ssm.getMessage());
        } else if (packet.getType() == 73 && !(scm = (SessionSendContinuationMessage)packet).isContinues()) {
            this.callSendAck(scm.getHandler(), scm.getMessage());
        }
    }

    private void callSendAck(SendAcknowledgementHandler handler, Message message) {
        if (handler != null) {
            handler.sendAcknowledged(message);
        } else if (this.sendAckHandler != null) {
            this.sendAckHandler.sendAcknowledged(message);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("call commit(xid=" + this.convert(xid));
        }
        this.checkXA();
        if (this.rollbackOnly) {
            HornetQClientLogger.LOGGER.commitAfterFailover();
        }
        SessionXACommitMessage packet = new SessionXACommitMessage(xid, onePhase);
        this.startCall();
        try {
            SessionXAResponseMessage response = (SessionXAResponseMessage)this.channel.sendBlocking(packet, (byte)55);
            this.workDone = false;
            if (response.isError()) {
                throw new XAException(response.getResponseCode());
            }
            if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
                HornetQClientLogger.LOGGER.trace("finished commit on " + this.convert(xid) + " with response = " + response);
            }
        }
        catch (HornetQException e) {
            HornetQClientLogger.LOGGER.failoverDuringCommit();
            this.xaRetry = true;
            throw new XAException(4);
        }
        finally {
            this.endCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Calling end:: " + this.convert(xid) + ", flags=" + this.convertTXFlag(flags));
        }
        this.checkXA();
        try {
            if (this.rollbackOnly) {
                try {
                    this.rollback();
                }
                catch (Exception ignored) {
                    HornetQClientLogger.LOGGER.debug("Error on rollback during end call!", ignored);
                }
                throw new XAException(104);
            }
            try {
                SessionXAResponseMessage response;
                PacketImpl packet;
                if (flags == 0x2000000) {
                    packet = new PacketImpl(58);
                } else if (flags == 0x4000000) {
                    packet = new SessionXAEndMessage(xid, false);
                } else if (flags == 0x20000000) {
                    packet = new SessionXAEndMessage(xid, true);
                } else {
                    throw new XAException(-5);
                }
                this.flushAcks();
                this.startCall();
                try {
                    response = (SessionXAResponseMessage)this.channel.sendBlocking(packet, (byte)55);
                }
                finally {
                    this.endCall();
                }
                if (response.isError()) {
                    throw new XAException(response.getResponseCode());
                }
            }
            catch (HornetQException e) {
                HornetQClientLogger.LOGGER.errorCallingEnd(e);
                throw new XAException(-3);
            }
        }
        finally {
            this.currentXID = null;
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.checkXA();
        this.startCall();
        try {
            SessionXAResponseMessage response = (SessionXAResponseMessage)this.channel.sendBlocking(new SessionXAForgetMessage(xid), (byte)55);
            if (response.isError()) {
                throw new XAException(response.getResponseCode());
            }
        }
        catch (HornetQException e) {
            throw new XAException(-3);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        this.checkXA();
        try {
            SessionXAGetTimeoutResponseMessage response = (SessionXAGetTimeoutResponseMessage)this.channel.sendBlocking(new PacketImpl(65), (byte)66);
            return response.getTimeoutSeconds();
        }
        catch (HornetQException e) {
            throw new XAException(-3);
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        this.checkXA();
        if (!(xares instanceof ClientSessionInternal)) {
            return false;
        }
        if (this.forceNotSameRM) {
            return false;
        }
        ClientSessionInternal other = (ClientSessionInternal)xares;
        return this.sessionFactory == other.getSessionFactory();
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.checkXA();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Calling prepare:: " + this.convert(xid));
        }
        if (this.rollbackOnly) {
            throw new XAException(104);
        }
        SessionXAPrepareMessage packet = new SessionXAPrepareMessage(xid);
        this.startCall();
        try {
            SessionXAResponseMessage response = (SessionXAResponseMessage)this.channel.sendBlocking(packet, (byte)55);
            if (response.isError()) {
                throw new XAException(response.getResponseCode());
            }
            this.xaRetry = false;
            int n = response.getResponseCode();
            return n;
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.UNBLOCKED) {
                try {
                    HornetQClientLogger.LOGGER.failoverDuringPrepare();
                    SessionXAResponseMessage response = (SessionXAResponseMessage)this.channel.sendBlocking(packet, (byte)55);
                    if (response.isError()) {
                        throw new XAException(response.getResponseCode());
                    }
                    this.xaRetry = false;
                    int n = response.getResponseCode();
                    return n;
                }
                catch (HornetQException e1) {
                    HornetQClientLogger.LOGGER.failoverDuringPrepareRollingBack();
                    try {
                        this.rollback(false);
                    }
                    catch (HornetQException e2) {
                        throw new XAException(-3);
                    }
                    HornetQClientLogger.LOGGER.errorDuringPrepare(e);
                    throw new XAException(104);
                }
            }
            HornetQClientLogger.LOGGER.errorDuringPrepare(e);
            throw new XAException(-3);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        this.checkXA();
        if ((flags & 0x1000000) == 0x1000000) {
            try {
                SessionXAGetInDoubtXidsResponseMessage response = (SessionXAGetInDoubtXidsResponseMessage)this.channel.sendBlocking(new PacketImpl(61), (byte)62);
                List<Xid> xids = response.getXids();
                Xid[] xidArray = xids.toArray(new Xid[xids.size()]);
                return xidArray;
            }
            catch (HornetQException e) {
                throw new XAException(-3);
            }
        }
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.checkXA();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Calling rollback:: " + this.convert(xid));
        }
        try {
            boolean wasStarted = this.started;
            if (wasStarted) {
                this.stop(false);
            }
            for (ClientConsumerInternal consumer : this.cloneConsumers()) {
                consumer.clear(false);
            }
            this.flushAcks();
            SessionXARollbackMessage packet = new SessionXARollbackMessage(xid);
            SessionXAResponseMessage response = (SessionXAResponseMessage)this.channel.sendBlocking(packet, (byte)55);
            if (wasStarted) {
                this.start();
            }
            this.workDone = false;
            if (response.isError()) {
                throw new XAException(response.getResponseCode());
            }
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.UNBLOCKED) {
                this.xaRetry = true;
                throw new XAException(4);
            }
            throw new XAException(-3);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.checkXA();
        try {
            SessionXASetTimeoutResponseMessage response = (SessionXASetTimeoutResponseMessage)this.channel.sendBlocking(new SessionXASetTimeoutMessage(seconds), (byte)64);
            return response.isOK();
        }
        catch (HornetQException e) {
            throw new XAException(-3);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Calling start:: " + this.convert(xid) + " clientXID=" + xid + " flags = " + this.convertTXFlag(flags));
        }
        this.checkXA();
        PacketImpl packet = null;
        try {
            if (flags == 0x200000) {
                packet = new SessionXAJoinMessage(xid);
            } else if (flags == 0x8000000) {
                packet = new SessionXAResumeMessage(xid);
            } else if (flags == 0) {
                packet = new SessionXAStartMessage(xid);
            } else {
                throw new XAException(-5);
            }
            SessionXAResponseMessage response = (SessionXAResponseMessage)this.channel.sendBlocking(packet, (byte)55);
            this.currentXID = xid;
            if (response.isError()) {
                HornetQClientLogger.LOGGER.errorCallingStart(response.getMessage(), response.getResponseCode());
                throw new XAException(response.getResponseCode());
            }
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.UNBLOCKED) {
                try {
                    SessionXAResponseMessage response = (SessionXAResponseMessage)this.channel.sendBlocking(packet, (byte)55);
                    if (response.isError()) {
                        HornetQClientLogger.LOGGER.errorCallingStart(response.getMessage(), response.getResponseCode());
                        throw new XAException(response.getResponseCode());
                    }
                }
                catch (HornetQException e1) {
                    throw new XAException(-3);
                }
            }
            throw new XAException(-3);
        }
    }

    @Override
    public void connectionFailed(HornetQException me, boolean failedOver) {
        try {
            this.cleanUp(false);
        }
        catch (Exception e) {
            HornetQClientLogger.LOGGER.failedToCleanupSession(e);
        }
    }

    @Override
    public void setForceNotSameRM(boolean force) {
        this.forceNotSameRM = force;
    }

    @Override
    public RemotingConnection getConnection() {
        return this.remotingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Map<String, String> map = this.metadata;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                buffer.append(entry.getKey() + "=" + entry.getValue() + ",");
            }
        }
        return "ClientSessionImpl [name=" + this.name + ", username=" + this.username + ", closed=" + this.closed + ", factory = " + this.sessionFactory + ", metaData=(" + buffer + ")]@" + Integer.toHexString(this.hashCode());
    }

    private int calcWindowSize(int windowSize) {
        int clientWindowSize;
        if (windowSize == -1) {
            clientWindowSize = -1;
        } else if (windowSize == 0) {
            clientWindowSize = 0;
        } else if (windowSize == 1) {
            clientWindowSize = 1;
        } else if (windowSize > 1) {
            clientWindowSize = windowSize >> 1;
        } else {
            throw HornetQClientMessageBundle.BUNDLE.invalidWindowSize(windowSize);
        }
        return clientWindowSize;
    }

    private ClientConsumer internalCreateConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, boolean browseOnly) throws HornetQException {
        this.checkClosed();
        long consumerID = this.idGenerator.generateID();
        SessionCreateConsumerMessage request = new SessionCreateConsumerMessage(consumerID, queueName, filterString, browseOnly, true);
        SessionQueueQueryResponseMessage queueInfo = (SessionQueueQueryResponseMessage)this.channel.sendBlocking(request, (byte)46);
        int clientWindowSize = this.calcWindowSize(windowSize);
        ClientConsumerImpl consumer = new ClientConsumerImpl(this, consumerID, queueName, filterString, browseOnly, clientWindowSize, this.ackBatchSize, this.consumerMaxRate > 0 ? new TokenBucketLimiterImpl(maxRate, false) : null, this.executor, this.flowControlExecutor, this.channel, queueInfo, this.lookupTCCL());
        this.addConsumer(consumer);
        if (windowSize != 0) {
            this.channel.send(new SessionConsumerFlowCreditMessage(consumerID, windowSize));
        }
        return consumer;
    }

    private ClientProducer internalCreateProducer(SimpleString address, int maxRate) throws HornetQException {
        this.checkClosed();
        ClientProducerImpl producer = new ClientProducerImpl(this, address, maxRate == -1 ? null : new TokenBucketLimiterImpl(maxRate, false), this.autoCommitSends && this.blockOnNonDurableSend, this.autoCommitSends && this.blockOnDurableSend, this.autoGroup, this.groupID == null ? null : new SimpleString(this.groupID), this.minLargeMessageSize, this.channel);
        this.addProducer(producer);
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCreateQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temp) throws HornetQException {
        this.checkClosed();
        if (durable && temp) {
            throw HornetQClientMessageBundle.BUNDLE.queueMisConfigured();
        }
        CreateQueueMessage request = new CreateQueueMessage(address, queueName, filterString, durable, temp, true);
        this.startCall();
        try {
            this.channel.sendBlocking(request, (byte)21);
        }
        finally {
            this.endCall();
        }
    }

    private void checkXA() throws XAException {
        if (!this.xa) {
            HornetQClientLogger.LOGGER.sessionNotXA();
            throw new XAException(-3);
        }
    }

    private void checkClosed() throws HornetQException {
        if (this.closed || this.inClose) {
            throw HornetQClientMessageBundle.BUNDLE.sessionClosed();
        }
    }

    private ClassLoader lookupTCCL() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConsumerInternal getConsumer(long consumerID) {
        Map<Long, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            ClientConsumerInternal consumer = this.consumers.get(consumerID);
            return consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup(boolean failingOver) {
        if (this.remotingConnection != null) {
            this.remotingConnection.removeFailureListener(this);
        }
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug("calling cleanup on " + this);
        }
        ClientSessionImpl clientSessionImpl = this;
        synchronized (clientSessionImpl) {
            this.closed = true;
            this.channel.close();
            this.channel.returnBlocking();
        }
        this.sessionFactory.removeSession(this, failingOver);
    }

    private void cleanUpChildren() throws HornetQException {
        Set<ClientConsumerInternal> consumersClone = this.cloneConsumers();
        for (ClientConsumerInternal consumer : consumersClone) {
            consumer.cleanUp();
        }
        Set<ClientProducerInternal> producersClone = this.cloneProducers();
        for (ClientProducerInternal producer : producersClone) {
            producer.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClientProducerInternal> cloneProducers() {
        HashSet<ClientProducerInternal> producersClone;
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            producersClone = new HashSet<ClientProducerInternal>(this.producers);
        }
        return producersClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClientConsumerInternal> cloneConsumers() {
        Map<Long, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            return new HashSet<ClientConsumerInternal>(this.consumers.values());
        }
    }

    private void closeChildren() throws HornetQException {
        Set<ClientConsumerInternal> consumersClone = this.cloneConsumers();
        for (ClientConsumer clientConsumer : consumersClone) {
            clientConsumer.close();
        }
        Set<ClientProducerInternal> producersClone = this.cloneProducers();
        for (ClientProducer clientProducer : producersClone) {
            clientProducer.close();
        }
    }

    private void flushAcks() throws HornetQException {
        for (ClientConsumerInternal consumer : this.cloneConsumers()) {
            consumer.flushAcks();
        }
    }

    private Object convert(Xid xid) {
        HornetQBuffer buffer = HornetQBuffers.dynamicBuffer(200);
        XidCodecSupport.encodeXid(xid, buffer);
        Xid obj = XidCodecSupport.decodeXid(buffer);
        return "xid=" + obj + ",clientXID=" + xid;
    }

    private String convertTXFlag(int flags) {
        if (flags == 0x2000000) {
            return "SESS_XA_SUSPEND";
        }
        if (flags == 0x4000000) {
            return "TMSUCCESS";
        }
        if (flags == 0x20000000) {
            return "TMFAIL";
        }
        if (flags == 0x200000) {
            return "TMJOIN";
        }
        if (flags == 0x8000000) {
            return "TMRESUME";
        }
        if (flags == 0) {
            return "TMNOFLAGS";
        }
        return "XAER_INVAL(" + flags + ")";
    }

    @Override
    public void setStopSignal() {
        this.mayAttemptToFailover = false;
    }

    @Override
    public boolean isConfirmationWindowEnabled() {
        if (this.confirmationWindowWarning.disabled) {
            if (!this.confirmationWindowWarning.warningIssued.get()) {
                HornetQClientLogger.LOGGER.confirmationWindowDisabledWarning();
                this.confirmationWindowWarning.warningIssued.set(true);
            }
            return false;
        }
        return true;
    }

    @Override
    public void scheduleConfirmation(final SendAcknowledgementHandler handler, final Message message) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                handler.sendAcknowledged(message);
            }
        });
    }

    private static class QueueQueryImpl
    implements ClientSession.QueueQuery {
        private final boolean exists;
        private final boolean durable;
        private final long messageCount;
        private final SimpleString filterString;
        private final int consumerCount;
        private final SimpleString address;

        public QueueQueryImpl(boolean durable, int consumerCount, long messageCount, SimpleString filterString, SimpleString address, boolean exists) {
            this.durable = durable;
            this.consumerCount = consumerCount;
            this.messageCount = messageCount;
            this.filterString = filterString;
            this.address = address;
            this.exists = exists;
        }

        @Override
        public SimpleString getAddress() {
            return this.address;
        }

        @Override
        public int getConsumerCount() {
            return this.consumerCount;
        }

        @Override
        public SimpleString getFilterString() {
            return this.filterString;
        }

        @Override
        public long getMessageCount() {
            return this.messageCount;
        }

        @Override
        public boolean isDurable() {
            return this.durable;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }
    }

    private static class BindingQueryImpl
    implements ClientSession.BindingQuery {
        private final boolean exists;
        private final ArrayList<SimpleString> queueNames;

        public BindingQueryImpl(boolean exists, List<SimpleString> queueNames) {
            this.exists = exists;
            this.queueNames = new ArrayList<SimpleString>(queueNames);
        }

        @Override
        public List<SimpleString> getQueueNames() {
            return this.queueNames;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }
    }
}

