/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.JournalRecord;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.utils.Base64;

public class ImportJournal {
    public static void main(String[] arg) {
        if (arg.length != 5) {
            System.err.println("Use: java -cp hornetq-core.jar:netty.jar org.hornetq.core.journal.impl.ImportJournal <JournalDirectory> <JournalPrefix> <FileExtension> <FileSize> <FileOutput>");
            return;
        }
        try {
            ImportJournal.importJournal(arg[0], arg[1], arg[2], 2, Integer.parseInt(arg[3]), arg[4]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, String fileInput) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(new File(fileInput));
        ImportJournal.importJournal(directory, journalPrefix, journalSuffix, minFiles, fileSize, fileInputStream);
    }

    public static void importJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, InputStream stream) throws Exception {
        InputStreamReader reader = new InputStreamReader(stream);
        ImportJournal.importJournal(directory, journalPrefix, journalSuffix, minFiles, fileSize, reader);
    }

    public static void importJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, Reader reader) throws Exception {
        String line;
        NIOSequentialFileFactory nio;
        JournalImpl journal;
        File journalDir = new File(directory);
        if (!journalDir.exists() && !journalDir.mkdirs()) {
            System.err.println("Could not create directory " + directory);
        }
        if ((journal = new JournalImpl(fileSize, minFiles, 0, 0, nio = new NIOSequentialFileFactory(directory, null), journalPrefix, journalSuffix, 1)).orderFiles().size() != 0) {
            throw new IllegalStateException("Import needs to create a brand new journal");
        }
        journal.start();
        journal.loadInternalOnly();
        BufferedReader buffReader = new BufferedReader(reader);
        HashMap<Long, AtomicInteger> txCounters = new HashMap<Long, AtomicInteger>();
        long lineNumber = 0L;
        Map<Long, JournalRecord> journalRecords = journal.getRecords();
        while ((line = buffReader.readLine()) != null) {
            ++lineNumber;
            String[] splitLine = line.split(",");
            if (splitLine[0].equals("#File")) {
                txCounters.clear();
                continue;
            }
            Properties lineProperties = ImportJournal.parseLine(splitLine);
            String operation = null;
            try {
                AtomicInteger counter;
                RecordInfo info;
                operation = lineProperties.getProperty("operation");
                if (operation.equals("AddRecord")) {
                    RecordInfo info2 = ImportJournal.parseRecord(lineProperties);
                    journal.appendAddRecord(info2.id, info2.userRecordType, info2.data, false);
                    continue;
                }
                if (operation.equals("AddRecordTX")) {
                    long txID = ImportJournal.parseLong("txID", lineProperties);
                    AtomicInteger counter2 = ImportJournal.getCounter(txID, txCounters);
                    counter2.incrementAndGet();
                    info = ImportJournal.parseRecord(lineProperties);
                    journal.appendAddRecordTransactional(txID, info.id, info.userRecordType, info.data);
                    continue;
                }
                if (operation.equals("AddRecordTX")) {
                    long txID = ImportJournal.parseLong("txID", lineProperties);
                    AtomicInteger counter3 = ImportJournal.getCounter(txID, txCounters);
                    counter3.incrementAndGet();
                    info = ImportJournal.parseRecord(lineProperties);
                    journal.appendAddRecordTransactional(txID, info.id, info.userRecordType, info.data);
                    continue;
                }
                if (operation.equals("UpdateTX")) {
                    long txID = ImportJournal.parseLong("txID", lineProperties);
                    AtomicInteger counter4 = ImportJournal.getCounter(txID, txCounters);
                    counter4.incrementAndGet();
                    info = ImportJournal.parseRecord(lineProperties);
                    journal.appendUpdateRecordTransactional(txID, info.id, info.userRecordType, info.data);
                    continue;
                }
                if (operation.equals("Update")) {
                    RecordInfo info3 = ImportJournal.parseRecord(lineProperties);
                    journal.appendUpdateRecord(info3.id, info3.userRecordType, info3.data, false);
                    continue;
                }
                if (operation.equals("DeleteRecord")) {
                    long id = ImportJournal.parseLong("id", lineProperties);
                    if (journalRecords.get(id) == null) continue;
                    journal.appendDeleteRecord(id, false);
                    continue;
                }
                if (operation.equals("DeleteRecordTX")) {
                    long txID = ImportJournal.parseLong("txID", lineProperties);
                    long id = ImportJournal.parseLong("id", lineProperties);
                    AtomicInteger counter5 = ImportJournal.getCounter(txID, txCounters);
                    counter5.incrementAndGet();
                    if (journalRecords.get(id) == null) continue;
                    journal.appendDeleteRecordTransactional(txID, id);
                    continue;
                }
                if (operation.equals("Prepare")) {
                    long txID = ImportJournal.parseLong("txID", lineProperties);
                    int numberOfRecords = ImportJournal.parseInt("numberOfRecords", lineProperties);
                    counter = ImportJournal.getCounter(txID, txCounters);
                    byte[] data = ImportJournal.parseEncoding("extraData", lineProperties);
                    if (counter.get() == numberOfRecords) {
                        journal.appendPrepareRecord(txID, data, false);
                        continue;
                    }
                    System.err.println("Transaction " + txID + " at line " + lineNumber + " is incomplete. The prepare record expected " + numberOfRecords + " while the import only had " + counter);
                    continue;
                }
                if (operation.equals("Commit")) {
                    long txID = ImportJournal.parseLong("txID", lineProperties);
                    int numberOfRecords = ImportJournal.parseInt("numberOfRecords", lineProperties);
                    counter = ImportJournal.getCounter(txID, txCounters);
                    if (counter.get() == numberOfRecords) {
                        journal.appendCommitRecord(txID, false);
                        continue;
                    }
                    System.err.println("Transaction " + txID + " at line " + lineNumber + " is incomplete. The commit record expected " + numberOfRecords + " while the import only had " + counter);
                    continue;
                }
                if (operation.equals("Rollback")) {
                    long txID = ImportJournal.parseLong("txID", lineProperties);
                    journal.appendRollbackRecord(txID, false);
                    continue;
                }
                System.err.println("Invalid opeartion " + operation + " at line " + lineNumber);
            }
            catch (Exception ex) {
                System.err.println("Error at line " + lineNumber + ", operation=" + operation + " msg = " + ex.getMessage());
            }
        }
        journal.stop();
    }

    protected static AtomicInteger getCounter(Long txID, Map<Long, AtomicInteger> txCounters) {
        AtomicInteger counter = txCounters.get(txID);
        if (counter == null) {
            counter = new AtomicInteger(0);
            txCounters.put(txID, counter);
        }
        return counter;
    }

    protected static RecordInfo parseRecord(Properties properties) throws Exception {
        long id = ImportJournal.parseLong("id", properties);
        byte userRecordType = ImportJournal.parseByte("userRecordType", properties);
        boolean isUpdate = ImportJournal.parseBoolean("isUpdate", properties);
        byte[] data = ImportJournal.parseEncoding("data", properties);
        return new RecordInfo(id, userRecordType, data, isUpdate, 0);
    }

    private static byte[] parseEncoding(String name, Properties properties) throws Exception {
        String value = ImportJournal.parseString(name, properties);
        return ImportJournal.decode(value);
    }

    private static int parseInt(String name, Properties properties) throws Exception {
        String value = ImportJournal.parseString(name, properties);
        return Integer.parseInt(value);
    }

    private static long parseLong(String name, Properties properties) throws Exception {
        String value = ImportJournal.parseString(name, properties);
        return Long.parseLong(value);
    }

    private static boolean parseBoolean(String name, Properties properties) throws Exception {
        String value = ImportJournal.parseString(name, properties);
        return Boolean.parseBoolean(value);
    }

    private static byte parseByte(String name, Properties properties) throws Exception {
        String value = ImportJournal.parseString(name, properties);
        return Byte.parseByte(value);
    }

    private static String parseString(String name, Properties properties) throws Exception {
        String value = properties.getProperty(name);
        if (value == null) {
            throw new Exception("property " + name + " not found");
        }
        return value;
    }

    protected static Properties parseLine(String[] splitLine) {
        Properties properties = new Properties();
        for (String el : splitLine) {
            String[] tuple = el.split("@");
            if (tuple.length == 2) {
                properties.put(tuple[0], tuple[1]);
                continue;
            }
            properties.put(tuple[0], tuple[0]);
        }
        return properties;
    }

    private static byte[] decode(String data) {
        return Base64.decode(data, 24);
    }
}

