/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.protocol.stomp.WebSocketServerHandler;
import org.hornetq.core.remoting.impl.netty.ConnectionCreator;
import org.hornetq.core.remoting.impl.netty.HttpAcceptorHandler;
import org.hornetq.core.remoting.impl.netty.HttpKeepAliveRunnable;
import org.hornetq.core.remoting.impl.netty.NettyAcceptor;
import org.hornetq.core.remoting.impl.netty.NettyServerConnection;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.utils.ConfigurationHelper;

public class ProtocolHandler {
    private Map<String, ProtocolManager> protocolMap;
    private NettyAcceptor nettyAcceptor;
    private Map<String, Object> configuration;
    private ScheduledExecutorService scheduledThreadPool;
    private HttpKeepAliveRunnable httpKeepAliveRunnable;

    public ProtocolHandler(Map<String, ProtocolManager> protocolMap, NettyAcceptor nettyAcceptor, Map<String, Object> configuration, ScheduledExecutorService scheduledThreadPool) {
        this.protocolMap = protocolMap;
        this.nettyAcceptor = nettyAcceptor;
        this.configuration = configuration;
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public ChannelHandler getProtocolDecoder() {
        return new ProtocolDecoder(true, false);
    }

    public void close() {
        if (this.httpKeepAliveRunnable != null) {
            this.httpKeepAliveRunnable.close();
        }
    }

    class ProtocolDecoder
    extends ByteToMessageDecoder {
        private final boolean http;
        private final boolean httpEnabled;

        public ProtocolDecoder(boolean http, boolean httpEnabled) {
            this.http = http;
            this.httpEnabled = httpEnabled;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof DefaultFullHttpRequest) {
                DefaultFullHttpRequest request = (DefaultFullHttpRequest)msg;
                HttpHeaders headers = request.headers();
                String upgrade = headers.get("upgrade");
                if (upgrade != null && upgrade.equalsIgnoreCase("websocket")) {
                    ctx.pipeline().addLast("websocket-handler", (ChannelHandler)new WebSocketServerHandler());
                    ctx.pipeline().addLast(new ProtocolDecoder(false, false));
                    ctx.pipeline().remove(this);
                    ctx.pipeline().remove("http-handler");
                    ctx.fireChannelRead(msg);
                }
            } else {
                super.channelRead(ctx, msg);
            }
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (ctx.isRemoved()) {
                return;
            }
            if (in.readableBytes() < 8) {
                return;
            }
            short magic1 = in.getUnsignedByte(in.readerIndex());
            short magic2 = in.getUnsignedByte(in.readerIndex() + 1);
            if (this.http && this.isHttp(magic1, magic2)) {
                this.switchToHttp(ctx);
                return;
            }
            String protocolToUse = null;
            for (String protocol : ProtocolHandler.this.protocolMap.keySet()) {
                ProtocolManager protocolManager = (ProtocolManager)ProtocolHandler.this.protocolMap.get(protocol);
                if (!protocolManager.isProtocol(in.copy(0, 8).array())) continue;
                protocolToUse = protocol;
                break;
            }
            if (protocolToUse == null) {
                protocolToUse = "CORE";
            }
            ProtocolManager protocolManagerToUse = (ProtocolManager)ProtocolHandler.this.protocolMap.get(protocolToUse);
            ConnectionCreator channelHandler = ProtocolHandler.this.nettyAcceptor.createConnectionCreator();
            ChannelPipeline pipeline = ctx.pipeline();
            protocolManagerToUse.addChannelHandlers(pipeline);
            pipeline.addLast("handler", (ChannelHandler)channelHandler);
            NettyServerConnection connection = channelHandler.createConnection(ctx, protocolToUse, this.httpEnabled);
            protocolManagerToUse.handshake(connection, new ChannelBufferWrapper(in));
            pipeline.remove(this);
            ctx.flush();
        }

        private boolean isHttp(int magic1, int magic2) {
            return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82;
        }

        private void switchToHttp(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            p.addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
            p.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
            p.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
            if (ProtocolHandler.this.httpKeepAliveRunnable == null) {
                long httpServerScanPeriod = ConfigurationHelper.getLongProperty("http-server-scan-period", 5000L, ProtocolHandler.this.configuration);
                ProtocolHandler.this.httpKeepAliveRunnable = new HttpKeepAliveRunnable();
                ScheduledFuture<?> future = ProtocolHandler.this.scheduledThreadPool.scheduleAtFixedRate(ProtocolHandler.this.httpKeepAliveRunnable, httpServerScanPeriod, httpServerScanPeriod, TimeUnit.MILLISECONDS);
                ProtocolHandler.this.httpKeepAliveRunnable.setFuture(future);
            }
            long httpResponseTime = ConfigurationHelper.getLongProperty("http-response-time", 10000L, ProtocolHandler.this.configuration);
            HttpAcceptorHandler httpHandler = new HttpAcceptorHandler(ProtocolHandler.this.httpKeepAliveRunnable, httpResponseTime, ctx.channel());
            ctx.pipeline().addLast("http-handler", (ChannelHandler)httpHandler);
            p.addLast(new ProtocolDecoder(false, true));
            p.remove(this);
        }
    }
}

