/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQClusterSecurityException;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQDisconnectedException;
import org.hornetq.api.core.HornetQDuplicateMetaDataException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQIOErrorException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQIncompatibleClientServerException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.HornetQInvalidFilterExpressionException;
import org.hornetq.api.core.HornetQInvalidTransientQueueUseException;
import org.hornetq.api.core.HornetQNonExistentQueueException;
import org.hornetq.api.core.HornetQQueueExistsException;
import org.hornetq.api.core.HornetQSecurityException;
import org.hornetq.api.core.HornetQSessionCreationException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;

public class HornetQMessageBundle_$bundle
implements Serializable,
HornetQMessageBundle {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "HQ";
    public static final HornetQMessageBundle_$bundle INSTANCE = new HornetQMessageBundle_$bundle();
    private static final String replicationUnhandledFileType = "Unhandled file type {0}";
    private static final String serverDescribe = "Information about server {0}\nCluster Connection:{1}";
    private static final String destroyConnectionWithSessionMetadataNoSessionFound = "No session found with {0}={1}";
    private static final String cannotDeleteQueue = "Cannot delete queue {0} on binding {1} - it has consumers = {2}";
    private static final String addressIsNull = "Address is null";
    private static final String bindingAlreadyExists = "Binding already exists {0}";
    private static final String consumerDoesntExist = "Consumer {0} doesn't exist on the server";
    private static final String noSuchQueue = "Queue {0} does not exist";
    private static final String alreadyHaveReplicationServer = "Backup replication server is already connected to another server";
    private static final String journalsNotInSync = "Cannot compare journals if not in sync!";
    private static final String cannotFindResource = "Cannot find resource with name {0}";
    private static final String messageIdNotAssigned = "MessageId was not assigned to Message";
    private static final String routeNameIsNull = "Routing name is null";
    private static final String unableToValidateClusterUser = "Unable to authenticate cluster user: {0}";
    private static final String invalidPageIO = "Invalid Page IO, PagingManager was stopped or closed";
    private static final String destroyConnectionWithSessionMetadataSendException = "Disconnected per admin's request on {0}={1}";
    private static final String invalidJournalType = "Invalid journal type {0}";
    private static final String clientExited = "Did not receive data from {0}. It is likely the client has exited or crashed without closing its connection, or the network between the server and client has failed. You also might have configured connection-ttl and client-failure-check-period incorrectly. Please check user manual for more information. The connection will now be closed.";
    private static final String greaterThanMinusOne = "{0}  must be equals to -1 or greater than 0 (actual value: {1})";
    private static final String serverNotStarted = "Server not started";
    private static final String consumerNoReference = "Could not find reference on consumer ID={0}, messageId = {1} queue = {2}";
    private static final String bindingNotDivert = "Binding {0} is not a divert";
    private static final String couldNotMoveJournal = "error trying to backup journal files at directory: {0}";
    private static final String emptyOrNull = "{0} must neither be null nor empty";
    private static final String unableToValidateUser = "Unable to validate user: {0}";
    private static final String destroyConnectionWithSessionMetadataClosingConnection = "Closing connection {0}";
    private static final String autoConvertError = "method autoEncode doesn't know how to convert {0} yet";
    private static final String userNoPermissions = "User: {0} doesn't have permission='{1}' on address {2}";
    private static final String groupingQueueRemoved = "queue {0} has been removed cannot deliver message, queues should not be removed when grouping is used";
    private static final String replicationUnhandledDataType = "unhandled data type!";
    private static final String queueNameIsNull = "Queue name is null";
    private static final String duplicateMetadata = "Metadata {0}={1} had been set already";
    private static final String clusterNameIsNull = "Cluster name is null";
    private static final String invalidNewPriority = "invalid new Priority value: {0}. It must be between 0 and 9 (both included)";
    private static final String bindingTypeNotSpecified = "Binding type not specified";
    private static final String nodeIdNull = "node id is null";
    private static final String ioTimeout = "Timeout on waiting I/O completion";
    private static final String queueSubscriptionBelongsToDifferentAddress = "Queue {0} already exists on another subscription";
    private static final String endThreadDump = "End Thread dump";
    private static final String noDiscoveryGroupFound = "No Discovery Group configuration named {0} found";
    private static final String invalidFilter = "Invalid filter: {0}";
    private static final String noAddress = "No address configured on the Server's Session";
    private static final String threadDump = "Thread {0} name = {1} id = {2} group = {3}";
    private static final String acceptorExists = "Acceptor with id {0} already registered";
    private static final String replicationUnhandledError = "unhandled error during replication";
    private static final String noQueueFound = "No queue found for {0}";
    private static final String nullPassword = "Password cannot be null";
    private static final String noOperation = "no operation {0}/{1}";
    private static final String queueAlreadyExists = "Queue already exists {0}";
    private static final String bindingIdNotSpecified = "Binding ID is null";
    private static final String journalDirIsFile = "Trying to move a journal file that refers to a file instead of a directory: {0}";
    private static final String invalidMessageCounterPeriod = "Cannot set Message Counter Sample Period < {0}ms";
    private static final String invalidJournal = "Only NIO and AsyncIO are supported journals";
    private static final String largeMessageNotInitialised = "large-message not initialized on server";
    private static final String replicationTooManyJournals = "Live Node contains more journals than the backup node. Probably a version match error";
    private static final String backupServerNotInSync = "Backup Server was not yet in sync with live";
    private static final String acceptorNotExists = "Acceptor with id {0} not registered";
    private static final String invalidIndex = "Invalid index {0}";
    private static final String incompatibleClientServer = "Server and client versions incompatible";
    private static final String invalidType = "Invalid type: {0}";
    private static final String notPercent = "{0} must be a valid percentual value between 0 and 100 (actual value: {1})";
    private static final String errorCreatingTransformerClass = "Error instantiating transformer class {0}";
    private static final String nullMatch = "match can not be null";
    private static final String greaterThanZero2 = "{0}  must be greater than 0 (actual value: {1})";
    private static final String connectionsClosedByManagement = "connections for {0} closed by management";
    private static final String nullUser = "User cannot be null";
    private static final String replicationBackupUpToDate = "Remote Backup can not be up-to-date!";
    private static final String unknownProtocol = "Unknown protocol {0}";
    private static final String serverNotBackupServer = "Connected server is not a backup server";
    private static final String destroyConnectionWithSessionMetadataHeader = "Executing destroyConnection with {0}={1} through management's request";
    private static final String connectionExists = "Connection already exists with id {0}";
    private static final String noProtocolManagerFound = "Classpath lacks a protocol-manager for protocol {0}";
    private static final String noGetterMethod = "no getter method for {0}";
    private static final String mustbeBetween = "{0} must be between {1} and {2} inclusive (actual value: {3})";
    private static final String invalidAddressFullPolicyType = "Invalid address full message policy type {0}";
    private static final String greaterThanZero1 = "invalid value: {0} count must be greater than 0";
    private static final String distancenotSpecified = "Distance is null";
    private static final String cannotConvertToInt = "Cannot convert to int";
    private static final String invalidRetryInterval = "retry interval must be positive, was {0}";
    private static final String greaterThanZeroOrMinusOne = "{0}  must be equals to -1 or greater or equals to 0 (actual value: {1})";
    private static final String invalidJournalType2 = "Invalid journal type {0}";
    private static final String generatingThreadDump = "Generating thread dump because - {0}";
    private static final String notJournalImpl = "journals are not JournalImpl. You can't set a replicator!";
    private static final String invalidMatch = "# can only be at end of match";
    private static final String queueSubscriptionBelongsToDifferentFilter = "Queue {0} has a different filter than requested";
    private static final String cannotCreateDir = "Directory {0} does not exist and cannot be created";
    private static final String activationForServer = "Activation for server {0}";
    private static final String noBindingForDivert = "No binding for divert {0}";

    protected HornetQMessageBundle_$bundle() {
    }

    protected HornetQMessageBundle_$bundle readResolve() {
        return INSTANCE;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType fileType) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119009: " + this.replicationUnhandledFileType$str(), new Object[]{fileType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledFileType$str() {
        return replicationUnhandledFileType;
    }

    @Override
    public final String serverDescribe(String identity, String describe) {
        String result = MessageFormat.format("HQ119004: " + this.serverDescribe$str(), identity, describe);
        return result;
    }

    protected String serverDescribe$str() {
        return serverDescribe;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataNoSessionFound(String key, String value) {
        String result = MessageFormat.format("HQ119079: " + this.destroyConnectionWithSessionMetadataNoSessionFound$str(), key, value);
        return result;
    }

    protected String destroyConnectionWithSessionMetadataNoSessionFound$str() {
        return destroyConnectionWithSessionMetadataNoSessionFound;
    }

    @Override
    public final HornetQIllegalStateException cannotDeleteQueue(SimpleString name, SimpleString queueName, String s) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format("HQ119025: " + this.cannotDeleteQueue$str(), name, queueName, s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeleteQueue$str() {
        return cannotDeleteQueue;
    }

    @Override
    public final IllegalArgumentException addressIsNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119057: " + this.addressIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressIsNull$str() {
        return addressIsNull;
    }

    @Override
    public final HornetQQueueExistsException bindingAlreadyExists(Binding binding) {
        HornetQQueueExistsException result = new HornetQQueueExistsException(MessageFormat.format("HQ119018: " + this.bindingAlreadyExists$str(), binding));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingAlreadyExists$str() {
        return bindingAlreadyExists;
    }

    @Override
    public final HornetQIllegalStateException consumerDoesntExist(long consumerID) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format("HQ119028: " + this.consumerDoesntExist$str(), consumerID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerDoesntExist$str() {
        return consumerDoesntExist;
    }

    @Override
    public final HornetQNonExistentQueueException noSuchQueue(SimpleString queueName) {
        HornetQNonExistentQueueException result = new HornetQNonExistentQueueException(MessageFormat.format("HQ119017: " + this.noSuchQueue$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchQueue$str() {
        return noSuchQueue;
    }

    @Override
    public final HornetQIllegalStateException alreadyHaveReplicationServer() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119024: " + this.alreadyHaveReplicationServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyHaveReplicationServer$str() {
        return alreadyHaveReplicationServer;
    }

    @Override
    public final HornetQIllegalStateException journalsNotInSync() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119022: " + this.journalsNotInSync$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String journalsNotInSync$str() {
        return journalsNotInSync;
    }

    @Override
    public final IllegalArgumentException cannotFindResource(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119067: " + this.cannotFindResource$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindResource$str() {
        return cannotFindResource;
    }

    @Override
    public final HornetQIllegalStateException messageIdNotAssigned() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119021: " + this.messageIdNotAssigned$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageIdNotAssigned$str() {
        return messageIdNotAssigned;
    }

    @Override
    public final IllegalArgumentException routeNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119055: " + this.routeNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String routeNameIsNull$str() {
        return routeNameIsNull;
    }

    @Override
    public final HornetQClusterSecurityException unableToValidateClusterUser(String user) {
        HornetQClusterSecurityException result = new HornetQClusterSecurityException(MessageFormat.format("HQ119099: " + this.unableToValidateClusterUser$str(), user));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToValidateClusterUser$str() {
        return unableToValidateClusterUser;
    }

    @Override
    public final HornetQIllegalStateException invalidPageIO() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119080: " + this.invalidPageIO$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPageIO$str() {
        return invalidPageIO;
    }

    @Override
    public final HornetQDisconnectedException destroyConnectionWithSessionMetadataSendException(String key, String value) {
        HornetQDisconnectedException result = new HornetQDisconnectedException(MessageFormat.format("HQ119078: " + this.destroyConnectionWithSessionMetadataSendException$str(), key, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destroyConnectionWithSessionMetadataSendException$str() {
        return destroyConnectionWithSessionMetadataSendException;
    }

    @Override
    public final IllegalArgumentException invalidJournalType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119044: " + this.invalidJournalType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType$str() {
        return "Invalid journal type {0}";
    }

    @Override
    public final HornetQConnectionTimedOutException clientExited(String remoteAddress) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format("HQ119014: " + this.clientExited$str(), remoteAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientExited$str() {
        return clientExited;
    }

    @Override
    public final IllegalArgumentException greaterThanMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119041: " + this.greaterThanMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanMinusOne$str() {
        return greaterThanMinusOne;
    }

    @Override
    public final HornetQSessionCreationException serverNotStarted() {
        HornetQSessionCreationException result = new HornetQSessionCreationException("HQ119034: " + this.serverNotStarted$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotStarted$str() {
        return serverNotStarted;
    }

    @Override
    public final HornetQIllegalStateException consumerNoReference(Long id, Long messageID, SimpleString name) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format("HQ119027: " + this.consumerNoReference$str(), id, messageID, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerNoReference$str() {
        return consumerNoReference;
    }

    @Override
    public final HornetQInternalErrorException bindingNotDivert(SimpleString name) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119013: " + this.bindingNotDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingNotDivert$str() {
        return bindingNotDivert;
    }

    @Override
    public final IllegalStateException couldNotMoveJournal(File dir) {
        IllegalStateException result = new IllegalStateException(MessageFormat.format("HQ119101: " + this.couldNotMoveJournal$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotMoveJournal$str() {
        return couldNotMoveJournal;
    }

    @Override
    public final IllegalArgumentException emptyOrNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119038: " + this.emptyOrNull$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyOrNull$str() {
        return emptyOrNull;
    }

    @Override
    public final HornetQSecurityException unableToValidateUser(String user) {
        HornetQSecurityException result = new HornetQSecurityException(MessageFormat.format("HQ119031: " + this.unableToValidateUser$str(), user));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToValidateUser$str() {
        return unableToValidateUser;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataClosingConnection(String serverSessionString) {
        String result = MessageFormat.format("HQ119077: " + this.destroyConnectionWithSessionMetadataClosingConnection$str(), serverSessionString);
        return result;
    }

    protected String destroyConnectionWithSessionMetadataClosingConnection$str() {
        return destroyConnectionWithSessionMetadataClosingConnection;
    }

    public final IllegalArgumentException autoConvertError(Class aClass) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119075: " + this.autoConvertError$str(), aClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String autoConvertError$str() {
        return autoConvertError;
    }

    @Override
    public final HornetQSecurityException userNoPermissions(String username, CheckType checkType, String saddress) {
        HornetQSecurityException result = new HornetQSecurityException(MessageFormat.format("HQ119032: " + this.userNoPermissions$str(), new Object[]{username, checkType, saddress}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userNoPermissions$str() {
        return userNoPermissions;
    }

    @Override
    public final HornetQNonExistentQueueException groupingQueueRemoved(SimpleString chosenClusterName) {
        HornetQNonExistentQueueException result = new HornetQNonExistentQueueException(MessageFormat.format("HQ119016: " + this.groupingQueueRemoved$str(), chosenClusterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String groupingQueueRemoved$str() {
        return groupingQueueRemoved;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledDataType() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119011: " + this.replicationUnhandledDataType$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledDataType$str() {
        return replicationUnhandledDataType;
    }

    @Override
    public final IllegalArgumentException queueNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119066: " + this.queueNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueNameIsNull$str() {
        return queueNameIsNull;
    }

    @Override
    public final HornetQDuplicateMetaDataException duplicateMetadata(String key, String data) {
        HornetQDuplicateMetaDataException result = new HornetQDuplicateMetaDataException(MessageFormat.format("HQ119035: " + this.duplicateMetadata$str(), key, data));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateMetadata$str() {
        return duplicateMetadata;
    }

    @Override
    public final IllegalArgumentException clusterNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119056: " + this.clusterNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clusterNameIsNull$str() {
        return clusterNameIsNull;
    }

    @Override
    public final IllegalArgumentException invalidNewPriority(Integer period) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119048: " + this.invalidNewPriority$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNewPriority$str() {
        return invalidNewPriority;
    }

    @Override
    public final IllegalArgumentException bindingTypeNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119058: " + this.bindingTypeNotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingTypeNotSpecified$str() {
        return bindingTypeNotSpecified;
    }

    @Override
    public final IllegalArgumentException nodeIdNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119065: " + this.nodeIdNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeIdNull$str() {
        return nodeIdNull;
    }

    @Override
    public final HornetQIOErrorException ioTimeout() {
        HornetQIOErrorException result = new HornetQIOErrorException("HQ119015: " + this.ioTimeout$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioTimeout$str() {
        return ioTimeout;
    }

    @Override
    public final HornetQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentAddress(SimpleString queueName) {
        HornetQInvalidTransientQueueUseException result = new HornetQInvalidTransientQueueUseException(MessageFormat.format("HQ119082: " + this.queueSubscriptionBelongsToDifferentAddress$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueSubscriptionBelongsToDifferentAddress$str() {
        return queueSubscriptionBelongsToDifferentAddress;
    }

    @Override
    public final String endThreadDump() {
        String result = "HQ119003: " + this.endThreadDump$str();
        return result;
    }

    protected String endThreadDump$str() {
        return endThreadDump;
    }

    @Override
    public final HornetQException noDiscoveryGroupFound(DiscoveryGroupConfiguration dg) {
        HornetQException result = new HornetQException(MessageFormat.format("HQ119081: " + this.noDiscoveryGroupFound$str(), dg));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDiscoveryGroupFound$str() {
        return noDiscoveryGroupFound;
    }

    @Override
    public final HornetQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        HornetQInvalidFilterExpressionException result = new HornetQInvalidFilterExpressionException(MessageFormat.format("HQ119020: " + this.invalidFilter$str(), filter));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final HornetQIllegalStateException noAddress() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119029: " + this.noAddress$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAddress$str() {
        return noAddress;
    }

    @Override
    public final String threadDump(Thread key, String name, Long id, ThreadGroup threadGroup) {
        String result = MessageFormat.format("HQ119002: " + this.threadDump$str(), key, name, id, threadGroup);
        return result;
    }

    protected String threadDump$str() {
        return threadDump;
    }

    @Override
    public final IllegalArgumentException acceptorExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119062: " + this.acceptorExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorExists$str() {
        return acceptorExists;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledError(Exception e) {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119007: " + this.replicationUnhandledError$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledError$str() {
        return replicationUnhandledError;
    }

    @Override
    public final IllegalArgumentException noQueueFound(String otherQueueName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119049: " + this.noQueueFound$str(), otherQueueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noQueueFound$str() {
        return noQueueFound;
    }

    @Override
    public final IllegalArgumentException nullPassword() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119073: " + this.nullPassword$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullPassword$str() {
        return nullPassword;
    }

    @Override
    public final IllegalArgumentException noOperation(String operation, Integer length) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119069: " + this.noOperation$str(), operation, length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noOperation$str() {
        return noOperation;
    }

    @Override
    public final HornetQQueueExistsException queueAlreadyExists(SimpleString queueName) {
        HornetQQueueExistsException result = new HornetQQueueExistsException(MessageFormat.format("HQ119019: " + this.queueAlreadyExists$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueAlreadyExists$str() {
        return queueAlreadyExists;
    }

    @Override
    public final IllegalArgumentException bindingIdNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119059: " + this.bindingIdNotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingIdNotSpecified$str() {
        return bindingIdNotSpecified;
    }

    @Override
    public final IllegalStateException journalDirIsFile(File fDir) {
        IllegalStateException result = new IllegalStateException(MessageFormat.format("HQ119100: " + this.journalDirIsFile$str(), fDir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String journalDirIsFile$str() {
        return journalDirIsFile;
    }

    @Override
    public final IllegalArgumentException invalidMessageCounterPeriod(Long period) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119047: " + this.invalidMessageCounterPeriod$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMessageCounterPeriod$str() {
        return invalidMessageCounterPeriod;
    }

    @Override
    public final IllegalArgumentException invalidJournal() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119050: " + this.invalidJournal$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournal$str() {
        return invalidJournal;
    }

    @Override
    public final HornetQIllegalStateException largeMessageNotInitialised() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119030: " + this.largeMessageNotInitialised$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageNotInitialised$str() {
        return largeMessageNotInitialised;
    }

    @Override
    public final HornetQInternalErrorException replicationTooManyJournals() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119008: " + this.replicationTooManyJournals$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationTooManyJournals$str() {
        return replicationTooManyJournals;
    }

    @Override
    public final HornetQIllegalStateException backupServerNotInSync() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119026: " + this.backupServerNotInSync$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backupServerNotInSync$str() {
        return backupServerNotInSync;
    }

    @Override
    public final IllegalArgumentException acceptorNotExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119063: " + this.acceptorNotExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorNotExists$str() {
        return acceptorNotExists;
    }

    @Override
    public final IllegalArgumentException invalidIndex(Integer index) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119053: " + this.invalidIndex$str(), index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIndex$str() {
        return invalidIndex;
    }

    @Override
    public final HornetQIncompatibleClientServerException incompatibleClientServer() {
        HornetQIncompatibleClientServerException result = new HornetQIncompatibleClientServerException("HQ119033: " + this.incompatibleClientServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleClientServer$str() {
        return incompatibleClientServer;
    }

    @Override
    public final IllegalArgumentException invalidType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119036: " + this.invalidType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidType$str() {
        return invalidType;
    }

    @Override
    public final IllegalArgumentException notPercent(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119040: " + this.notPercent$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notPercent$str() {
        return notPercent;
    }

    @Override
    public final IllegalArgumentException errorCreatingTransformerClass(Exception e, String transformerClassName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119074: " + this.errorCreatingTransformerClass$str(), transformerClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatingTransformerClass$str() {
        return errorCreatingTransformerClass;
    }

    @Override
    public final IllegalArgumentException nullMatch() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119070: " + this.nullMatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullMatch$str() {
        return nullMatch;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119039: " + this.greaterThanZero2$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero2$str() {
        return greaterThanZero2;
    }

    @Override
    public final HornetQInternalErrorException connectionsClosedByManagement(String ipAddress) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119005: " + this.connectionsClosedByManagement$str(), ipAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionsClosedByManagement$str() {
        return connectionsClosedByManagement;
    }

    @Override
    public final IllegalArgumentException nullUser() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119072: " + this.nullUser$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullUser$str() {
        return nullUser;
    }

    @Override
    public final HornetQInternalErrorException replicationBackupUpToDate() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119010: " + this.replicationBackupUpToDate$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationBackupUpToDate$str() {
        return replicationBackupUpToDate;
    }

    @Override
    public final IllegalArgumentException unknownProtocol(String protocol) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119064: " + this.unknownProtocol$str(), protocol));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownProtocol$str() {
        return unknownProtocol;
    }

    @Override
    public final HornetQIllegalStateException serverNotBackupServer() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119023: " + this.serverNotBackupServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotBackupServer$str() {
        return serverNotBackupServer;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataHeader(String key, String value) {
        String result = MessageFormat.format("HQ119076: " + this.destroyConnectionWithSessionMetadataHeader$str(), key, value);
        return result;
    }

    protected String destroyConnectionWithSessionMetadataHeader$str() {
        return destroyConnectionWithSessionMetadataHeader;
    }

    @Override
    public final IllegalArgumentException connectionExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119061: " + this.connectionExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionExists$str() {
        return connectionExists;
    }

    @Override
    public final HornetQException noProtocolManagerFound(String protocol) {
        HornetQException result = new HornetQException(MessageFormat.format("HQ119085: " + this.noProtocolManagerFound$str(), protocol));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noProtocolManagerFound$str() {
        return noProtocolManagerFound;
    }

    @Override
    public final IllegalArgumentException noGetterMethod(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119068: " + this.noGetterMethod$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noGetterMethod$str() {
        return noGetterMethod;
    }

    @Override
    public final IllegalArgumentException mustbeBetween(String name, Integer minPriority, Integer maxPriority, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119043: " + this.mustbeBetween$str(), name, minPriority, maxPriority, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustbeBetween$str() {
        return mustbeBetween;
    }

    @Override
    public final IllegalArgumentException invalidAddressFullPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119045: " + this.invalidAddressFullPolicyType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAddressFullPolicyType$str() {
        return invalidAddressFullPolicyType;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(Integer count) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119046: " + this.greaterThanZero1$str(), count));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero1$str() {
        return greaterThanZero1;
    }

    @Override
    public final IllegalArgumentException distancenotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119060: " + this.distancenotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distancenotSpecified$str() {
        return distancenotSpecified;
    }

    @Override
    public final IllegalArgumentException cannotConvertToInt() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119054: " + this.cannotConvertToInt$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertToInt$str() {
        return cannotConvertToInt;
    }

    @Override
    public final IllegalArgumentException invalidRetryInterval(Long size) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119037: " + this.invalidRetryInterval$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRetryInterval$str() {
        return invalidRetryInterval;
    }

    @Override
    public final IllegalArgumentException greaterThanZeroOrMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119042: " + this.greaterThanZeroOrMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZeroOrMinusOne$str() {
        return greaterThanZeroOrMinusOne;
    }

    @Override
    public final IllegalArgumentException invalidJournalType2(JournalType journalType) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119051: " + this.invalidJournalType2$str(), new Object[]{journalType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType2$str() {
        return "Invalid journal type {0}";
    }

    @Override
    public final String generatingThreadDump(String reason) {
        String result = MessageFormat.format("HQ119001: " + this.generatingThreadDump$str(), reason);
        return result;
    }

    protected String generatingThreadDump$str() {
        return generatingThreadDump;
    }

    @Override
    public final HornetQInternalErrorException notJournalImpl() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119006: " + this.notJournalImpl$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notJournalImpl$str() {
        return notJournalImpl;
    }

    @Override
    public final IllegalArgumentException invalidMatch() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119071: " + this.invalidMatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMatch$str() {
        return invalidMatch;
    }

    @Override
    public final HornetQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentFilter(SimpleString queueName) {
        HornetQInvalidTransientQueueUseException result = new HornetQInvalidTransientQueueUseException(MessageFormat.format("HQ119083: " + this.queueSubscriptionBelongsToDifferentFilter$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueSubscriptionBelongsToDifferentFilter$str() {
        return queueSubscriptionBelongsToDifferentFilter;
    }

    @Override
    public final IllegalArgumentException cannotCreateDir(String dir) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119052: " + this.cannotCreateDir$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateDir$str() {
        return cannotCreateDir;
    }

    @Override
    public final String activationForServer(HornetQServer server) {
        String result = MessageFormat.format("HQ119000: " + this.activationForServer$str(), server);
        return result;
    }

    protected String activationForServer$str() {
        return activationForServer;
    }

    @Override
    public final HornetQInternalErrorException noBindingForDivert(SimpleString name) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119012: " + this.noBindingForDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noBindingForDivert$str() {
        return noBindingForDivert;
    }
}

