/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.config.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.utils.BufferHelper;

public class TransportConfigurationEncodingSupport {
    public static List<Pair<TransportConfiguration, TransportConfiguration>> decodeConfigs(HornetQBuffer buffer) {
        int size = buffer.readInt();
        ArrayList<Pair<TransportConfiguration, TransportConfiguration>> configs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>(size);
        for (int i = 0; i < size; ++i) {
            TransportConfiguration live = TransportConfigurationEncodingSupport.decode(buffer);
            boolean hasBackup = buffer.readBoolean();
            TransportConfiguration backup = null;
            if (hasBackup) {
                backup = TransportConfigurationEncodingSupport.decode(buffer);
            }
            configs.add(new Pair<TransportConfiguration, TransportConfiguration>(live, backup));
        }
        return configs;
    }

    public static TransportConfiguration decode(HornetQBuffer buffer) {
        String name = BufferHelper.readNullableSimpleStringAsString(buffer);
        String factoryClassName = buffer.readSimpleString().toString();
        int paramSize = buffer.readInt();
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < paramSize; ++i) {
            String key = buffer.readSimpleString().toString();
            String value = buffer.readSimpleString().toString();
            params.put(key, value);
        }
        TransportConfiguration config = new TransportConfiguration(factoryClassName, params, name);
        return config;
    }

    public static void encodeConfigs(HornetQBuffer buffer, List<Pair<TransportConfiguration, TransportConfiguration>> configs) {
        buffer.writeInt(configs == null ? 0 : configs.size());
        if (configs != null) {
            for (Pair<TransportConfiguration, TransportConfiguration> pair : configs) {
                TransportConfigurationEncodingSupport.encode(buffer, pair.getA());
                boolean backup = pair.getB() != null;
                buffer.writeBoolean(backup);
                if (!backup) continue;
                TransportConfigurationEncodingSupport.encode(buffer, pair.getB());
            }
        }
    }

    public static void encode(HornetQBuffer buffer, TransportConfiguration config) {
        BufferHelper.writeAsNullableSimpleString(buffer, config.getName());
        BufferHelper.writeAsSimpleString(buffer, config.getFactoryClassName());
        buffer.writeInt(config.getParams().size());
        for (Map.Entry<String, Object> param : config.getParams().entrySet()) {
            BufferHelper.writeAsSimpleString(buffer, param.getKey());
            BufferHelper.writeAsSimpleString(buffer, param.getValue().toString());
        }
    }

    public static int getEncodeSize(TransportConfiguration config) {
        int size = BufferHelper.sizeOfNullableSimpleString(config.getName()) + BufferHelper.sizeOfSimpleString(config.getFactoryClassName());
        size += 4;
        for (Map.Entry<String, Object> param : config.getParams().entrySet()) {
            size += BufferHelper.sizeOfSimpleString(param.getKey());
            size += BufferHelper.sizeOfSimpleString(param.getValue().toString());
        }
        return size;
    }

    public static int getEncodeSize(List<Pair<TransportConfiguration, TransportConfiguration>> configs) {
        int size = 4;
        if (configs != null) {
            for (Pair<TransportConfiguration, TransportConfiguration> pair : configs) {
                size += TransportConfigurationEncodingSupport.getEncodeSize(pair.getA());
                ++size;
                if (pair.getB() == null) continue;
                size += TransportConfigurationEncodingSupport.getEncodeSize(pair.getB());
            }
        }
        return size;
    }
}

