/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientRequestor;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.utils.Base64;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public final class XmlDataImporter {
    private final XMLStreamReader reader;
    final ClientSession managementSession;
    final boolean localSession;
    final Map<String, String> addressMap = new HashMap<String, String>();
    final Map<String, Long> queueIDs = new HashMap<String, Long>();
    String tempFileName = "";
    private final ClientSession session;
    private boolean applicationServerCompatibility = false;

    public XmlDataImporter(InputStream inputStream, ClientSession session) throws Exception {
        this(inputStream, session, null, false);
    }

    public XmlDataImporter(InputStream inputStream, ClientSession session, boolean applicationServerCompatibility) throws Exception {
        this(inputStream, session, null, applicationServerCompatibility);
    }

    public XmlDataImporter(InputStream inputStream, ClientSession session, ClientSession managementSession, boolean applicationServerCompatibility) throws Exception {
        this.reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        this.session = session;
        this.managementSession = managementSession != null ? managementSession : session;
        this.localSession = false;
        this.applicationServerCompatibility = applicationServerCompatibility;
    }

    public XmlDataImporter(InputStream inputStream, ClientSession session, ClientSession managementSession) throws Exception {
        this(inputStream, session, managementSession, false);
    }

    public XmlDataImporter(InputStream inputStream, String host, String port, boolean transactional, boolean applicationServerCompatibility) throws Exception {
        this.reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        connectionParams.put("host", host);
        connectionParams.put("port", port);
        ServerLocator serverLocator = HornetQClient.createServerLocatorWithoutHA(new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams));
        ClientSessionFactory sf = serverLocator.createSessionFactory();
        this.session = sf.createSession(false, !transactional, true);
        this.managementSession = sf.createSession(false, true, true);
        this.localSession = true;
        this.applicationServerCompatibility = applicationServerCompatibility;
    }

    public XmlDataImporter(String inputFile, String host, String port, boolean transactional, boolean applicationServerCompatibility) throws Exception {
        this(new FileInputStream(inputFile), host, port, transactional, applicationServerCompatibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXml() throws Exception {
        try {
            while (this.reader.hasNext()) {
                HornetQServerLogger.LOGGER.debug("EVENT:[" + this.reader.getLocation().getLineNumber() + "][" + this.reader.getLocation().getColumnNumber() + "] ");
                if (this.reader.getEventType() == 1) {
                    if ("binding".equals(this.reader.getLocalName())) {
                        this.bindQueue();
                    } else if ("message".equals(this.reader.getLocalName())) {
                        this.processMessage();
                    } else if ("jms-connection-factories".equals(this.reader.getLocalName())) {
                        this.createJmsConnectionFactories();
                    } else if ("jms-destinations".equals(this.reader.getLocalName())) {
                        this.createJmsDestinations();
                    }
                }
                this.reader.next();
            }
            if (!this.session.isAutoCommitSends()) {
                this.session.commit();
            }
        }
        finally {
            if (this.localSession) {
                this.session.close();
                this.managementSession.close();
            }
        }
    }

    private void processMessage() throws Exception {
        Byte type = 0;
        Byte priority = 0;
        Long expiration = 0L;
        Long timestamp = 0L;
        UUID userId = null;
        ArrayList<String> queues = new ArrayList<String>();
        block18: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "type": {
                    type = this.getMessageType(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "priority": {
                    priority = Byte.parseByte(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "expiration": {
                    expiration = Long.parseLong(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "timestamp": {
                    timestamp = Long.parseLong(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "user-id": {
                    userId = UUIDGenerator.getInstance().generateUUID();
                }
            }
        }
        ClientMessage message = this.session.createMessage(type, true, expiration, timestamp, priority);
        message.setUserID(userId);
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("body".equals(this.reader.getLocalName())) {
                        this.processMessageBody(message);
                        break;
                    }
                    if ("property".equals(this.reader.getLocalName())) {
                        this.processMessageProperties(message);
                        break;
                    }
                    if (!"queue".equals(this.reader.getLocalName())) break;
                    this.processMessageQueues(queues);
                    break;
                }
                case 2: {
                    if (!"message".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        this.sendMessage(queues, message);
    }

    private Byte getMessageType(String value) {
        Byte type = 0;
        switch (value) {
            case "default": {
                type = 0;
                break;
            }
            case "bytes": {
                type = 4;
                break;
            }
            case "map": {
                type = 5;
                break;
            }
            case "object": {
                type = 2;
                break;
            }
            case "stream": {
                type = 6;
                break;
            }
            case "text": {
                type = 3;
            }
        }
        return type;
    }

    private void sendMessage(ArrayList<String> queues, Message message) throws Exception {
        File tempFile;
        StringBuilder logMessage = new StringBuilder();
        String destination = this.addressMap.get(queues.get(0));
        logMessage.append("Sending ").append(message).append(" to address: ").append(destination).append("; routed to queues: ");
        ByteBuffer buffer = ByteBuffer.allocate(queues.size() * 8);
        for (String queue : queues) {
            long queueID;
            if (this.queueIDs.containsKey(queue)) {
                queueID = this.queueIDs.get(queue);
            } else {
                ClientRequestor requestor = new ClientRequestor(this.managementSession, "jms.queue.hornetq.management");
                ClientMessage managementMessage = this.managementSession.createMessage(false);
                ManagementHelper.putAttribute(managementMessage, "core.queue." + queue, "ID");
                this.managementSession.start();
                HornetQServerLogger.LOGGER.debug("Requesting ID for: " + queue);
                ClientMessage reply = requestor.request(managementMessage);
                queueID = ((Integer)ManagementHelper.getResult(reply)).intValue();
                requestor.close();
                HornetQServerLogger.LOGGER.debug("ID for " + queue + " is: " + queueID);
                this.queueIDs.put(queue, queueID);
            }
            logMessage.append(queue).append(", ");
            buffer.putLong(queueID);
        }
        logMessage.delete(logMessage.length() - 2, logMessage.length());
        HornetQServerLogger.LOGGER.debug(logMessage);
        message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, buffer.array());
        ClientProducer producer = this.session.createProducer(destination);
        producer.send(message);
        producer.close();
        if (this.tempFileName.length() > 0 && !(tempFile = new File(this.tempFileName)).delete()) {
            HornetQServerLogger.LOGGER.warn("Could not delete: " + this.tempFileName);
        }
    }

    private void processMessageQueues(ArrayList<String> queues) {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"name".equals(this.reader.getAttributeLocalName(i))) continue;
            queues.add(this.reader.getAttributeValue(i));
        }
    }

    private void processMessageProperties(Message message) {
        String key = "";
        String value = "";
        String propertyType = "";
        block34: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "name": {
                    key = this.reader.getAttributeValue(i);
                    continue block34;
                }
                case "value": {
                    value = this.reader.getAttributeValue(i);
                    continue block34;
                }
                case "type": {
                    propertyType = this.reader.getAttributeValue(i);
                }
            }
        }
        switch (propertyType) {
            case "short": {
                message.putShortProperty(key, Short.parseShort(value));
                break;
            }
            case "boolean": {
                message.putBooleanProperty(key, Boolean.parseBoolean(value));
                break;
            }
            case "byte": {
                message.putByteProperty(key, Byte.parseByte(value));
                break;
            }
            case "bytes": {
                message.putBytesProperty(key, XmlDataImporter.decode(value));
                break;
            }
            case "double": {
                message.putDoubleProperty(key, Double.parseDouble(value));
                break;
            }
            case "float": {
                message.putFloatProperty(key, Float.parseFloat(value));
                break;
            }
            case "integer": {
                message.putIntProperty(key, Integer.parseInt(value));
                break;
            }
            case "long": {
                message.putLongProperty(key, Long.parseLong(value));
                break;
            }
            case "simple-string": {
                message.putStringProperty(new SimpleString(key), new SimpleString(value));
                break;
            }
            case "string": {
                message.putStringProperty(key, value);
            }
        }
    }

    private void processMessageBody(Message message) throws XMLStreamException, IOException {
        Object attributeName;
        boolean isLarge = false;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            attributeName = this.reader.getAttributeLocalName(i);
            if (!"isLarge".equals(attributeName)) continue;
            isLarge = Boolean.parseBoolean(this.reader.getAttributeValue(i));
        }
        this.reader.next();
        if (isLarge) {
            this.tempFileName = java.util.UUID.randomUUID().toString() + ".tmp";
            HornetQServerLogger.LOGGER.debug("Creating temp file " + this.tempFileName + " for large message.");
            FileOutputStream out = new FileOutputStream(this.tempFileName);
            attributeName = null;
            try {
                while (this.reader.hasNext()) {
                    if (this.reader.getEventType() == 2) {
                        break;
                    }
                    String characters = new String(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                    String trimmedCharacters = characters.trim();
                    if (trimmedCharacters.length() > 0) {
                        byte[] data = XmlDataImporter.decode(trimmedCharacters);
                        ((OutputStream)out).write(data);
                    }
                    this.reader.next();
                }
            }
            catch (Throwable throwable) {
                attributeName = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (attributeName != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)attributeName).addSuppressed(x2);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
            FileInputStream fileInputStream = new FileInputStream(this.tempFileName);
            BufferedInputStream bufferedInput = new BufferedInputStream(fileInputStream);
            ((ClientMessage)message).setBodyInputStream(bufferedInput);
        } else {
            this.reader.next();
            String characters = new String(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            message.getBodyBuffer().writeBytes(XmlDataImporter.decode(characters.trim()));
        }
    }

    private void bindQueue() throws Exception {
        String queueName = "";
        String address = "";
        String filter = "";
        block10: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "address": {
                    address = this.reader.getAttributeValue(i);
                    continue block10;
                }
                case "queue-name": {
                    queueName = this.reader.getAttributeValue(i);
                    continue block10;
                }
                case "filter-string": {
                    filter = this.reader.getAttributeValue(i);
                }
            }
        }
        ClientSession.QueueQuery queueQuery = this.session.queueQuery(new SimpleString(queueName));
        if (!queueQuery.isExists()) {
            this.session.createQueue(address, queueName, filter, true);
            HornetQServerLogger.LOGGER.debug("Binding queue(name=" + queueName + ", address=" + address + ", filter=" + filter + ")");
        } else {
            HornetQServerLogger.LOGGER.debug("Binding " + queueName + " already exists so won't re-bind.");
        }
        this.addressMap.put(queueName, address);
    }

    private void createJmsConnectionFactories() throws Exception {
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"jms-connection-factory".equals(this.reader.getLocalName())) break;
                    this.createJmsConnectionFactory();
                    break;
                }
                case 2: {
                    if (!"jms-connection-factories".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
    }

    private void createJmsDestinations() throws Exception {
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"jms-destination".equals(this.reader.getLocalName())) break;
                    this.createJmsDestination();
                    break;
                }
                case 2: {
                    if (!"jms-destinations".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
    }

    private void createJmsConnectionFactory() throws Exception {
        String name = "";
        String callFailoverTimeout = "";
        String callTimeout = "";
        String clientFailureCheckPeriod = "";
        String clientId = "";
        String confirmationWindowSize = "";
        String connectionTtl = "";
        String connectors = "";
        String consumerMaxRate = "";
        String consumerWindowSize = "";
        String discoveryGroupName = "";
        String dupsOkBatchSize = "";
        String groupId = "";
        String loadBalancingPolicyClassName = "";
        String maxRetryInterval = "";
        String minLargeMessageSize = "";
        String producerMaxRate = "";
        String producerWindowSize = "";
        String reconnectAttempts = "";
        String retryInterval = "";
        String retryIntervalMultiplier = "";
        String scheduledThreadMaxPoolSize = "";
        String threadMaxPoolSize = "";
        String transactionBatchSize = "";
        String type = "";
        String entries = "";
        String autoGroup = "";
        String blockOnAcknowledge = "";
        String blockOnDurableSend = "";
        String blockOnNonDurableSend = "";
        String cacheLargeMessagesClient = "";
        String compressLargeMessages = "";
        String failoverOnInitialConnection = "";
        String ha = "";
        String preacknowledge = "";
        String useGlobalPools = "";
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("call-failover-timeout".equals(this.reader.getLocalName())) {
                        callFailoverTimeout = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory callFailoverTimeout: " + callFailoverTimeout);
                        break;
                    }
                    if ("call-timeout".equals(this.reader.getLocalName())) {
                        callTimeout = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory callTimeout: " + callTimeout);
                        break;
                    }
                    if ("client-failure-check-period".equals(this.reader.getLocalName())) {
                        clientFailureCheckPeriod = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory clientFailureCheckPeriod: " + clientFailureCheckPeriod);
                        break;
                    }
                    if ("client-id".equals(this.reader.getLocalName())) {
                        clientId = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory clientId: " + clientId);
                        break;
                    }
                    if ("confirmation-window-size".equals(this.reader.getLocalName())) {
                        confirmationWindowSize = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory confirmationWindowSize: " + confirmationWindowSize);
                        break;
                    }
                    if ("connection-ttl".equals(this.reader.getLocalName())) {
                        connectionTtl = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory connectionTtl: " + connectionTtl);
                        break;
                    }
                    if ("connector".equals(this.reader.getLocalName())) {
                        connectors = this.getConnectors();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory getLocalName: " + connectors);
                        break;
                    }
                    if ("consumer-max-rate".equals(this.reader.getLocalName())) {
                        consumerMaxRate = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory consumerMaxRate: " + consumerMaxRate);
                        break;
                    }
                    if ("consumer-window-size".equals(this.reader.getLocalName())) {
                        consumerWindowSize = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory consumerWindowSize: " + consumerWindowSize);
                        break;
                    }
                    if ("discovery-group-name".equals(this.reader.getLocalName())) {
                        discoveryGroupName = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory discoveryGroupName: " + discoveryGroupName);
                        break;
                    }
                    if ("dups-ok-batch-size".equals(this.reader.getLocalName())) {
                        dupsOkBatchSize = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory dupsOkBatchSize: " + dupsOkBatchSize);
                        break;
                    }
                    if ("group-id".equals(this.reader.getLocalName())) {
                        groupId = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory groupId: " + groupId);
                        break;
                    }
                    if ("load-balancing-policy-class-name".equals(this.reader.getLocalName())) {
                        loadBalancingPolicyClassName = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory loadBalancingPolicyClassName: " + loadBalancingPolicyClassName);
                        break;
                    }
                    if ("max-retry-interval".equals(this.reader.getLocalName())) {
                        maxRetryInterval = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory maxRetryInterval: " + maxRetryInterval);
                        break;
                    }
                    if ("min-large-message-size".equals(this.reader.getLocalName())) {
                        minLargeMessageSize = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory minLargeMessageSize: " + minLargeMessageSize);
                        break;
                    }
                    if ("name".equals(this.reader.getLocalName())) {
                        name = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory name: " + name);
                        break;
                    }
                    if ("producer-max-rate".equals(this.reader.getLocalName())) {
                        producerMaxRate = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory producerMaxRate: " + producerMaxRate);
                        break;
                    }
                    if ("producer-window-size".equals(this.reader.getLocalName())) {
                        producerWindowSize = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory producerWindowSize: " + producerWindowSize);
                        break;
                    }
                    if ("reconnect-attempts".equals(this.reader.getLocalName())) {
                        reconnectAttempts = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory reconnectAttempts: " + reconnectAttempts);
                        break;
                    }
                    if ("retry-interval".equals(this.reader.getLocalName())) {
                        retryInterval = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory retryInterval: " + retryInterval);
                        break;
                    }
                    if ("retry-interval-multiplier".equals(this.reader.getLocalName())) {
                        retryIntervalMultiplier = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory retryIntervalMultiplier: " + retryIntervalMultiplier);
                        break;
                    }
                    if ("scheduled-thread-pool-max-size".equals(this.reader.getLocalName())) {
                        scheduledThreadMaxPoolSize = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory scheduledThreadMaxPoolSize: " + scheduledThreadMaxPoolSize);
                        break;
                    }
                    if ("thread-pool-max-size".equals(this.reader.getLocalName())) {
                        threadMaxPoolSize = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory threadMaxPoolSize: " + threadMaxPoolSize);
                        break;
                    }
                    if ("transaction-batch-size".equals(this.reader.getLocalName())) {
                        transactionBatchSize = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory transactionBatchSize: " + transactionBatchSize);
                        break;
                    }
                    if ("type".equals(this.reader.getLocalName())) {
                        type = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory type: " + type);
                        break;
                    }
                    if ("entries".equals(this.reader.getLocalName())) {
                        entries = this.getEntries();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory entries: " + entries);
                        break;
                    }
                    if ("auto-group".equals(this.reader.getLocalName())) {
                        autoGroup = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory autoGroup: " + autoGroup);
                        break;
                    }
                    if ("block-on-acknowledge".equals(this.reader.getLocalName())) {
                        blockOnAcknowledge = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory blockOnAcknowledge: " + blockOnAcknowledge);
                        break;
                    }
                    if ("block-on-durable-send".equals(this.reader.getLocalName())) {
                        blockOnDurableSend = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory blockOnDurableSend: " + blockOnDurableSend);
                        break;
                    }
                    if ("block-on-non-durable-send".equals(this.reader.getLocalName())) {
                        blockOnNonDurableSend = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory blockOnNonDurableSend: " + blockOnNonDurableSend);
                        break;
                    }
                    if ("cache-large-messages-client".equals(this.reader.getLocalName())) {
                        cacheLargeMessagesClient = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.info("JMS connection factory " + name + " cacheLargeMessagesClient: " + cacheLargeMessagesClient);
                        break;
                    }
                    if ("compress-large-messages".equals(this.reader.getLocalName())) {
                        compressLargeMessages = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory compressLargeMessages: " + compressLargeMessages);
                        break;
                    }
                    if ("failover-on-initial-connection".equals(this.reader.getLocalName())) {
                        failoverOnInitialConnection = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory failoverOnInitialConnection: " + failoverOnInitialConnection);
                        break;
                    }
                    if ("ha".equals(this.reader.getLocalName())) {
                        ha = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory ha: " + ha);
                        break;
                    }
                    if ("preacknowledge".equals(this.reader.getLocalName())) {
                        preacknowledge = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS connection factory preacknowledge: " + preacknowledge);
                        break;
                    }
                    if (!"use-global-pools".equals(this.reader.getLocalName())) break;
                    useGlobalPools = this.reader.getElementText();
                    HornetQServerLogger.LOGGER.debug("JMS connection factory useGlobalPools: " + useGlobalPools);
                    break;
                }
                case 2: {
                    if (!"jms-connection-factory".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        ClientRequestor requestor = new ClientRequestor(this.managementSession, "jms.queue.hornetq.management");
        ClientMessage managementMessage = this.managementSession.createMessage(false);
        ManagementHelper.putOperationInvocation(managementMessage, "jms.server", "createConnectionFactory", name, Boolean.parseBoolean(ha), discoveryGroupName.length() > 0, Integer.parseInt(type), connectors, entries, clientId, Long.parseLong(clientFailureCheckPeriod), Long.parseLong(connectionTtl), Long.parseLong(callTimeout), Long.parseLong(callFailoverTimeout), Integer.parseInt(minLargeMessageSize), Boolean.parseBoolean(compressLargeMessages), Integer.parseInt(consumerWindowSize), Integer.parseInt(consumerMaxRate), Integer.parseInt(confirmationWindowSize), Integer.parseInt(producerWindowSize), Integer.parseInt(producerMaxRate), Boolean.parseBoolean(blockOnAcknowledge), Boolean.parseBoolean(blockOnDurableSend), Boolean.parseBoolean(blockOnNonDurableSend), Boolean.parseBoolean(autoGroup), Boolean.parseBoolean(preacknowledge), loadBalancingPolicyClassName, Integer.parseInt(transactionBatchSize), Integer.parseInt(dupsOkBatchSize), Boolean.parseBoolean(useGlobalPools), Integer.parseInt(scheduledThreadMaxPoolSize), Integer.parseInt(threadMaxPoolSize), Long.parseLong(retryInterval), Double.parseDouble(retryIntervalMultiplier), Long.parseLong(maxRetryInterval), Integer.parseInt(reconnectAttempts), Boolean.parseBoolean(failoverOnInitialConnection), groupId);
        this.managementSession.start();
        ClientMessage reply = requestor.request(managementMessage);
        if (ManagementHelper.hasOperationSucceeded(reply)) {
            HornetQServerLogger.LOGGER.debug("Created connection factory " + name);
        } else {
            HornetQServerLogger.LOGGER.error("Problem creating " + name);
        }
        requestor.close();
    }

    private void createJmsDestination() throws Exception {
        String name = "";
        String selector = "";
        String entries = "";
        String type = "";
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("name".equals(this.reader.getLocalName())) {
                        name = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS destination name: " + name);
                        break;
                    }
                    if ("selector".equals(this.reader.getLocalName())) {
                        selector = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS destination selector: " + selector);
                        break;
                    }
                    if ("type".equals(this.reader.getLocalName())) {
                        type = this.reader.getElementText();
                        HornetQServerLogger.LOGGER.debug("JMS destination type: " + type);
                        break;
                    }
                    if (!"entries".equals(this.reader.getLocalName())) break;
                    entries = this.getEntries();
                    break;
                }
                case 2: {
                    if (!"jms-destination".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        ClientRequestor requestor = new ClientRequestor(this.managementSession, "jms.queue.hornetq.management");
        ClientMessage managementMessage = this.managementSession.createMessage(false);
        if ("Queue".equals(type)) {
            ManagementHelper.putOperationInvocation(managementMessage, "jms.server", "createQueue", name, entries, selector);
        } else if ("Topic".equals(type)) {
            ManagementHelper.putOperationInvocation(managementMessage, "jms.server", "createTopic", name, entries);
        }
        this.managementSession.start();
        ClientMessage reply = requestor.request(managementMessage);
        if (ManagementHelper.hasOperationSucceeded(reply)) {
            HornetQServerLogger.LOGGER.debug("Created " + type.toLowerCase() + " " + name);
        } else {
            HornetQServerLogger.LOGGER.error("Problem creating " + name);
        }
        requestor.close();
    }

    private String getEntries() throws Exception {
        StringBuilder entry = new StringBuilder();
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"entry".equals(this.reader.getLocalName())) break;
                    String elementText = this.reader.getElementText();
                    entry.append(elementText).append(", ");
                    if (this.applicationServerCompatibility) {
                        entry.append("java:jboss/exported/").append(elementText).append(", ");
                    }
                    HornetQServerLogger.LOGGER.debug("JMS admin object JNDI entry: " + entry.toString());
                    break;
                }
                case 2: {
                    if (!"entries".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        return entry.delete(entry.length() - 2, entry.length()).toString();
    }

    private String getConnectors() throws Exception {
        StringBuilder entry = new StringBuilder();
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"connector".equals(this.reader.getLocalName())) break;
                    entry.append(this.reader.getElementText()).append(", ");
                    break;
                }
                case 2: {
                    if (!"connectors".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        return entry.delete(entry.length() - 2, entry.length()).toString();
    }

    private static byte[] decode(String data) {
        return Base64.decode(data, 24);
    }
}

