/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ExposedDataOutputStream
extends DataOutputStream {
    public ExposedDataOutputStream(OutputStream out) {
        super(out);
    }

    public void reset() {
        this.written = 0;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    private void incCount(int value) {
        int temp = this.written + value;
        if (temp < 0) {
            temp = Integer.MAX_VALUE;
        }
        this.written = temp;
    }
}

