/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.server;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.jboss.logging.Logger;
import org.jnp.server.EventListenerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListeners {
    private static Logger log = Logger.getLogger(EventListeners.class);
    private EventContext context;
    private CopyOnWriteArrayList<EventListenerInfo> listeners;
    private boolean trace;

    public EventListeners(EventContext context) {
        this.context = context;
        this.trace = log.isTraceEnabled();
    }

    public synchronized void addNamingListener(EventContext context, Name target, int scope, NamingListener l) throws NamingException {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList();
        }
        this.context = context;
        String prefix = context.getNameInNamespace();
        String fullTargetName = prefix + target.toString();
        EventListenerInfo info = new EventListenerInfo(l, fullTargetName, scope);
        this.listeners.add(info);
    }

    public void removeNamingListener(NamingListener l) {
        if (this.listeners == null) {
            return;
        }
        EventListenerInfo info = new EventListenerInfo(l, null, 0);
        this.listeners.remove(info);
    }

    public void fireEvent(Name fullName, Binding oldb, Binding newb, int type, String changeInfo, Set<Integer> scopes) {
        if (this.listeners != null) {
            if (this.trace) {
                log.trace("fireEvent, fullName:" + fullName + " type: " + type + ", changeInfo:" + changeInfo + ", scopes:" + scopes);
            }
            String name = fullName.toString();
            NamingEvent event = new NamingEvent(this.context, type, newb, oldb, changeInfo);
            for (EventListenerInfo info : this.listeners) {
                if (!scopes.contains(info.getScope())) continue;
                String targetName = info.getFullTargetName();
                int scope = info.getScope();
                boolean matches = false;
                matches = scope == 2 ? name.startsWith(targetName) : (scope == 1 ? fullName.size() == 1 : name.equals(targetName));
                if (!matches) continue;
                this.dispatch(info.getListener(), event);
            }
        }
    }

    public void dispatch(NamingListener listener, NamingEvent event) {
        switch (event.getType()) {
            case 0: {
                if (!(listener instanceof NamespaceChangeListener)) break;
                ((NamespaceChangeListener)listener).objectAdded(event);
                break;
            }
            case 1: {
                if (!(listener instanceof NamespaceChangeListener)) break;
                ((NamespaceChangeListener)listener).objectRemoved(event);
                break;
            }
            case 2: {
                if (!(listener instanceof NamespaceChangeListener)) break;
                ((NamespaceChangeListener)listener).objectRenamed(event);
                break;
            }
            case 3: {
                if (!(listener instanceof ObjectChangeListener)) break;
                ((ObjectChangeListener)listener).objectChanged(event);
            }
        }
    }
}

