/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import javax.management.ObjectName;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.SimpleString;

public final class ObjectNameBuilder {
    public static final ObjectNameBuilder DEFAULT = new ObjectNameBuilder(HornetQDefaultConfiguration.getDefaultJmxDomain());
    static final String DEFAULT_SUBSYSTEM = "messaging";
    static final String DEFAULT_SERVER = "default";
    private final String domain;
    private final String subsystem;
    private final String serverName;

    public static ObjectNameBuilder create(String domain) {
        if (domain == null) {
            return new ObjectNameBuilder(HornetQDefaultConfiguration.getDefaultJmxDomain());
        }
        return new ObjectNameBuilder(domain);
    }

    private ObjectNameBuilder(String domain) {
        this.domain = domain;
        this.subsystem = DEFAULT_SUBSYSTEM;
        this.serverName = DEFAULT_SERVER;
    }

    public ObjectName getHornetQServerObjectName() throws Exception {
        String value = String.format("%s:subsystem=%s,hornetq-server=%s", this.domain, this.subsystem, this.serverName);
        return ObjectName.getInstance(value);
    }

    public ObjectName getAddressObjectName(SimpleString address) throws Exception {
        return this.createObjectName("core-address", address.toString());
    }

    public ObjectName getQueueObjectName(SimpleString address, SimpleString name) throws Exception {
        ObjectProperty[] props = new ObjectProperty[]{new ObjectProperty("address", address.toString()), new ObjectProperty("runtime-queue", name.toString())};
        return this.createObjectName(props);
    }

    public ObjectName getDivertObjectName(String name) throws Exception {
        return this.createObjectName("divert", name.toString());
    }

    public ObjectName getAcceptorObjectName(String name) throws Exception {
        return this.createObjectName("remote-acceptor", name);
    }

    public ObjectName getBroadcastGroupObjectName(String name) throws Exception {
        return this.createObjectName("broadcast-group", name);
    }

    public ObjectName getBridgeObjectName(String name) throws Exception {
        return this.createObjectName("bridge", name);
    }

    public ObjectName getClusterConnectionObjectName(String name) throws Exception {
        return this.createObjectName("cluster-connection", name);
    }

    public ObjectName getDiscoveryGroupObjectName(String name) throws Exception {
        return this.createObjectName("discovery-group", name);
    }

    public ObjectName getJMSServerObjectName() throws Exception {
        String value = String.format("%s:subsystem=%s,hornetq-server=%s", this.domain, this.subsystem, this.serverName);
        return ObjectName.getInstance(value);
    }

    public ObjectName getJMSQueueObjectName(String name) throws Exception {
        return this.createObjectName("jms-queue", name);
    }

    public ObjectName getJMSTopicObjectName(String name) throws Exception {
        return this.createObjectName("jms-topic", name);
    }

    public ObjectName getConnectionFactoryObjectName(String name) throws Exception {
        return this.createObjectName("connection-factory", name);
    }

    private ObjectName createObjectName(String beanType, String beanName) throws Exception {
        return this.createObjectName(new ObjectProperty[]{new ObjectProperty(beanType, beanName)});
    }

    private ObjectName createObjectName(ObjectProperty[] props) throws Exception {
        String baseValue = String.format("%s:subsystem=%s,hornetq-server=%s", this.domain, this.subsystem, this.serverName);
        StringBuilder builder = new StringBuilder(baseValue);
        for (ObjectProperty p : props) {
            builder.append(",");
            builder.append(p.key);
            builder.append("=");
            builder.append(ObjectName.quote(p.val));
        }
        return ObjectName.getInstance(builder.toString());
    }

    private static class ObjectProperty {
        String key;
        String val;

        public ObjectProperty(String k, String v) {
            this.key = k;
            this.val = v;
        }
    }
}

