/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public final class BackupRegistrationMessage
extends PacketImpl {
    private TransportConfiguration connector;
    private String clusterUser;
    private String clusterPassword;
    private boolean backupWantsFailBack;

    public BackupRegistrationMessage(TransportConfiguration tc, String user, String password, boolean backupWantsFailBack) {
        this();
        this.connector = tc;
        this.clusterUser = user;
        this.clusterPassword = password;
        this.backupWantsFailBack = backupWantsFailBack;
    }

    public BackupRegistrationMessage() {
        super((byte)115);
    }

    public TransportConfiguration getConnector() {
        return this.connector;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeString(this.clusterUser);
        buffer.writeString(this.clusterPassword);
        buffer.writeBoolean(this.backupWantsFailBack);
        this.connector.encode(buffer);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.clusterUser = buffer.readString();
        this.clusterPassword = buffer.readString();
        this.backupWantsFailBack = buffer.readBoolean();
        this.connector = new TransportConfiguration();
        this.connector.decode(buffer);
    }

    public String getClusterUser() {
        return this.clusterUser;
    }

    public String getClusterPassword() {
        return this.clusterPassword;
    }

    public boolean isFailBackRequest() {
        return this.backupWantsFailBack;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.backupWantsFailBack ? 1231 : 1237);
        result = 31 * result + (this.clusterPassword == null ? 0 : this.clusterPassword.hashCode());
        result = 31 * result + (this.clusterUser == null ? 0 : this.clusterUser.hashCode());
        result = 31 * result + (this.connector == null ? 0 : this.connector.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BackupRegistrationMessage)) {
            return false;
        }
        BackupRegistrationMessage other = (BackupRegistrationMessage)obj;
        if (this.backupWantsFailBack != other.backupWantsFailBack) {
            return false;
        }
        if (this.clusterPassword == null ? other.clusterPassword != null : !this.clusterPassword.equals(other.clusterPassword)) {
            return false;
        }
        if (this.clusterUser == null ? other.clusterUser != null : !this.clusterUser.equals(other.clusterUser)) {
            return false;
        }
        return !(this.connector == null ? other.connector != null : !this.connector.equals(other.connector));
    }
}

