/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnection;
import org.hornetq.core.remoting.impl.invm.InVMConnector;
import org.hornetq.core.remoting.impl.invm.InVMRegistry;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.TypedProperties;

public final class InVMAcceptor
implements Acceptor {
    private final int id;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private volatile boolean started;
    private final ExecutorFactory executorFactory;
    private final ClusterConnection clusterConnection;
    private boolean paused;
    private NotificationService notificationService;
    private final Map<String, Object> configuration;
    private HornetQPrincipal defaultHornetQPrincipal;

    public InVMAcceptor(ClusterConnection clusterConnection, Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor threadPool) {
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
        this.handler = handler;
        this.listener = listener;
        this.id = ConfigurationHelper.getIntProperty("server-id", 0, configuration);
        this.executorFactory = new OrderedExecutorFactory(threadPool);
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Override
    public ClusterConnection getClusterConnection() {
        return this.clusterConnection;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        InVMRegistry.instance.registerAcceptor(this.id, this);
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(InVMAcceptorFactory.class.getName()));
            props.putIntProperty(new SimpleString("id"), this.id);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
        this.started = true;
        this.paused = false;
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        if (!this.paused) {
            InVMRegistry.instance.unregisterAcceptor(this.id);
        }
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(InVMAcceptorFactory.class.getName()));
            props.putIntProperty(new SimpleString("id"), this.id);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.started = false;
        this.paused = false;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void pause() {
        if (!this.started || this.paused) {
            return;
        }
        InVMRegistry.instance.unregisterAcceptor(this.id);
        this.paused = true;
    }

    @Override
    public synchronized void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public BufferHandler getHandler() {
        if (!this.started) {
            throw new IllegalStateException("Acceptor is not started");
        }
        return this.handler;
    }

    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public void connect(String connectionID, BufferHandler remoteHandler, InVMConnector connector, Executor clientExecutor) {
        if (!this.started) {
            throw new IllegalStateException("Acceptor is not started");
        }
        Listener connectionListener = new Listener(connector);
        InVMConnection inVMConnection = new InVMConnection(this.id, connectionID, remoteHandler, connectionListener, clientExecutor, this.defaultHornetQPrincipal);
        connectionListener.connectionCreated(this, inVMConnection, "CORE");
    }

    public void disconnect(String connectionID) {
        if (!this.started) {
            return;
        }
        Connection conn = (Connection)this.connections.get(connectionID);
        if (conn != null) {
            conn.close();
        }
    }

    @Override
    public boolean isUnsecurable() {
        return true;
    }

    @Override
    public void setDefaultHornetQPrincipal(HornetQPrincipal defaultHornetQPrincipal) {
        this.defaultHornetQPrincipal = defaultHornetQPrincipal;
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private final InVMConnector connector;

        Listener(InVMConnector connector) {
            this.connector = connector;
        }

        @Override
        public void connectionCreated(HornetQComponent component, Connection connection, String protocol) {
            if (InVMAcceptor.this.connections.putIfAbsent((String)connection.getID(), connection) != null) {
                throw HornetQMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            InVMAcceptor.this.listener.connectionCreated(component, connection, protocol);
        }

        @Override
        public void connectionDestroyed(final Object connectionID) {
            InVMConnection connection = (InVMConnection)InVMAcceptor.this.connections.remove(connectionID);
            if (connection != null) {
                InVMAcceptor.this.listener.connectionDestroyed(connectionID);
                connection.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Listener.this.connector.disconnect((String)connectionID);
                    }
                });
            }
        }

        @Override
        public void connectionException(Object connectionID, HornetQException me) {
            InVMAcceptor.this.listener.connectionException(connectionID, me);
        }

        @Override
        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    }
}

