/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalEventLoopGroup;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.protocol.ProtocolHandler;
import org.hornetq.core.remoting.impl.netty.ConnectionCreator;
import org.hornetq.core.remoting.impl.netty.HornetQChannelHandler;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyServerConnection;
import org.hornetq.core.remoting.impl.netty.PartialPooledByteBufAllocator;
import org.hornetq.core.remoting.impl.netty.TransportConstants;
import org.hornetq.core.remoting.impl.ssl.SSLSupport;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.TypedProperties;

public class NettyAcceptor
implements Acceptor {
    private final String name;
    private final ClusterConnection clusterConnection;
    private Class<? extends ServerChannel> channelClazz;
    private EventLoopGroup eventLoopGroup;
    private volatile ChannelGroup serverChannelGroup;
    private volatile ChannelGroup channelGroup;
    private ServerBootstrap bootstrap;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean useInvm;
    private final ProtocolHandler protocolHandler;
    private final String host;
    private final int port;
    private final String keyStoreProvider;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStoreProvider;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String enabledCipherSuites;
    private final String enabledProtocols;
    private final boolean needClientAuth;
    private final boolean tcpNoDelay;
    private final int backlog;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final int nioRemotingThreads;
    private final ConcurrentMap<Object, NettyServerConnection> connections = new ConcurrentHashMap<Object, NettyServerConnection>();
    private final Map<String, Object> configuration;
    private final ScheduledExecutorService scheduledThreadPool;
    private NotificationService notificationService;
    private boolean paused;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;
    private final long batchDelay;
    private final boolean directDeliver;
    private final boolean httpUpgradeEnabled;

    public NettyAcceptor(String name, ClusterConnection clusterConnection, Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, ScheduledExecutorService scheduledThreadPool, Map<String, ProtocolManager> protocolMap) {
        this.name = name;
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
        this.handler = handler;
        this.listener = listener;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty("ssl-enabled", false, configuration);
        this.nioRemotingThreads = ConfigurationHelper.getIntProperty("nio-remoting-threads", -1, configuration);
        this.backlog = ConfigurationHelper.getIntProperty("backlog", -1, configuration);
        this.useInvm = ConfigurationHelper.getBooleanProperty("use-invm", false, configuration);
        this.protocolHandler = new ProtocolHandler(protocolMap, this, configuration, scheduledThreadPool);
        this.host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty("port", 5445, configuration);
        if (this.sslEnabled) {
            this.keyStoreProvider = ConfigurationHelper.getStringProperty("key-store-provider", "JKS", configuration);
            this.keyStorePath = ConfigurationHelper.getStringProperty("key-store-path", TransportConstants.DEFAULT_KEYSTORE_PATH, configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty("key-store-password", TransportConstants.DEFAULT_KEYSTORE_PASSWORD, configuration, HornetQDefaultConfiguration.getPropMaskPassword(), HornetQDefaultConfiguration.getPropMaskPassword());
            this.trustStoreProvider = ConfigurationHelper.getStringProperty("trust-store-provider", "JKS", configuration);
            this.trustStorePath = ConfigurationHelper.getStringProperty("trust-store-path", TransportConstants.DEFAULT_TRUSTSTORE_PATH, configuration);
            this.trustStorePassword = ConfigurationHelper.getPasswordProperty("trust-store-password", TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD, configuration, HornetQDefaultConfiguration.getPropMaskPassword(), HornetQDefaultConfiguration.getPropMaskPassword());
            this.enabledCipherSuites = ConfigurationHelper.getStringProperty("enabled-cipher-suites", TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES, configuration);
            this.enabledProtocols = ConfigurationHelper.getStringProperty("enabled-protocols", TransportConstants.DEFAULT_ENABLED_PROTOCOLS, configuration);
            this.needClientAuth = ConfigurationHelper.getBooleanProperty("need-client-auth", false, configuration);
        } else {
            this.keyStoreProvider = "JKS";
            this.keyStorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
            this.keyStorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
            this.trustStoreProvider = "JKS";
            this.trustStorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
            this.trustStorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
            this.enabledCipherSuites = TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES;
            this.enabledProtocols = TransportConstants.DEFAULT_ENABLED_PROTOCOLS;
            this.needClientAuth = false;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty("tcp-no-delay", true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty("tcp-send-buffer-size", 32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty("tcp-receive-buffer-size", 32768, configuration);
        this.scheduledThreadPool = scheduledThreadPool;
        this.batchDelay = ConfigurationHelper.getLongProperty("batch-delay", 0L, configuration);
        this.directDeliver = ConfigurationHelper.getBooleanProperty("direct-deliver", true, configuration);
        this.httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty("http-upgrade-enabled", false, configuration);
    }

    @Override
    public synchronized void start() throws Exception {
        SSLContext context;
        if (this.channelClazz != null) {
            return;
        }
        if (this.useInvm) {
            this.channelClazz = LocalServerChannel.class;
            this.eventLoopGroup = new LocalEventLoopGroup();
        } else {
            int threadsToUse = this.nioRemotingThreads == -1 ? Runtime.getRuntime().availableProcessors() * 3 : this.nioRemotingThreads;
            this.channelClazz = NioServerSocketChannel.class;
            this.eventLoopGroup = new NioEventLoopGroup(threadsToUse, new HornetQThreadFactory("hornetq-netty-threads", true, NettyAcceptor.getThisClassLoader()));
        }
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.group(this.eventLoopGroup);
        this.bootstrap.channel(this.channelClazz);
        if (this.sslEnabled) {
            try {
                if (this.keyStorePath == null && "JKS".equals(this.keyStoreProvider)) {
                    throw new IllegalArgumentException("If \"ssl-enabled\" is true then \"key-store-path\" must be non-null unless an alternative \"key-store-provider\" has been specified.");
                }
                context = SSLSupport.createContext(this.keyStoreProvider, this.keyStorePath, this.keyStorePassword, this.trustStoreProvider, this.trustStorePath, this.trustStorePassword);
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Unable to create NettyAcceptor for " + this.host + ":" + this.port);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        ChannelInitializer<Channel> factory = new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyAcceptor.this.sslEnabled) {
                    SSLEngine engine = context.createSSLEngine();
                    engine.setUseClientMode(false);
                    if (NettyAcceptor.this.needClientAuth) {
                        engine.setNeedClientAuth(true);
                    }
                    String[] originalProtocols = engine.getEnabledProtocols();
                    if (NettyAcceptor.this.enabledCipherSuites != null) {
                        try {
                            engine.setEnabledCipherSuites(SSLSupport.parseCommaSeparatedListIntoArray(NettyAcceptor.this.enabledCipherSuites));
                        }
                        catch (IllegalArgumentException e) {
                            HornetQServerLogger.LOGGER.invalidCipherSuite(SSLSupport.parseArrayIntoCommandSeparatedList(engine.getSupportedCipherSuites()));
                            throw e;
                        }
                    }
                    if (NettyAcceptor.this.enabledProtocols != null) {
                        try {
                            engine.setEnabledProtocols(SSLSupport.parseCommaSeparatedListIntoArray(NettyAcceptor.this.enabledProtocols));
                        }
                        catch (IllegalArgumentException e) {
                            HornetQServerLogger.LOGGER.invalidProtocol(SSLSupport.parseArrayIntoCommandSeparatedList(engine.getSupportedProtocols()));
                            throw e;
                        }
                    } else {
                        engine.setEnabledProtocols(originalProtocols);
                    }
                    SslHandler handler = new SslHandler(engine);
                    pipeline.addLast("ssl", (ChannelHandler)handler);
                }
                pipeline.addLast(NettyAcceptor.this.protocolHandler.getProtocolDecoder());
            }
        };
        this.bootstrap.childHandler(factory);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, this.tcpSendBufferSize);
        }
        if (this.backlog != -1) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, this.backlog);
        }
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, true);
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, true);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, true);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
        this.channelGroup = new DefaultChannelGroup("hornetq-accepted-channels", GlobalEventExecutor.INSTANCE);
        this.serverChannelGroup = new DefaultChannelGroup("hornetq-acceptor-channels", GlobalEventExecutor.INSTANCE);
        if (!this.httpUpgradeEnabled) {
            this.startServerChannels();
            this.paused = false;
            if (this.notificationService != null) {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
                props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
                props.putIntProperty(new SimpleString("port"), this.port);
                Notification notification = new Notification(null, NotificationType.ACCEPTOR_STARTED, props);
                this.notificationService.sendNotification(notification);
            }
            if (this.batchDelay > 0L) {
                this.flusher = new BatchFlusher();
                this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
            }
            HornetQServerLogger.LOGGER.startedNettyAcceptor(TransportConstants.NETTY_VERSION, this.host, this.port);
        }
    }

    public void transfer(Channel channel) {
        channel.pipeline().addLast(this.protocolHandler.getProtocolDecoder());
    }

    private void startServerChannels() {
        String[] hosts;
        for (String h : hosts = TransportConfiguration.splitHosts(this.host)) {
            SocketAddress address = this.useInvm ? new LocalAddress(h) : new InetSocketAddress(h, this.port);
            Channel serverChannel = this.bootstrap.bind(address).syncUninterruptibly().channel();
            this.serverChannelGroup.add(serverChannel);
        }
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void stop() {
        if (this.channelClazz == null) {
            return;
        }
        if (this.protocolHandler != null) {
            this.protocolHandler.close();
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        this.serverChannelGroup.close().awaitUninterruptibly();
        ChannelGroupFuture future = this.channelGroup.close().awaitUninterruptibly();
        if (!future.isSuccess()) {
            HornetQServerLogger.LOGGER.nettyChannelGroupError();
            for (Channel channel : future.group()) {
                if (!channel.isActive()) continue;
                HornetQServerLogger.LOGGER.nettyChannelStillOpen(channel, channel.remoteAddress());
            }
        }
        this.eventLoopGroup.shutdownGracefully(100L, 3000L, TimeUnit.MILLISECONDS);
        this.eventLoopGroup = null;
        this.channelClazz = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.paused = false;
    }

    @Override
    public boolean isStarted() {
        return this.channelClazz != null;
    }

    @Override
    public synchronized void pause() {
        if (this.paused) {
            return;
        }
        if (this.channelClazz == null) {
            return;
        }
        ChannelGroupFuture future = this.serverChannelGroup.close().awaitUninterruptibly();
        if (!future.isSuccess()) {
            HornetQServerLogger.LOGGER.nettyChannelGroupBindError();
            for (Channel channel : future.group()) {
                if (!channel.isActive()) continue;
                HornetQServerLogger.LOGGER.nettyChannelStillBound(channel, channel.remoteAddress());
            }
        }
        this.paused = true;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public void setDefaultHornetQPrincipal(HornetQPrincipal defaultHornetQPrincipal) {
        throw new IllegalStateException("unsecure connections not allowed");
    }

    @Override
    public boolean isUnsecurable() {
        return false;
    }

    @Override
    public ClusterConnection getClusterConnection() {
        return this.clusterConnection;
    }

    public ConnectionCreator createConnectionCreator() {
        return new HornetQServerChannelHandler(this.channelGroup, this.handler, new Listener());
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    static {
        ResourceLeakDetector.setEnabled(false);
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                for (Connection connection : NettyAcceptor.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        @Override
        public void connectionCreated(HornetQComponent component, Connection connection, String protocol) {
            if (NettyAcceptor.this.connections.putIfAbsent(connection.getID(), (NettyServerConnection)connection) != null) {
                throw HornetQMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            NettyAcceptor.this.listener.connectionCreated(component, connection, protocol);
        }

        @Override
        public void connectionDestroyed(Object connectionID) {
            if (NettyAcceptor.this.connections.remove(connectionID) != null) {
                NettyAcceptor.this.listener.connectionDestroyed(connectionID);
            }
        }

        @Override
        public void connectionException(final Object connectionID, final HornetQException me) {
            new Thread(){

                @Override
                public void run() {
                    NettyAcceptor.this.listener.connectionException(connectionID, me);
                }
            }.start();
        }

        @Override
        public void connectionReadyForWrites(Object connectionID, boolean ready) {
            NettyServerConnection conn = (NettyServerConnection)NettyAcceptor.this.connections.get(connectionID);
            if (conn != null) {
                conn.fireReady(ready);
            }
        }
    }

    private final class HornetQServerChannelHandler
    extends HornetQChannelHandler
    implements ConnectionCreator {
        HornetQServerChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }

        @Override
        public NettyServerConnection createConnection(ChannelHandlerContext ctx, String protocol, boolean httpEnabled) throws Exception {
            super.channelActive(ctx);
            Listener connectionListener = new Listener();
            NettyServerConnection nc = new NettyServerConnection(NettyAcceptor.this.configuration, ctx.channel(), connectionListener, !httpEnabled && NettyAcceptor.this.batchDelay > 0L, NettyAcceptor.this.directDeliver);
            connectionListener.connectionCreated(NettyAcceptor.this, nc, protocol);
            SslHandler sslHandler = ctx.pipeline().get(SslHandler.class);
            if (sslHandler != null) {
                sslHandler.handshakeFuture().addListener(new GenericFutureListener<Future<Channel>>(){

                    @Override
                    public void operationComplete(Future<Channel> future) throws Exception {
                        if (future.isSuccess()) {
                            HornetQServerChannelHandler.this.active = true;
                        } else {
                            future.getNow().close();
                        }
                    }
                });
            } else {
                this.active = true;
            }
            return nc;
        }
    }
}

