/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.group.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.group.impl.GroupHandlingAbstract;
import org.hornetq.core.server.group.impl.Proposal;
import org.hornetq.core.server.group.impl.Response;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.TypedProperties;

public final class RemoteGroupingHandler
extends GroupHandlingAbstract {
    private final SimpleString name;
    private final Map<SimpleString, Response> responses = new ConcurrentHashMap<SimpleString, Response>();
    private final Lock lock = new ReentrantLock();
    private final Condition sendCondition = this.lock.newCondition();
    private final long timeout;
    private final long groupTimeout;
    private final ConcurrentMap<SimpleString, List<SimpleString>> groupMap = new ConcurrentHashMap<SimpleString, List<SimpleString>>();
    private final ConcurrentHashSet<Notification> pendingNotifications = new ConcurrentHashSet();
    private boolean started = false;

    public RemoteGroupingHandler(ExecutorFactory executorFactory, ManagementService managementService, SimpleString name, SimpleString address, long timeout, long groupTimeout) {
        super(executorFactory != null ? executorFactory.getExecutor() : null, managementService, address);
        this.name = name;
        this.timeout = timeout;
        this.groupTimeout = groupTimeout;
    }

    public RemoteGroupingHandler(ManagementService managementService, SimpleString name, SimpleString address, long timeout, long groupTimeout) {
        this(null, managementService, name, address, timeout, groupTimeout);
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
    }

    @Override
    public void stop() throws Exception {
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resendPending() throws Exception {
        try {
            this.lock.lock();
            for (Notification notification : this.pendingNotifications) {
                this.managementService.sendNotification(notification);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response propose(Proposal proposal) throws Exception {
        Response response;
        block7: {
            response = this.responses.get(proposal.getGroupId());
            if (response != null) {
                this.checkTimeout(response);
                return response;
            }
            if (!this.started) {
                throw HornetQMessageBundle.BUNDLE.groupWhileStopping();
            }
            Notification notification = null;
            try {
                this.lock.lock();
                notification = this.createProposalNotification(proposal.getGroupId(), proposal.getClusterName());
                this.pendingNotifications.add(notification);
                this.managementService.sendNotification(notification);
                long timeLimit = System.currentTimeMillis() + this.timeout;
                do {
                    this.sendCondition.await(this.timeout, TimeUnit.MILLISECONDS);
                } while ((response = this.responses.get(proposal.getGroupId())) == null && timeLimit > System.currentTimeMillis());
                if (notification == null) break block7;
                this.pendingNotifications.remove(notification);
            }
            catch (Throwable throwable) {
                if (notification != null) {
                    this.pendingNotifications.remove(notification);
                }
                this.lock.unlock();
                throw throwable;
            }
        }
        this.lock.unlock();
        if (response == null) {
            HornetQServerLogger.LOGGER.groupHandlerSendTimeout();
        }
        return response;
    }

    @Override
    public void awaitBindings() {
    }

    private void checkTimeout(Response response) {
        if (response != null && this.groupTimeout > 0L && response.getTimeUsed() + this.groupTimeout < System.currentTimeMillis()) {
            response.use();
            try {
                this.managementService.sendNotification(this.createProposalNotification(response.getGroupId(), response.getClusterName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Notification createProposalNotification(SimpleString groupId, SimpleString clusterName) {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, groupId);
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, clusterName);
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, 0);
        return new Notification(null, NotificationType.PROPOSAL, props);
    }

    @Override
    public Response getProposal(SimpleString fullID, boolean touchTime) {
        Response response = this.responses.get(fullID);
        if (touchTime) {
            this.checkTimeout(response);
        }
        return response;
    }

    @Override
    public void remove(SimpleString groupid, SimpleString clusterName) throws Exception {
        List groups = (List)this.groupMap.get(clusterName);
        if (groups != null) {
            groups.remove(groupid);
        }
        this.responses.remove(groupid);
        this.fireUnproposed(groupid);
    }

    @Override
    public void remove(SimpleString groupid, SimpleString clusterName, int distance) throws Exception {
        this.remove(groupid, clusterName);
        this.sendUnproposal(groupid, clusterName, distance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proposed(Response response) throws Exception {
        try {
            this.lock.lock();
            this.responses.put(response.getGroupId(), response);
            List<SimpleString> newList = new ArrayList<SimpleString>();
            List oldList = this.groupMap.putIfAbsent(response.getChosenClusterName(), newList);
            if (oldList != null) {
                newList = oldList;
            }
            newList.add(response.getGroupId());
            this.sendCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Response receive(Proposal proposal, int distance) throws Exception {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, proposal.getGroupId());
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, proposal.getClusterName());
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance);
        Notification notification = new Notification(null, NotificationType.PROPOSAL, props);
        this.managementService.sendNotification(notification);
        return null;
    }

    @Override
    public void sendProposalResponse(Response response, int distance) throws Exception {
    }

    @Override
    public void addGroupBinding(GroupBinding groupBinding) {
    }

    @Override
    public void onNotification(Notification notification) {
        SimpleString clusterName;
        List list;
        if (notification.getType() == NotificationType.BINDING_REMOVED && (list = (List)this.groupMap.remove(clusterName = notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME))) != null) {
            for (SimpleString val : list) {
                if (val == null) continue;
                this.responses.remove(val);
            }
        }
    }
}

