/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.TransientQueueManager;
import org.hornetq.utils.ReferenceCounterUtil;

public class TransientQueueManagerImpl
implements TransientQueueManager {
    private final SimpleString queueName;
    private final HornetQServer server;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                    HornetQServerLogger.LOGGER.debug("deleting temporary queue " + TransientQueueManagerImpl.this.queueName);
                }
                try {
                    TransientQueueManagerImpl.this.server.destroyQueue(TransientQueueManagerImpl.this.queueName, null, false);
                }
                catch (HornetQException e) {
                    HornetQServerLogger.LOGGER.warn("Error on deleting queue " + TransientQueueManagerImpl.this.queueName + ", " + e.getMessage(), e);
                }
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorRemovingTempQueue(e, TransientQueueManagerImpl.this.queueName);
            }
        }
    };
    private final ReferenceCounterUtil referenceCounterUtil = new ReferenceCounterUtil(this.runnable);

    public TransientQueueManagerImpl(HornetQServer server, SimpleString queueName) {
        this.server = server;
        this.queueName = queueName;
    }

    @Override
    public int increment() {
        return this.referenceCounterUtil.increment();
    }

    @Override
    public int decrement() {
        return this.referenceCounterUtil.decrement();
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

