/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.Arrays;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.jms.client.HornetQConnectionFactory;

public class XARecoveryConfig {
    private final boolean ha;
    private final TransportConfiguration[] transportConfiguration;
    private final DiscoveryGroupConfiguration discoveryConfiguration;
    private final String username;
    private final String password;

    public static XARecoveryConfig newConfig(HornetQConnectionFactory factory, String userName, String password) {
        if (factory.getServerLocator().getDiscoveryGroupConfiguration() != null) {
            return new XARecoveryConfig(factory.getServerLocator().isHA(), factory.getServerLocator().getDiscoveryGroupConfiguration(), userName, password);
        }
        return new XARecoveryConfig(factory.getServerLocator().isHA(), factory.getServerLocator().getStaticTransportConfigurations(), userName, password);
    }

    public XARecoveryConfig(boolean ha, TransportConfiguration[] transportConfiguration, String username, String password) {
        this.transportConfiguration = transportConfiguration;
        this.discoveryConfiguration = null;
        this.username = username;
        this.password = password;
        this.ha = ha;
    }

    public XARecoveryConfig(boolean ha, DiscoveryGroupConfiguration discoveryConfiguration, String username, String password) {
        this.discoveryConfiguration = discoveryConfiguration;
        this.transportConfiguration = null;
        this.username = username;
        this.password = password;
        this.ha = ha;
    }

    public boolean isHA() {
        return this.ha;
    }

    public DiscoveryGroupConfiguration getDiscoveryConfiguration() {
        return this.discoveryConfiguration;
    }

    public TransportConfiguration[] getTransportConfig() {
        return this.transportConfiguration;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public ServerLocator createServerLocator() {
        if (this.getDiscoveryConfiguration() != null) {
            return HornetQClient.createServerLocator(this.isHA(), this.getDiscoveryConfiguration());
        }
        return HornetQClient.createServerLocator(this.isHA(), this.getTransportConfig());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.discoveryConfiguration == null ? 0 : this.discoveryConfiguration.hashCode());
        result = 31 * result + Arrays.hashCode(this.transportConfiguration);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XARecoveryConfig other = (XARecoveryConfig)obj;
        if (this.discoveryConfiguration == null ? other.discoveryConfiguration != null : !this.discoveryConfiguration.equals(other.discoveryConfiguration)) {
            return false;
        }
        return Arrays.equals(this.transportConfiguration, other.transportConfiguration);
    }

    public String toString() {
        return "XARecoveryConfig [transportConfiguration = " + Arrays.toString(this.transportConfiguration) + ", discoveryConfiguration = " + this.discoveryConfiguration + ", username=" + this.username + ", password=****]";
    }
}

