/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.server;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.logging.Logger;
import org.jboss.naming.ENCFactory;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.server.EventMgr;
import org.jnp.server.Main;
import org.jnp.server.NamingBean;
import org.jnp.server.NamingServer;
import org.jnp.server.NamingServerWrapper;

public class NamingBeanImpl
implements NamingBean {
    private static Logger log = Logger.getLogger(NamingBeanImpl.class);
    protected Naming theServer;
    protected boolean InstallGlobalService = true;
    protected boolean UseGlobalService = true;
    private EventMgr eventMgr;
    private SecurityManager securityMgr;

    public static void main(String[] args) throws Exception {
        new Main().start();
    }

    public Naming getNamingInstance() {
        return this.theServer;
    }

    public boolean getInstallGlobalService() {
        return this.InstallGlobalService;
    }

    public void setInstallGlobalService(boolean flag) {
        this.InstallGlobalService = flag;
    }

    public boolean getUseGlobalService() {
        return this.UseGlobalService;
    }

    public void setUseGlobalService(boolean flag) {
        this.UseGlobalService = flag;
    }

    public EventMgr getEventMgr() {
        return this.eventMgr;
    }

    public void setEventMgr(EventMgr eventMgr) {
        this.eventMgr = eventMgr;
    }

    public SecurityManager getSecurityMgr() {
        return this.securityMgr;
    }

    public void setSecurityMgr(SecurityManager securityMgr) {
        this.securityMgr = securityMgr;
    }

    protected Naming createServer() throws Exception {
        return new NamingServer(null, null, this.eventMgr, this.securityMgr);
    }

    public void start() throws Exception {
        if (this.theServer == null) {
            if (this.UseGlobalService) {
                this.theServer = NamingContext.getLocal();
            }
            if (this.theServer == null) {
                this.theServer = this.createServer();
            } else {
                NamingServerWrapper wrapper = new NamingServerWrapper(this.theServer);
                this.theServer = wrapper;
            }
            log.debug("Using NamingServer: " + this.theServer);
            if (this.InstallGlobalService) {
                NamingContext.setLocal(this.theServer);
                log.debug("Installed global NamingServer: " + this.theServer);
            }
        }
        InitialContext iniCtx = new InitialContext();
        Hashtable<?, ?> env = iniCtx.getEnvironment();
        log.debug("InitialContext Environment: ");
        Object providerURL = null;
        for (Object key : env.keySet()) {
            Object value = env.get(key);
            String type = value == null ? "" : value.getClass().getName();
            log.debug("key=" + key + ", value(" + type + ")=" + value);
            if (!key.equals("java.naming.provider.url")) continue;
            providerURL = value;
        }
        if (providerURL != null) {
            log.warn("Context.PROVIDER_URL in server jndi.properties, url=" + providerURL);
        }
        ClassLoader topLoader = Thread.currentThread().getContextClassLoader();
        ENCFactory.setTopClassLoader(topLoader);
        StringRefAddr refAddr = new StringRefAddr("nns", "ENC");
        Reference envRef = new Reference("javax.namingMain.Context", refAddr, ENCFactory.class.getName(), null);
        Context ctx = (Context)iniCtx.lookup("java:");
        ctx.rebind("comp", (Object)envRef);
        ctx.close();
        iniCtx.close();
    }

    public void stop() {
        if (NamingContext.getLocal() == this.theServer) {
            NamingContext.setLocal(null);
        }
    }
}

