/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.tools.Main;

public class DataTool {
    private static final String BINDING_TYPE = "binding";
    private static final String JOURNAL_TYPE = "journal";
    private static final String JMS_TYPE = "jms";
    private static final String ROLLBACK = "rollback";
    private static final String DELETE = "delete";

    public void process(String[] arg) {
        String exension;
        String journalName;
        File directory;
        if (arg.length < 5) {
            this.printUsage();
            System.exit(-1);
        }
        String type = arg[1];
        String directoryName = arg[2];
        String sizeStr = arg[3];
        if (!type.equals(BINDING_TYPE) && !type.equals(JOURNAL_TYPE)) {
            System.err.println("Invalid type: " + type);
            this.printUsage();
            System.exit(-1);
        }
        if (!(directory = new File(directoryName)).exists() || !directory.isDirectory()) {
            System.err.println("Invalid directory " + directoryName);
            this.printUsage();
            System.exit(-1);
        }
        try {
            long sizeLong = Long.parseLong(sizeStr);
            if (sizeLong <= 0L) {
                System.err.println("Invalid size " + sizeLong);
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.err.println("Error converting journal size: " + e.getMessage() + " couldn't convert size " + sizeStr);
            this.printUsage();
            System.exit(-1);
        }
        if (type.equals(JOURNAL_TYPE)) {
            journalName = "hornetq-data";
            exension = "hq";
        } else if (type.equals(BINDING_TYPE)) {
            journalName = "hornetq-bindings";
            exension = "bindings";
        } else if (type.equals(JMS_TYPE)) {
            journalName = "hornetq-jms";
            exension = JMS_TYPE;
        } else {
            this.printUsage();
            System.exit(-1);
            return;
        }
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(directoryName, null);
        ConfigurationImpl defaultValues = new ConfigurationImpl();
        try {
            long id;
            ArrayList txsToRollback = new ArrayList();
            ArrayList<Long> idsToDelete = new ArrayList<Long>();
            ArrayList<Long> listInUse = null;
            for (int i = 4; i < arg.length; ++i) {
                String str = arg[i];
                if (str.equals(DELETE)) {
                    listInUse = idsToDelete;
                    continue;
                }
                if (str.equals(ROLLBACK)) {
                    listInUse = txsToRollback;
                    continue;
                }
                try {
                    if (listInUse == null) {
                        System.err.println("You must specify either delete or rollback as a command for the IDs you're using");
                        this.printUsage();
                        System.exit(-1);
                    }
                    id = Long.parseLong(str);
                    listInUse.add(id);
                    continue;
                }
                catch (Throwable e) {
                    System.err.println("Error converting id " + str + " as a recordID");
                    this.printUsage();
                    System.exit(-1);
                }
            }
            JournalImpl messagesJournal = new JournalImpl(defaultValues.getJournalFileSize(), defaultValues.getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, journalName, exension, 1);
            messagesJournal.start();
            messagesJournal.loadInternalOnly();
            Iterator i$ = txsToRollback.iterator();
            while (i$.hasNext()) {
                long tx = (Long)i$.next();
                System.out.println("Rolling back " + tx);
                try {
                    messagesJournal.appendRollbackRecord(tx, true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            i$ = idsToDelete.iterator();
            while (i$.hasNext()) {
                id = (Long)i$.next();
                System.out.println("Deleting record " + id);
                try {
                    messagesJournal.appendDeleteRecord(id, true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            messagesJournal.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printUsage() {
        int i;
        for (i = 0; i < 10; ++i) {
            System.err.println();
        }
        System.err.println(Main.USAGE + " binding|journal <directory> <size> [rollback | delete] record1,record2..recordN");
        System.err.println();
        System.err.println("Example:");
        System.err.println("say you wanted to rollback a prepared TXID=100, and you want to remove records 300, 301, 302:");
        System.err.println(Main.USAGE + " journal /tmp/your-folder 10485760 rollback 100 delete 300 301 302");
        System.err.println();
        System.err.println(".. and you can specify as many rollback and delete you like");
        for (i = 0; i < 10; ++i) {
            System.err.println();
        }
    }
}

