/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SingleResultNode;
import io.quarkus.qute.TemplateNode;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

class ExpressionNode
implements TemplateNode,
Function<Object, CompletionStage<ResultNode>> {
    final ExpressionImpl expression;
    private final Engine engine;
    private final TemplateNode.Origin origin;

    public ExpressionNode(ExpressionImpl expression, Engine engine, TemplateNode.Origin origin) {
        this.expression = expression;
        this.engine = engine;
        this.origin = origin;
    }

    @Override
    public CompletionStage<ResultNode> resolve(ResolutionContext context) {
        return context.evaluate(this.expression).thenCompose(this);
    }

    @Override
    public CompletionStage<ResultNode> apply(Object result) {
        if (result instanceof ResultNode) {
            return CompletableFuture.completedFuture((ResultNode)result);
        }
        if (result instanceof CompletionStage) {
            return ((CompletionStage)result).thenCompose(this);
        }
        return CompletableFuture.completedFuture(new SingleResultNode(result, this));
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.origin;
    }

    Engine getEngine() {
        return this.engine;
    }

    @Override
    public Set<Expression> getExpressions() {
        return Collections.singleton(this.expression);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExpressionNode [expression=").append(this.expression).append("]");
        return builder.toString();
    }
}

