/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateInstanceBase;
import io.quarkus.qute.Variant;
import io.quarkus.qute.api.ResourcePath;
import io.quarkus.qute.api.VariantTemplate;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.runtime.Startup;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.logging.Logger;
import org.reactivestreams.Publisher;

@Startup(value=0)
@Singleton
public class VariantTemplateProducer {
    private static final Logger LOGGER = Logger.getLogger(VariantTemplateProducer.class);
    @Inject
    Instance<Engine> engine;
    private Map<String, TemplateVariants> templateVariants;

    VariantTemplateProducer(QuteRecorder.QuteContext context) {
        HashMap<String, TemplateVariants> templateVariants = new HashMap<String, TemplateVariants>();
        for (Map.Entry<String, List<String>> entry : context.getVariants().entrySet()) {
            TemplateVariants var = new TemplateVariants(VariantTemplateProducer.initVariants(entry.getKey(), entry.getValue()), entry.getKey());
            templateVariants.put(entry.getKey(), var);
        }
        this.templateVariants = Collections.unmodifiableMap(templateVariants);
        LOGGER.debugf("Initializing Qute variant templates: %s", (Object)templateVariants);
    }

    @Typed(value={VariantTemplate.class})
    @Produces
    VariantTemplate getDefaultVariantTemplate(InjectionPoint injectionPoint) {
        String name = null;
        if (injectionPoint.getMember() instanceof Field) {
            name = injectionPoint.getMember().getName();
        } else {
            AnnotatedParameter parameter = (AnnotatedParameter)injectionPoint.getAnnotated();
            if (parameter.getJavaParameter().isNamePresent()) {
                name = parameter.getJavaParameter().getName();
            } else {
                name = injectionPoint.getMember().getName();
                LOGGER.warnf("Parameter name not present - using the method name as the template name instead %s", (Object)name);
            }
        }
        return new VariantTemplateImpl(name);
    }

    @Typed(value={VariantTemplate.class})
    @Produces
    @ResourcePath(value="ignored")
    VariantTemplate getVariantTemplate(InjectionPoint injectionPoint) {
        ResourcePath path = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ResourcePath.class)) continue;
            path = (ResourcePath)qualifier;
            break;
        }
        if (path == null || path.value().isEmpty()) {
            throw new IllegalStateException("No variant template resource path specified");
        }
        return new VariantTemplateImpl(path.value());
    }

    static String parseMediaType(String suffix) {
        if (suffix.equalsIgnoreCase(".html") || suffix.equalsIgnoreCase(".htm")) {
            return "text/html";
        }
        if (suffix.equalsIgnoreCase(".xml")) {
            return "text/xml";
        }
        if (suffix.equalsIgnoreCase(".txt")) {
            return "text/plain";
        }
        if (suffix.equalsIgnoreCase(".json")) {
            return "application/json";
        }
        LOGGER.warn("Unknown media type for suffix: " + suffix);
        return "application/octet-stream";
    }

    static String parseMediaType(String base, String variant) {
        String suffix = variant.substring(base.length());
        return VariantTemplateProducer.parseMediaType(suffix);
    }

    private static Map<Variant, String> initVariants(String base, List<String> availableVariants) {
        HashMap<Variant, String> map = new HashMap<Variant, String>();
        for (String path : availableVariants) {
            if (base.equals(path)) continue;
            String mediaType = VariantTemplateProducer.parseMediaType(base, path);
            map.put(new Variant(null, mediaType, null), path);
        }
        return map;
    }

    static class TemplateVariants {
        public final Map<Variant, String> variantToTemplate;
        public final String defaultTemplate;

        public TemplateVariants(Map<Variant, String> variants, String defaultTemplate) {
            this.variantToTemplate = variants;
            this.defaultTemplate = defaultTemplate;
        }
    }

    class VariantTemplateInstanceImpl
    extends TemplateInstanceBase {
        private final TemplateVariants variants;

        VariantTemplateInstanceImpl(TemplateVariants variants) {
            this.variants = Objects.requireNonNull(variants);
            this.setAttribute("variants", new ArrayList<Variant>(variants.variantToTemplate.keySet()));
        }

        @Override
        public String render() {
            return this.template().instance().data(this.data()).render();
        }

        @Override
        public CompletionStage<String> renderAsync() {
            return this.template().instance().data(this.data()).renderAsync();
        }

        @Override
        public Publisher<String> publisher() {
            return this.template().instance().data(this.data()).publisher();
        }

        @Override
        public CompletionStage<Void> consume(Consumer<String> consumer) {
            return this.template().instance().data(this.data()).consume(consumer);
        }

        private Template template() {
            Variant selected = (Variant)this.getAttribute("selectedVariant");
            String name = selected != null ? this.variants.variantToTemplate.get(selected) : this.variants.defaultTemplate;
            return ((Engine)VariantTemplateProducer.this.engine.get()).getTemplate(name);
        }
    }

    class VariantTemplateImpl
    implements VariantTemplate {
        private final String baseName;

        VariantTemplateImpl(String baseName) {
            this.baseName = baseName;
        }

        @Override
        public TemplateInstance instance() {
            return new VariantTemplateInstanceImpl((TemplateVariants)VariantTemplateProducer.this.templateVariants.get(this.baseName));
        }

        @Override
        public Set<Expression> getExpressions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGeneratedId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Variant> getVariant() {
            throw new UnsupportedOperationException();
        }
    }
}

